/*******************************************************************************
*
* FILE:          fc_audiomanager_clienthandler_cmbsensor.h
*
* SW-COMPONENT:  FC_AudioManager application
*
* PROJECT:
*
* DESCRIPTION:   CCA client-handler for the service AudioManager_cmbsensor.
*
* AUTHOR:
*
* COPYRIGHT:    (c) 2012 RBEI
*
*******************************************************************************/

#ifndef _FC_AUDIOROUTEMGR_CLIENTHANDLER_AUDIOMANAGER_CMBSENSOR_H_
#define _FC_AUDIOROUTEMGR_CLIENTHANDLER_AUDIOMANAGER_CMBSENSOR_H_

#include "util/Macro.h"
// Include Application Help Library.
#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION_DEMO
#include "ahl_if.h"

// Include message framework interface (AMT, msgfw)
/* Included for Server message definations */

#define FI_S_IMPORT_INTERFACE_FI_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"

#define CMB_FI_S_IMPORT_INTERFACE_CMB_SENSORFI_TYPES
#define CMB_FI_S_IMPORT_INTERFACE_CMB_SENSORFI_ERRORCODES
#define CMB_FI_S_IMPORT_INTERFACE_CMB_SENSORFI_FUNCTIONIDS
#define CMB_FI_S_IMPORT_INTERFACE_CMB_SENSORFI_SERVICEINFO
#include "cmb_fi_if.h"


#include "InternalComponentCommunication/Messages/CarSetting/IDCarSetting.h"
#include "InternalComponentCommunication/InternalCommunicationAdapter.h"

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/

class ahl_tclBaseOneThreadClientHandler;

class fc_audiomanager_tclClientHandler_cmbsensor
      : public ahl_tclBaseOneThreadClientHandler
{
  public:

    fc_audiomanager_tclClientHandler_cmbsensor(tVoid);
    fc_audiomanager_tclClientHandler_cmbsensor(fc_audiomanager_tclApp* poMainAppl);
    virtual ~fc_audiomanager_tclClientHandler_cmbsensor();


    //virtual void MessageNotification(PO_MessageConfig::enID MsgId){};

    /**************************************************************************
    * Assingment Operater, will not be implemented.
    * Avoids Lint Prio 3 warning: Info 1732: new in constructor for class
    * 'fc_audioroutemgr_tclClientHandler_AudioRouteMgr_MediaPlayer' which has no assignment operator.
    * NOTE: This is a technique to disable the assignment operator for this
    * class. So if an attempt for the assignment is made compiler complains.
    **************************************************************************/
    fc_audiomanager_tclClientHandler_cmbsensor& operator=
      (const fc_audiomanager_tclClientHandler_cmbsensor &oClientHandler);

    /***************************************************************************
    * Application specific methods.
    ***************************************************************************/
    tVoid vProcessTimer(tU16 u16TimerId) const;

    /***************************************************************************
    * Overriding ahl_tclBaseOneThreadClientHandler methods.
    ***************************************************************************/
    virtual tVoid vOnServiceAvailable();
    virtual tVoid vOnServiceUnavailable();

    /***************************************************************************
    * Handler function declarations used by message map.
    ***************************************************************************/

    // Add your CCA message handler function prototypes here.

    /***************************************************************************
    * Message map definition macro
    ***************************************************************************/
    private:

   fc_audiomanager_tclApp* poCcaMainApp;

   tVoid vHandleGalaSpeed_Status(amt_tclServiceData* poMessage) const;

   DECLARE_MSG_MAP(fc_audiomanager_tclClientHandler_cmbsensor)
};



#endif // _FC_AUDIOROUTEMGR_CLIENTHANDLER_AUDIOMANAGER_CMBSENSOR_H_

