/*******************************************************************************
*
* FILE:          fc_audiomanager_clienthandler_cmbsensor.h
*
* SW-COMPONENT:  FC_AudioManager application
*
* PROJECT:
*
* DESCRIPTION:   CCA client-handler for the service AudioManager_cmbsensor.
*
* AUTHOR:
*
* COPYRIGHT:    (c) 2012 RBEI
*
*******************************************************************************/

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
//#define ET_TRACE_INFO_ON
#include <etrace_if.h>  // implicitly links osal_if.h

#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include <ahl_if.h>

#include "fc_audiomanager_componentfactory_if.h"
#include "fc_audiomanager_clienthandler_cfcvehicle.h"
#include "InternalComponentCommunication/Messages/CarSetting/IDCarSetting.h"
#include "InternalComponentCommunication/InternalCommunicationAdapter.h"

#include "fc_audiomanager_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_SDVC
#include "trcGenProj/Header/fc_audiomanager_clienthandler_cfcvehicle.cpp.trc.h"
#endif


#define FI_S_IMPORT_INTERFACE_FI_MESSAGE   // import fi_tclVisitorMessage
#include <midw_fi_if.h>
//#define FI_S_IMPORT_INTERFACE_FI_TYPES
#define CFC_FI_S_IMPORT_INTERFACE_CFC_VEHICLEFI_TYPES
#define CFC_FI_S_IMPORT_INTERFACE_CFC_VEHICLEFI_FUNCTIONIDS
#define CFC_FI_S_IMPORT_INTERFACE_CFC_VEHICLEFI_SERVICEINFO
#include <cfc_fi_if.h>




// -----------------------------------------------------------------------------

/* constructor */ fc_audiomanager_tclClientHandler_cfcvehicle ::
  fc_audiomanager_tclClientHandler_cfcvehicle (ahl_tclBaseOneThreadApp* poMainApp)
    : fc_audiomanager_IClientHandler_Vehicle(
      /* Application Pointer          */ poMainApp,
      /* ID of used Service           */ CFC_VEHICLEFI_C_U16_SERVICE_ID,
      /* MajorVersion of used Service */ CFC_VEHICLEFI_C_U16_SERVICE_MAJORVERSION,
      /* MinorVersion of used Service */ CFC_VEHICLEFI_C_U16_SERVICE_MINORVERSION )
{
   // either register for property Speed or Speed_in_Kombi
   vAddAutoRegisterForProperty(CFC_VEHICLEFI_C_U16_SPEED_IN_KOMBI);
   //vAddAutoRegisterForProperty(CFC_VEHICLEFI_C_U16_SPEED);

   ETG_TRACE_USR1(("ClientHandler for cfc_vehicle  established."))
}

// -----------------------------------------------------------------------------

/* virtual destructor */ fc_audiomanager_tclClientHandler_cfcvehicle ::
   ~fc_audiomanager_tclClientHandler_cfcvehicle (tVoid)
{
   ETG_TRACE_USR1(("terminating ClientHandler for cfc_vehicle_fi ..."))
}

// -----------------------------------------------------------------------------

/* virtual */ tVoid fc_audiomanager_tclClientHandler_cfcvehicle ::
   vOnStatus (tU16 u16FID, amt_tclServiceData* poMessage)
{
   if (OSAL_NULL == poMessage)
   {
      ETG_TRACE_FATAL(("vHandleGalaSpeed_Status() - invalid message pointer"))
      return;
   }

   ID_CarSetting oCarSetting (EN_AUDIO_CAR_SPEED_ID, 0);
   switch (u16FID)
   {
      case CFC_VEHICLEFI_C_U16_SPEED:
         {
           cfc_vehiclefi_tclMsgSpeedStatus oStatus;
           (void)fi_tclVisitorMessage(poMessage).s32GetData(oStatus);
            oCarSetting.s16Value = tS16(oStatus.Speed);
      oStatus.vDestroy();
         }
         break;

      case CFC_VEHICLEFI_C_U16_SPEED_IN_KOMBI:
         {
            cfc_vehiclefi_tclMsgSpeed_In_KombiStatus oStatus;
            (void)fi_tclVisitorMessage(poMessage).s32GetData(oStatus);
             oCarSetting.s16Value = (tS16)(oStatus.Value * (oStatus.Unit ? 1.609344 : 1));
             oStatus.vDestroy();
         }
         break;

      default:
         {
            ETG_TRACE_COMP(("vHandleGalaSpeed_Status() - unhandled functionID %u", u16FID))
         }
         return;
   }

   ETG_TRACE_USR4(("Delivering PO Message for GalaSpeed, Type = %d, Speed = %d"
      , oCarSetting.enCarSettingType, oCarSetting.s16Value));


   InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oCarSetting);
}
