/*
 * fc_audiomanager_clienthandler_DiagLog.cpp
 *
 *  Created on: Feb 22, 2014
 *      Author: kma4hi
 */


/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
//#define ET_TRACE_INFO_ON
#include <etrace_if.h>  // implicitly links osal_if.h

#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include <ahl_if.h>

/* Include Diagnostics FI interface */
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLOGFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLOGFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLOGFI_SERVICEINFO
#include <midw_fi_if.h>

#include "InternalCommunicationAdapter.h"
#include "fc_audiomanager_clienthandler_DiagLog.h"

// support ETG trace output
#include "fc_audiomanager_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_AUDIO_DIAGNOSIS
#include "trcGenProj/Header/fc_audiomanager_clienthandler_DiagLog.cpp.trc.h"
#endif


// -----------------------------------------------------------------------------

/* static */ IF_DiagResultHandler*  IF_DiagResultHandler :: _poInstance = NULL;

// -----------------------------------------------------------------------------
// local result conversion function

midw_fi_tcl_e8_TestResult::tenType enGetFIResult(tenTestResult enInternalResult)
{
   switch (enInternalResult)
   {
      case EN_PASSED:
         return midw_fi_tcl_e8_TestResult::FI_EN_PASSED;

      case EN_FAILED:
         return midw_fi_tcl_e8_TestResult::FI_EN_FAILED;

      case EN_PASSEDDIAGNOSTIC:
         return midw_fi_tcl_e8_TestResult::FI_EN_PASSEDDIAGNOSTIC;

      case EN_FAILEDDIAGNOSTIC:
         return midw_fi_tcl_e8_TestResult::FI_EN_FAILEDDIAGNOSTIC;

      case EN_NORESULTDIAGNOSTIC:
         return midw_fi_tcl_e8_TestResult::FI_EN_NORESULTDIAGNOSTIC;

      case EN_DISABLE:
         return midw_fi_tcl_e8_TestResult::FI_EN_DISABLE;

      case EN_ENABLE:
         return midw_fi_tcl_e8_TestResult::FI_EN_ENABLE;

      case EN_NORESULT:
      default:
         return midw_fi_tcl_e8_TestResult::FI_EN_NORESULT;
   }

}

// -----------------------------------------------------------------------------

/* constructor */ fc_audiomanager_tclClientHandler_DiagLog
   :: fc_audiomanager_tclClientHandler_DiagLog (ahl_tclBaseOneThreadApp* poMainAppl)
   : ahl_tclBaseOneThreadClientHandler(
          poMainAppl                                     // Main App Pointer
        , MIDW_DIAGLOGFI_C_U16_SERVICE_ID                // Service Id
        , MIDW_DIAGLOGFI_C_U16_SERVICE_MAJORVERSION      // MajorVersion of Service
        , MIDW_DIAGLOGFI_C_U16_SERVICE_MINORVERSION      // MinorVersion of Service
     )
   , IF_DiagResultHandler()
{
   if (this != IF_DiagResultHandler::_poInstance)
      ETG_TRACE_FATAL(("ClientHandler_DiagLog() - installing secondary instance"))

   // register for property notifications
   vAddAutoRegisterForProperty(MIDW_DIAGLOGFI_C_U16_SENDNEXTTESTRESULT);

   ETG_TRACE_USR1(("ClientHandler_DiagLog established"))
}

// -----------------------------------------------------------------------------

/* virtual destructor */ fc_audiomanager_tclClientHandler_DiagLog
   :: ~fc_audiomanager_tclClientHandler_DiagLog ()
{
   if (this == _poInstance)
      _poInstance = NULL;
}



// =============================================================================
//
//  ahl_tcl  B a s e  O n e T h r e a d  C l i e n t H a n d l e r   overrides
//
// -----------------------------------------------------------------------------

/* virtual */ tVoid fc_audiomanager_tclClientHandler_DiagLog
   :: vOnServiceAvailable()
{
   // Have to send the TestResult to DiagLog right after StartUp

   ETG_TRACE_USR4(("vOnServiceAvailable() - Delivering PO Message for DiagResult request"));
   tTestRequestList oEmptyList;
   ID_CCA_GetDiagResult oDiagRequestMsg (*this, oEmptyList, false);
   InternalCommunicationAdapter::POMessages->DeliverMsg(&oDiagRequestMsg);
}

// -----------------------------------------------------------------------------

/* virtual */ tVoid fc_audiomanager_tclClientHandler_DiagLog
   :: vOnStatus (tU16 u16FID, amt_tclServiceData* poMessage)
{
   // capture CCA status message for the properties we are interested in

   // validate parameters
   if (OSAL_NULL == poMessage)
   {
      ETG_TRACE_FATAL(("vOnStatus() - invalid message pointer"))
      return;
   }
   else if (MIDW_DIAGLOGFI_C_U16_SENDNEXTTESTRESULT != u16FID)
   {
      ETG_TRACE_FATAL(("vOnStatus() - unhandled functionID %u", u16FID))
      return;
   }

   // get message payload
   midw_diaglogfi_tclMsgSendNextTestResultStatus oStatus;
   if (OSAL_ERROR == fi_tclVisitorMessage(poMessage).s32GetData(oStatus))
   {
      ETG_TRACE_FATAL(("vOnStatus() - failed reading SendNextTestResult.Status"))
   }
   else if (FALSE == oStatus.NextTestResultStruct.Status)
   {
      ETG_TRACE_USR4(("vOnStatus() - SendNextTestResult.Status = FALSE - no action"))
   }
   else
   {
      // launch PostOffice notification
      ETG_TRACE_USR4(("vOnStatus() - Delivering PO Message for DiagResult request"))
      ID_CCA_GetDiagResult oDiagRequestMsg (*this, oStatus.NextTestResultStruct.ITCList, false);
      InternalCommunicationAdapter::POMessages->DeliverMsg(&oDiagRequestMsg);
   }

   oStatus.vDestroy();
}

void fc_audiomanager_tclClientHandler_DiagLog::vProcessTTFiscommand(tTestRequestList ResList)
{
  ETG_TRACE_USR4(("fc_audiomanager_tclClientHandler_DiagLog::TTFiscommand() called"));
  ID_CCA_GetDiagResult oDiagRequestMsg(*this, ResList, false);
  InternalCommunicationAdapter::POMessages->DeliverMsg(&oDiagRequestMsg);
}

// -----------------------------------------------------------------------------

/* virtual */ tVoid fc_audiomanager_tclClientHandler_DiagLog
   :: vOnMethodResult (tU16 u16FID, amt_tclServiceData* poMessage)
{
   // capture CCA result message for methods we invoked

   // validate parameters
   if (OSAL_NULL == poMessage)
   {
      ETG_TRACE_FATAL(("vOnOnMethodResult() - invalid message pointer"))
      return;
   }
   else if (MIDW_DIAGLOGFI_C_U16_SAVETESTRESULT != u16FID)
   {
      ETG_TRACE_FATAL(("vOnOnMethodResult() - unhandled functionID %u", u16FID))
      return;
   }

   midw_diaglogfi_tclMsgSaveTestResultMethodResult oResult;
   if (OSAL_ERROR == fi_tclVisitorMessage(poMessage).s32GetData(oResult))
      ETG_TRACE_FATAL(("vOnOnMethodResult() - failed reading SaveTestResult.MethodResult"))
   else if (midw_fi_tcl_e8_MethodResultReply::FI_EN_REJECTED == oResult.Status.enType)
      ETG_TRACE_ERR(("vOnOnMethodResult() - Status = REJECTED"))
   else
      ETG_TRACE_USR4(("vOnOnMethodResult() - Status = Accepted"))

   oResult.vDestroy();
}

// =============================================================================
//
//           I F _ D i a g R e s u l t - H a n d l e r   implementation
//
// -----------------------------------------------------------------------------

/* virtual */ void fc_audiomanager_tclClientHandler_DiagLog
   :: vSaveDiagResult(tTestResultList& roResultList)
{
   // create FI-Data object and fill with data
   midw_diaglogfi_tclMsgSaveTestResultMethodStart oFiData;

   for (tTestResultList::iterator i = roResultList.begin(); i != roResultList.end(); ++i)
   {
      midw_fi_tcl_TestResult oEntry;
      oEntry.TroubleCode = i->u16ID;
      oEntry.Result.enType = enGetFIResult(i->enResult);
      oFiData.TestResultList.TestResultList.push_back(oEntry);
   }
   fi_tclVisitorMessage oMsg(oFiData);
   vInitServiceData(oMsg, /* u16CmdCounter */ 0, MIDW_DIAGLOGFI_C_U16_SAVETESTRESULT, CCA_C_U8_OPCODE_METHODSTART);

   // post to CCA system
   ail_tenCommunicationError enSuccess = _poMainAppl->enPostMessage(&oMsg, TRUE);
   if (AIL_EN_N_NO_ERROR == enSuccess)
      ETG_TRACE_USR3(("fc_audiomanager_tclClientHandler_DiagLog::vSaveDiagResult() - posting CCA message with %u entries"
            , oFiData.TestResultList.TestResultList.size()))
   else
      ETG_TRACE_FATAL(("fc_audiomanager_tclClientHandler_DiagLog::vSaveDiagResult() - FAILED to post CCA message with %u entries"
            , oFiData.TestResultList.TestResultList.size()))

   // free resources
   oFiData.vDestroy();
}

// -----------------------------------------------------------------------------

/* static */ IF_DiagResultHandler*
IF_DiagResultHandler :: poGetDiagResultHandlerInstance()
{
   // pointer to (first) instance of IF_DiagResultHandler
   //  - may be NULL if it is not up

   return IF_DiagResultHandler::_poInstance;
}

// -----------------------------------------------------------------------------

