/*
 * fc_audiomanager_clienthandler_AudioManagerspm.h
 *
 *  Created on: Jan 2, 2013
 *      Author: sss4kor
 */
/*******************************************************************************
*
* FILE:          FC_AudioManager_clienthandler_AudioManagerspm.h
*
* SW-COMPONENT:  FC_Audiomanager application
*
* PROJECT:
*
* DESCRIPTION:   CCA client-handler for the service AudioManagerspm.
*
* AUTHOR:
*
* COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
*
*******************************************************************************/

#ifndef _FC_AUDIOMANAGER_CLIENTHANDLER_AUDIOMANAGERSPM_H_
#define _FC_AUDIOMANAGER_CLIENTHANDLER_AUDIOMANAGERSPM_H_
#include "InternalComponentCommunication/Messages/mute/IDMuteStateHandleVoltage.h"
#include "InternalComponentCommunication/Messages/power/ID_SysPowerMode.h"
#include "InternalComponentCommunication/InternalCommunicationAdapter.h"

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/

class ahl_tclBaseOneThreadClientHandler;
class spm_fi_tcl_SPM_e32_SubStateType;
class fc_audiomanager_tclClientHandler_AudioManagerspm
      : public ahl_tclBaseOneThreadClientHandler, public IF_MessageObserver<PO_MessageConfig::enID>
{
  public:

    fc_audiomanager_tclClientHandler_AudioManagerspm(tVoid);
    fc_audiomanager_tclClientHandler_AudioManagerspm(fc_audiomanager_tclApp* poMainAppl);
    virtual ~fc_audiomanager_tclClientHandler_AudioManagerspm();

    tVoid MessageNotification(PO_MessageConfig::enID MsgId);

    /**************************************************************************
    * Assingment Operater, will not be implemented.
    * Avoids Lint Prio 3 warning: Info 1732: new in constructor for class
    * 'fc_audiomanager_tclClientHandler_AudioManagerspm' which has no assignment operator.
    * NOTE: This is a technique to disable the assignment operator for this
    * class. So if an attempt for the assignment is made compiler complains.
    **************************************************************************/
    fc_audiomanager_tclClientHandler_AudioManagerspm& operator=
      (const fc_audiomanager_tclClientHandler_AudioManagerspm &oClientHandler);

    /***************************************************************************
    * Application specific methods.
    ***************************************************************************/
    tVoid vProcessTimer(tU16 u16TimerId) const;

    /***************************************************************************
    * Overriding ahl_tclBaseOneThreadClientHandler methods.
    ***************************************************************************/
    virtual tVoid vOnServiceAvailable();
    virtual tVoid vOnServiceUnavailable();

    /***************************************************************************
    * Handler function declarations used by message map.
    ***************************************************************************/

    // Add your CCA message handler function prototypes here.

    /***************************************************************************
    * Message map definition macro
    ***************************************************************************/

  private:
    fc_audiomanager_tclApp* m_poMainAppl;
    tBool m_bACCState;
    tVoid vOnMsMuteState_HandleVoltage(amt_tclServiceData* poMessage) const;
    tVoid vOnMsPowerState(amt_tclServiceData* poMessage);
    tVoid vOnStatusSystemState(amt_tclServiceData* poMessage);
    tVoid vAudioStateStatus(amt_tclServiceData* poMessage);
    tVoid vHandleACCStatus(amt_tclServiceData* poMessage);
    tVoid onActiveOnOffTriggerStatus(std::vector<spm_fi_tcl_SPM_e32_SubStateType, std::allocator<spm_fi_tcl_SPM_e32_SubStateType> > tOnOffTriggerList);

   DECLARE_MSG_MAP(fc_audiomanager_tclClientHandler_AudioManagerspm)
};

#endif // _FC_AUDIOMANAGER_CLIENTHANDLER_AUDIOMANAGERSPM_H_



