/*******************************************************************************
 *
 * FILE:          fc_audiomanager_PropertyStatus.h
 *
 * DESCRIPTION:   File to handle the property status.
 *
 * AUTHOR:        Anu Sebastian
 *
 *******************************************************************************/
#ifndef FC_AUDIOMANAGER_PROPERTYSTATUS_H_
#define FC_AUDIOMANAGER_PROPERTYSTATUS_H_

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/
#include "util/Macro.h"
// Include Application Help Library.
#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include "ahl_if.h"


#include "ExternItf/CCA/FI_Message/FI_Includes.h"
#include "fc_audiomanager_main.h"


class PropertyStatus
{
public:
  PropertyStatus(fc_audiomanager_tclApp* poMainAppl);
  PropertyStatus();
   virtual ~PropertyStatus(tVoid);
  tBool bSendEquPresetStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg) const;
   tBool bSetEquPreset(fi_tclVisitorMessage& roVisitorMsg, tBool& bPropertyChanged, tU16& u16ErrorCode) const;
  tBool bSendFaderActivationStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg) const;
  tBool bSendSignalToneVolumeStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg);
private:
  static fc_audiomanager_tclApp *poCcaMainApp;

};


#endif /* FC_AUDIOMANAGER_PROPERTYSTATUS_H_ */
