/*******************************************************************************
 *
 * FILE:          fc_audiomanager_PropertyStatus.cpp
 *
 * DESCRIPTION:   File to handle the property status.
 *
 * AUTHOR:        Anu Sebastian
 *
 *******************************************************************************/

/************************************************************************
 * Includes
 ************************************************************************/

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_SERVICEINFO    // include FI version when loading midw_fi
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_ERRORCODES
#include "fc_audiomanager_PropertyStatus.h"     // implicitly links midw_fi_if.h

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
//#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SOUND_HANDLER
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION
#include "trcGenProj/Header/fc_audiomanager_PropertyStatus.cpp.trc.h"
#endif

#include "fc_audiomanager_trace.h"

//#define SYSTEM_S_IMPORT_INTERFACE_VECTOR
//#include <stl_pif.h>


#include <vector>

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"


using namespace std;

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_audio_if.h"


fc_audiomanager_tclApp*   PropertyStatus::poCcaMainApp  = NULL;

/*******************************************************************************
 *
 * FUNCTION: PropertyStatus::PropertyStatus(fc_audiomanager_tclApp* poMainAppl)
 *
 * DESCRIPTION: Constructor
 *
 * PARAMETERS: fc_audiomanager_tclApp* poMainAppl
 *
 * RETURN TYPE: None
 *
 *******************************************************************************/


PropertyStatus::PropertyStatus(fc_audiomanager_tclApp* poMainAppl)
{
   ETG_TRACE_USR4(("PropertyStatus() entered."));
   PropertyStatus::poCcaMainApp = poMainAppl;
}

/*******************************************************************************
 *
 * FUNCTION: PropertyStatus::PropertyStatus()
 *
 * DESCRIPTION:Default Constructor
 *
 * PARAMETERS:None
 *
 * RETURN TYPE: None
 *
 *******************************************************************************/

PropertyStatus::PropertyStatus()
{
}

/*******************************************************************************
 *
 * FUNCTION: PropertyStatus::~PropertyStatus()
 *
 * DESCRIPTION:Destructor
 *
 * PARAMETERS:None
 *
 * RETURN TYPE: None
 *
 *******************************************************************************/

PropertyStatus::~PropertyStatus()
{
     ETG_TRACE_USR4(("~PropertyStatus() entered."));
     PropertyStatus::poCcaMainApp = NULL;
}

/*******************************************************************************
 *
 * FUNCTION: PropertyStatus::bSendEquPresetStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg)

 *******************************************************************************/

tBool PropertyStatus:: bSendEquPresetStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* /* poInMsg */) const
{
  midw_mascffi_tclMsgEqualiserPresetStatus oEquPresetStatus;

  oEquPresetStatus.EquPreset.enType = midw_fi_tcl_e8_EquPresets::FI_EN_AUDIO_EQU_PRESET_0;
  oEquPresetStatus.Resource.enType = midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_LS;

  fi_tclVisitorMessage oCCaMsg(oEquPresetStatus);

  oEquPresetStatus.vDestroy();

  return oCCaMsg.bHandOver(&roOutMsg);
}

tBool PropertyStatus::bSetEquPreset(fi_tclVisitorMessage& roVisitorMsg, tBool& bPropertyChanged, tU16& u16ErrorCode) const
{
   midw_mascffi_tclMsgEqualiserPresetSet inmsg;
   (tVoid)bPropertyChanged;

   if(roVisitorMsg.s32GetData(inmsg, MIDW_MASCFFI_C_U16_SERVICE_MAJORVERSION) != OSAL_ERROR)
   {
      ETG_TRACE_USR3(("vSetEquPreset() Type=0x%x, ignored", (tU8)inmsg.EquPreset.enType));
   }

   // we do not handle this setting, so reject
   u16ErrorCode = MIDW_MASCFFI_C_U16_ERROR_DISABLED;
   return FALSE;
}

/*******************************************************************************
 *
 * FUNCTION: PropertyStatus::bSendFaderActivationStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg)

 *******************************************************************************/

tBool PropertyStatus::bSendFaderActivationStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* /* poInMsg */) const
{
  midw_mascffi_tclMsgFaderActivationStatusStatus oFaderActivationStatus;

  oFaderActivationStatus.FaderStatus.enType = midw_fi_tcl_e8_FaderStatus::FI_EN_AUDIO_FADERSTATUS_INACTIVE;

  fi_tclVisitorMessage oCCaMsg(oFaderActivationStatus);

  oFaderActivationStatus.vDestroy();

  return oCCaMsg.bHandOver(&roOutMsg);
}

