/*
 * AudioUserDpPIVI.h
 *
 * PIVI specific implementation of AudioUserDpIf interface
 *
 * Author : prm4kor
 */

#include "AudioUserDpPIVI.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_audio_if.h"

/*****************GET FUNCTIONS**********************/

tS32 AudioUserDpPIVI::s32GetTreble(tS8& s8Value)
{
   dp_tclAudioManagerUsrDPTreble_Multi oTreble;
   return oTreble.s32GetData(s8Value);
}

tS32 AudioUserDpPIVI::s32GetBass(tS8& s8Value)
{
   dp_tclAudioManagerUsrDPBass_Multi oBass;
   return oBass.s32GetData(s8Value);
}

tS32 AudioUserDpPIVI::s32GetMidRange(tS8& s8Value)
{
   dp_tclAudioManagerUsrDPMidRange_Multi oMidRange;
   return oMidRange.s32GetData(s8Value);
}

tS32 AudioUserDpPIVI::s32GetBalance(tS8& s8Value)
{
   dp_tclAudioManagerUsrDPBalance_Multi oBalance;
   return oBalance.s32GetData(s8Value);
}
tS32 AudioUserDpPIVI::s32GetFader(tS8& s8Value)
{
   dp_tclAudioManagerUsrDPFader_Multi oFader;
   return oFader.s32GetData(s8Value);
}
tS32 AudioUserDpPIVI::s32GetBeepLevel(tU8& u8Value)
{
   dp_tclAudioManagerUsrDPBeepLevel_Multi oDPBeepLevel;
   return oDPBeepLevel.s32GetData(u8Value);
}
tS32 AudioUserDpPIVI::s32GetGala(tU8& u8Value)
{
   dp_tclAudioManagerUsrDPGala_Multi oGala;
   return oGala.s32GetData(u8Value);
}
tS32 AudioUserDpPIVI::s32GetParkAssistVolume(tU8& u8Value)
{
  dp_tclAudioManagerUsrDPAdas_ParkAssitVol_Multi odpParkAssitVol;
  return odpParkAssitVol.s32GetData(u8Value);
}
/*****************SET FUNCTIONS**********************/

tS32 AudioUserDpPIVI::s32SetTreble(tS8 s8Value)
{
   dp_tclAudioManagerUsrDPTreble_Multi oTreble;
   return oTreble.s32SetData(s8Value);
}
tS32 AudioUserDpPIVI::s32SetBass(tS8 s8Value)
{
   dp_tclAudioManagerUsrDPBass_Multi oBass;
   return oBass.s32SetData(s8Value);
}
tS32 AudioUserDpPIVI::s32SetMidRange(tS8 s8Value)
{
   dp_tclAudioManagerUsrDPMidRange_Multi oMidRange;
   return oMidRange.s32SetData(s8Value);
}
tS32 AudioUserDpPIVI::s32SetBalance(tS8 s8Value)
{
   dp_tclAudioManagerUsrDPBalance_Multi oBalance;
   return oBalance.s32SetData(s8Value);
}
tS32 AudioUserDpPIVI::s32SetFader(tS8 s8Value)
{
   dp_tclAudioManagerUsrDPFader_Multi oFader;
   return oFader.s32SetData(s8Value);
}
tS32 AudioUserDpPIVI::s32SetBeepLevel(tU8 u8Value)
{
   dp_tclAudioManagerUsrDPBeepLevel_Multi oDPBeepLevel;
   return oDPBeepLevel.s32SetData(u8Value);
}
tS32 AudioUserDpPIVI::s32SetGala(tU8 u8Value)
{
   dp_tclAudioManagerUsrDPGala_Multi oGala;
   return oGala.s32SetData(u8Value);
}
tS32 AudioUserDpPIVI::s32SetParkAssistVolume(tU8 u8Value)
{
  dp_tclAudioManagerUsrDPAdas_ParkAssitVol_Multi odpParkAssitVol;
  return odpParkAssitVol.s32SetData(u8Value);
}
