/*
 * AudioUserDpIfSelect.cpp
 *
 * Helper class to select the Audio Usr Dp interface based on the project and variant.
 * Author : prm4kor
 */

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include <etrace_if.h>
#include "fc_audiomanager_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_SOUND
#include "trcGenProj/Header/AudioUserDpIfSelect.cpp.trc.h"
#endif

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_audio_if.h"

#include "AudioUserDpIfSelect.h"
#include "AudioUserDpBase.h"

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_PSA_LINUX
#include "AudioUserDpPSA.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
#include "AudioUserDpPIVI.h"
#include "AudioUserDpAIVI.h"
#endif

#ifdef __AUDIO_UNIT_TESTING__
#include "AudioUserDpMock.h"
#endif

#define OEM_TYPE_INFINITI     0x16

AudioUserDpIf* AudioUserDpIfSelect::m_pAudioUsrDpIf = NULL;

AudioUserDpIf* AudioUserDpIfSelect::pGetAudUsrDpIf()
{
   if(NULL == m_pAudioUsrDpIf)
   {
#if defined __AUDIO_UNIT_TESTING__
      m_pAudioUsrDpIf = new AudioUserDpMock();
#elif defined VARIANT_S_FTR_ENABLE_FEAT_AUDIO_PSA_LINUX
      m_pAudioUsrDpIf = new AudioUserDpPSA();
      ETG_TRACE_USR1(("AudioUserDpIf created for PSA"));
#elif defined VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
      tU8 u8VariantInfo;
      if(DP_S32_NO_ERR == DP_s32GetConfigItem("CMVariantCoding","OEMType", &u8VariantInfo, 1))
      {
         if(OEM_TYPE_INFINITI == u8VariantInfo)
         {
            m_pAudioUsrDpIf = new AudioUserDpPIVI();
            ETG_TRACE_USR1(("AudioUserDpIf created for P-IVI"));
         }
         else
         {
            m_pAudioUsrDpIf = new AudioUserDpAIVI();
            ETG_TRACE_USR1(("AudioUserDpIf created for A-IVI"));
         }
      }
      else
      {
         m_pAudioUsrDpIf = new AudioUserDpBase();
         ETG_TRACE_ERR(("reading OEMType failed"));
      }
#else
      m_pAudioUsrDpIf = new AudioUserDpBase();
      ETG_TRACE_USR1(("AudioUserDpIf created for G3G projects"));
#endif
   }

   return m_pAudioUsrDpIf;
}

tVoid AudioUserDpIfSelect::vDeleteAudUsrDpIf()
{
   if(NULL != m_pAudioUsrDpIf)
   {
      delete m_pAudioUsrDpIf;
      m_pAudioUsrDpIf = NULL;
   }
}
