/*
 * AudioUserDpIf.h
 *
 * Storing some of the settings varies across projects. The difference is mainly due to the datapools.
 * Some settings are to be stored in to "multi" user datapool elements for some projects.
 * Here is an interface file for such settings. Each project can implement and specify the datapool for these settings, based on if the item to be personalized for each user.
 *
 * Author : prm4kor
 */
#ifndef AUDIOUSERDPIF_H_
#define AUDIOUSERDPIF_H_

#define OSAL_S_IMPORT_INTERFACE_TYPES
#include <osal_if.h>

class AudioUserDpIf
{
public:
   virtual ~AudioUserDpIf() {}

   virtual tS32 s32GetTreble(tS8& s8Value) = 0;
   virtual tS32 s32GetBass(tS8& s8Value) = 0;
   virtual tS32 s32GetMidRange(tS8& s8Value) = 0;
   virtual tS32 s32GetBalance(tS8& s8Value) = 0;
   virtual tS32 s32GetFader(tS8& s8Value) = 0;
   virtual tS32 s32GetBeepLevel(tU8& u8Value) = 0;
   virtual tS32 s32GetEquPreset(tU8& u8Value) = 0;
   virtual tS32 s32GetOptimization(tU8& u8Value) = 0;
   virtual tS32 s32GetGala(tU8& u8Value) = 0;
   virtual tS32 s32GetLoudness(tU8& u8Value) = 0;
   virtual tS32 s32GetSurroundLevel(tU8& u8Value) = 0;
   virtual tS32 s32GetCenterGain(tS16& s16Value) = 0;
   virtual tS32 s32GetSubwoofer(tS16& s16Value) = 0;
   virtual tS32 s32GetAutomaticGainControl(tBool& bValue) = 0;
   virtual tS32 s32GetRoomEffect(tU8& u8Value) = 0;
   virtual tS32 s32GetSoundStaging(tU8& u8Value) = 0;
   virtual tS32 s32GetGeometryMode(tU8& u8Value) = 0;
   virtual tS32 s32GetUPASoundtype(tU8& u8Value)=0;
   virtual tS32 s32GetSRSoundState(tU8& u8Value)=0;
   virtual tS32 s32GetAudioPilotMode(tBool& u8Value) = 0;
   virtual tS32 s32GetAudioPilotIntensity(tU8& u8Value) = 0;
   virtual tS32 s32GetParkAssistVolume(tU8& u8Value)= 0;

   virtual tS32 s32SetTreble(tS8 s8Value) = 0;
   virtual tS32 s32SetBass(tS8 s8Value) = 0;
   virtual tS32 s32SetMidRange(tS8 s8Value) = 0;
   virtual tS32 s32SetBalance(tS8 s8Value) = 0;
   virtual tS32 s32SetFader(tS8 s8Value) = 0;
   virtual tS32 s32SetBeepLevel(tU8 u8Value) = 0;
   virtual tS32 s32SetEquPreset(tU8 u8Value) = 0;
   virtual tS32 s32SetOptimization(tU8 u8Value) = 0;
   virtual tS32 s32SetGala(tU8 u8Value) = 0;
   virtual tS32 s32SetLoudness(tU8 u8Value) = 0;
   virtual tS32 s32SetSurroundLevel(tU8 u8Value) = 0;
   virtual tS32 s32SetCenterGain(tS16 s16Value) = 0;
   virtual tS32 s32SetSubwoofer(tS16 s16Value) = 0;
   virtual tS32 s32SetAutomaticGainControl(tBool bValue) = 0;
   virtual tS32 s32SetRoomEffect(tU8 u8Value) = 0;
   virtual tS32 s32SetSoundStaging(tU8 u8Value) = 0;
   virtual tS32 s32SetGeometryMode(tU8 u8Value) = 0;
   virtual tS32 s32SetUPASoundtype(tU8 u8Value)=0;
   virtual tS32 s32SetSRSoundState(tU8 u8Value)=0;
   virtual tS32 s32SetAudioPilotMode(tBool bValue) = 0;
   virtual tS32 s32SetAudioPilotIntensity(tU8 u8Value) = 0;
   virtual tS32 s32SetParkAssistVolume(tU8 u8Value)= 0;
};

#endif //AUDIOUSERDPIF_H_
