
// system headers
//#define SYSTEM_S_IMPORT_INTERFACE_VECTOR
//#include <stl_pif.h>   // implicitly links <osal_if.h>

#include <vector>
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"



// audio persistent data pool
#define DP_S_IMPORT_INTERFACE_FI
#include <dp_audio_if.h>
#include <dp_generic_if.h>
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AIVI_SRC_OFFSET_IN
   #include <dp_diagdebug_if.h>
#endif

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS_CLASSIC
#include "Arkamys/ArkamysDefines.h"
#include "Arkamys/RNAIVI/ArkamysFeatureHandlerRNAIVI.h"
#include "Sound/ArkamysTuningHandlerRNAIVI.h"
#include <netinet/in.h>
#define LIBTYPE_OFFSET 60
#define SDEQ_OFFSET 5589
#endif
// project headers
#include "vd_adr3_Config_Types.h"

//#define KDSLEN_AUDIOPARAMETERSET_COMPLETE     275  //LINT
#define KDSLEN_AUDIOPARAMETERSET_TAG      8
//#define KDSLEN_AUDIOPARAMETERSET_MINORVERSION  2    //LINT
#define KDSLEN_AUDIOPARAMETERSET_PARAMETER1    264



#define KDS_AUDIO_PARAMETER_NAME "AudioPar"
#define KDS_AUDIO_PARAMETER_MAJOR_VERS '2'
//#define KDS_AUDIO_PARAMETER_MINOR_VERS '0' //LINT Prio2 not used

//ToDo where to get it from? From EQU file?
#define NR_OF_STEPS_FOR_EQU 24
#define NR_OF_DATA_SETS_ALLOWED 2


// *****************************************************************************
//
//                             I n t e r f a c e
//
// =============================================================================
//
// project-specific modifier functions according to prototype <pfnADRFileModifier>.
//
// Will be called indirectly within vd_adr3_Config.cpp.

//tVoid vModify_xxx(adr3_tclFile& roFile);

tVoid vModify_Equ(adr3_tclFile& roFile);
tVoid vModify_Delay(adr3_tclFile& roFile);

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AIVI_SRC_OFFSET_IN
tVoid vModify_SourceOffsetIn(adr3_tclFile& roFile);
tVoid vUpdate_SourceOffsetIn(adr3_tclFile& roFile, tU8* eolFile);
#endif

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS_CLASSIC
tVoid vUpdate_SDVCFilter(adr3_tclFile& roFile, tU8* eolFile, tBool& bIsDataChanged);
#endif
tVoid vExpandEquData(tU8* pu8FileBuf, tU8* pKDS, tU16& u16Len);
tBool bIsSoundToolFlagSet(void);
tBool bIsKDSAudioParameterAvailable(void);





// ...

// =============================================================================

// Factory function, returning pointers to below modifying functions
//
// Will be called by sound configuration manager.

pfnADRFileModifier pfnGetModifierFunction(adr3_tenDataFunctionID enDataFID)
{
   // return valid function pointer (&vModify_xxx) if project has to modify
   // the specific ADR3 sound configuration file, otherwise return NULL

   switch (enDataFID)
   {
       case CAR_EQU_DATA_ID:
         return &vModify_Equ;
       case DELAY_DATA_ID:
        return &vModify_Delay;

      case LOUD_LOW_DATA_ID:
      case SDVC_DATA_ID:  //  GALA, speed-dependent volume control
      case BASS_DATA_ID:
      case MID_DATA_ID:
      case TREB_DATA_ID:
      case BAL_DATA_ID:
      case FAD_DATA_ID:
      case SRCOFF_DATA_ID:
      case SDDC_DATA_ID:  // GADK, speed dependent dynamic compression
        return NULL;
      case INPUT_DATA_ID:
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AIVI_SRC_OFFSET_IN
        return &vModify_SourceOffsetIn;
#endif
      case OUTPUT_DATA_ID:
      case LOUD_HIGH_DATA_ID:
      case PREMIX_DATA_ID:
        return NULL;
      case SDVC_FILTER_DATA_ID:
      case OUTPUTPHASE_DATA_ID:
         //return &vModify_xxx;


      default:
         return NULL;
   }
}

// =============================================================================

extern void vSetupCustomerSoundConfiguration()
{
   // nothing to do for gen3g
}

// =============================================================================

extern void vReleaseCustomerSoundConfiguration()
{
   // nothing to do for gen3g
}

// *****************************************************************************
//
//                          p r i v a t e   S e c t i o n
//
// =============================================================================

#include "vd_adr3_Config_Streamers.h"
#include "vd_adr3_Config_DataSection.h"
#include "vd_adr3_Config_MappingSection.h"
#include "vd_adr3_Config_File.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #include "fc_audiomanager_trace.h"
   #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_ADR3_MAIN
   //#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_ADR3MSG_CONFIG
   #include "trcGenProj/Header/RNAIVI_Config.cpp.trc.h"
#endif



// =============================================================================

//tVoid vModify_xxx(adr3_tclFile& /*roFile*/)
//{
//   // use modifiers provided with vd_adr3_Config_xxx.h,
//   // located in ../../aud_sinkmanager/vd_adr3/
//
//   // According to project requirements either patch single values
//   // or completely re-write by first removing all data sets
//}

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AIVI_SRC_OFFSET_IN
tVoid vModify_SourceOffsetIn(adr3_tclFile& roFile)
{
  ETG_TRACE_USR4(("SourceOffsetIn Modify File: %s",roFile.sName));

    adr3_tclSerializer oSerializer(roFile);
  const tU8* pObjData = NULL;
  tU32 u32ObjDataSize =0;
  oSerializer.vViewData(pObjData,u32ObjDataSize);
  //access DP from EOL configuration
  dp_tclDATASET_AID_AUDIO_SRC_OFFSETDataAudioSourceOffset dp_SrcOffsetIn;
    tU8 eolFile[u32ObjDataSize];

    memset(eolFile,0,u32ObjDataSize);
    tS32 s32Res = dp_SrcOffsetIn.s32GetData(eolFile,u32ObjDataSize);
    if(s32Res != u32ObjDataSize)
    {
      ETG_TRACE_FATAL(("DP size (%d)  and EOL size (%d) note equal -> exit",u32ObjDataSize,s32Res));
      return;
    }
    tU32 EolCrc = eolFile[u32ObjDataSize-1];
    EolCrc = (EolCrc<<8)+eolFile[u32ObjDataSize-2];
    EolCrc = (EolCrc<<8)+eolFile[u32ObjDataSize-3];
    EolCrc = (EolCrc<<8)+eolFile[u32ObjDataSize-4];

    tU32 EolVersion = eolFile[0];
    EolVersion = (EolVersion<<8)+eolFile[1];
    EolVersion = (EolVersion<<8)+eolFile[2];
    EolVersion = (EolVersion<<8)+eolFile[3];

    ETG_TRACE_USR4(("EOL CRC = 0x%x, Audio DP CRC = 0x%x",EolCrc, oSerializer.oReadCRC()));

    if( (0 != memcmp(pObjData,eolFile,u32ObjDataSize)) && (EolVersion != 0) )
    {
      ETG_TRACE_USR4(("Update with EOL and send to ADR"));
      //Files are different and EOL is ot 0 (no default)
        //adr3_tclParser oParser(roFile.sName,eolFile,u32ObjDataSize);
        //oParser.vUpdateDatapoolElement();
        //oParser.bSendToADR(INPUT_DATA_ID);
        //memcpy(pObjData,eolFile,u32ObjDataSize);
      vUpdate_SourceOffsetIn(roFile,eolFile);
      oSerializer.vUpdateCRC();
      ETG_TRACE_USR4(("After update DP CRC = %x",oSerializer.oReadCRC()));
    }
    else
    {
      if(EolVersion == 0)
      {
        ETG_TRACE_ERR(("EOL Version is 0 (No valid DP config?)"));
      }
      else
      {
        ETG_TRACE_USR4(("No update with EOL, DP data is equal"));
      }
    }

}
tVoid vUpdate_SourceOffsetIn(adr3_tclFile& roFile, tU8* eolFile)
{

  // this is the data we have (ToDo: check if we keep it now double and if we have to do so)
    tU32 size = roFile.u32SerializedSize();
  adr3_tclDataSection* poData   = roFile.poData;

    ETG_TRACE_USR4(("Serialized size %d",size));

    const adr3_tDataDimensions oDimension = poData->oGetDimensions();
  ETG_TRACE_USR4(("Data size (nr of datasets) = %d",poData->size()));
  ETG_TRACE_USR4(("Dimension: Min=%d, Max=%d, Colums=%d, Rows=%d",
      oDimension.s16Min,oDimension.s16Max,oDimension.u16Columns,oDimension.u16Rows()));


  // attention: here we need a reference otherwise we get a copy and are out of scope
  adr3_tclDataSet& oDataSet = (*poData)[0];
  // this should be done by some parsing
  // 4Byte version
  // 2Byte contentID
  // 2Byte functionID
  // 4Byte node+mappinglines
  // 4Byte data set per mapping line
  // 6Byte mapping line, config item, value
  tU16 u16NrOfSets = poData->size();
  tU16 u16NrOfRows = oDataSet.roGetDimensions().u16Rows();
  tU16 u16NrOfCol  = oDataSet.roGetDimensions().u16Columns;

  tS16 s16Value = 0;    //value of one entry in the dataset
  tU16 u16PosInEOL = 0; //position in the EOL File


  // check to avoid access out of borders
  if(size > 4+u16NrOfSets*(2*u16NrOfRows*u16NrOfCol))
  {
    //position of the first dataset
    u16PosInEOL = size -4 -u16NrOfSets*(2*u16NrOfRows*u16NrOfCol); //this is to skip header: version, contentID, functionID
  }
  else
  {
    ETG_TRACE_FATAL(("AdrSrcOffsetIn is incompatible-> return"));
    return;
  }
  //loop through all the sets
  for(tU16 set=0;set<u16NrOfSets;set++)
  {
    ETG_TRACE_USR4(("Loop Set %d",set));
    //Note: need a new variable because assign operator not available
    adr3_tclDataSet& oTempDataSet = poData->operator[](set);
    adr3_tDataDimensions oDataDimension = oTempDataSet.roGetDimensions();

    //loop all rows of this set
    //ETG_TRACE_USR4(("SrcOffsetIn loop counter rows is %d, Adress = %x",oTempDataDimension.u16Rows(),&(poData->operator[](set))));
    for(tU16 row=0; row<oDataDimension.u16Rows(); row++)
    {
      adr3_tclDataRow oDataRow = oTempDataSet[row];
      //ETG_TRACE_USR4(("Loop Rows %d",row));

      //loop all colums of this row
      //ETG_TRACE_USR4(("SrcOffsetIn loop counter colums is %d",oTempDataDimension.u16Columns));
      for(tU16 u16Col=0; u16Col < oDataDimension.u16Columns; u16Col++)
      {
        //ETG_TRACE_USR4(("Loop Column %d, Data 0x%x",u16Col,(unsigned int)oDataRow[u16Col]));

        // format of values in file is (Low,High)
        s16Value = eolFile[u16PosInEOL+1]; //High
        s16Value = s16Value<<8;
        s16Value = s16Value + eolFile[u16PosInEOL]; //Low

           if(s16Value != oDataRow[u16Col])
        {
          // we are different and overwrite this value
          ETG_TRACE_USR4(("Difference at PosInEol=%d, Col=%d: EOL=%04x, DP=%04x",u16PosInEOL,u16Col,(unsigned short)s16Value,(unsigned short)oDataRow[u16Col]));
          oDataRow[u16Col] = s16Value;
        }
        u16PosInEOL=u16PosInEOL+2; //next tS16

      } // loop the columns
    } // loop the rows
  }
}
#endif



#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS_CLASSIC
tVoid vModify_SDVCFilter(adr3_tclFile& roFile, tU32 u32length, tU8 *u8Data, tBool& bDataChanged)
{
  ETG_TRACE_USR4(("SDVC Filter Modify File : %s",roFile.sName));

    tU8 tempData[u32length];
    OSAL_pvMemorySet(tempData,0,u32length);

   OSAL_pvMemoryCopy(tempData, u8Data, u32length);
   vUpdate_SDVCFilter(roFile, tempData, bDataChanged);

}

tVoid vUpdate_SDVCFilter(adr3_tclFile& roFile, tU8* eolFile, tBool& bIsDataChanged)
{
  // this is the data we have (ToDo: check if we keep it now double and if we have to do so)
    tU32 size = roFile.u32SerializedSize();
  adr3_tclDataSection* poData   = roFile.poData;

    ETG_TRACE_USR4(("Serialized size %d",size));

    const adr3_tDataDimensions oDimension = poData->oGetDimensions();
  ETG_TRACE_USR4(("Data size (nr of datasets) = %d",poData->size()));
  ETG_TRACE_USR4(("Dimension: Min=%d, Max=%d, Colums=%d, Rows=%d",
      oDimension.s16Min,oDimension.s16Max,oDimension.u16Columns,oDimension.u16Rows()));


  // attention: here we need a reference otherwise we get a copy and are out of scope
  adr3_tclDataSet& oDataSet = (*poData)[0];
  // this should be done by some parsing
  // 4Byte version
  // 2Byte contentID
  // 2Byte functionID
  // 4Byte node+mappinglines
  // 4Byte data set per mapping line
  // 6Byte mapping line, config item, value
  tU16 u16NrOfSets = (tU16)poData->size();
  tU16 u16NrOfRows = oDataSet.roGetDimensions().u16Rows();
  tU16 u16NrOfCol  = oDataSet.roGetDimensions().u16Columns;

  tS16 s16Value = 0;    //value of one entry in the dataset
  tU8 u8PosInEOL = 0; //position in the EOL File

  // check to avoid access out of borders
  if(size > (tU32)(4+u16NrOfSets*(2*u16NrOfRows*u16NrOfCol)))
  {
    ETG_TRACE_USR4(("SDVC Filter data is compatible"));
    //position of the first dataset
    //u16PosInEOL = size -4 -u16NrOfSets*(2*u16NrOfRows*u16NrOfCol); //this is to skip header: version, contentID, functionID
  }
  else
  {
    ETG_TRACE_FATAL(("SDVC Filter data is incompatible-> return"));
    return;
  }

  //loop through 2nd data set
  tU8 u8ElemCount = 0;
  tU8 u8NumberOfElem = (tU8)(eolFile[u8PosInEOL] * 2);//number of pairs will be available in the first byte * 2(speed, frequency) = total number of elements
    //Note: need a new variable because assign operator not available
  adr3_tclDataSet& oTempDataSet = poData->operator[](u16NrOfSets - 1); // to get only the 2nd data set
  adr3_tDataDimensions oDataDimension = oTempDataSet.roGetDimensions();

  //loop all rows of this set
  //ETG_TRACE_USR4(("SrcOffsetIn loop counter rows is %d, Adress = %x",oTempDataDimension.u16Rows(),&(poData->operator[](set))));
  //for(tU16 row=0; row<oDataDimension.u16Rows(); row++)
  if(oDataDimension.u16Rows() > 0)
  {
    tU16 row = (tU16)(oDataDimension.u16Rows() - 1);//array notation -> number of rows - 1 gives the row
    adr3_tclDataRow oDataRow = oTempDataSet[row];
    ETG_TRACE_USR4(("Loop last row in this set %d",row));

    //loop all colums of this row
    ETG_TRACE_USR4(("SDVC loop counter columns is %d",oDataDimension.u16Columns));

    u8PosInEOL = 1;//data index
    for(tU16 u16Col=3; u16Col < oDataDimension.u16Columns;)
    {
      //ETG_TRACE_USR4(("Loop Column %d, Data 0x%x",u16Col,(unsigned int)oDataRow[u16Col]));

      if(u8ElemCount < u8NumberOfElem)
      {
        // format of values in file is (Low,High) -> low byte is always 0
        //s16Value = eolFile[u8PosInEOL]; //High
        //s16Value = s16Value<<8;
        //s16Value = s16Value + eolFile[u8PosInEOL]; //Low
        OSAL_pvMemoryCopy(&s16Value, &eolFile[u8PosInEOL], sizeof(tU8));

        if(s16Value != oDataRow[u16Col])
        {
          // we are different and overwrite this value
          ETG_TRACE_USR4(("Difference at PosInEol=%d, Col=%d: EOL=%04x, DP=%04x",u8PosInEOL,u16Col,(unsigned short)s16Value,(unsigned short)oDataRow[u16Col]));
          oDataRow[u16Col] = s16Value;
          bIsDataChanged = true;//update the variable if there is change in data
        }

        u8ElemCount++;
        u8PosInEOL++;
        //u8PosInEOL=u8PosInEOL+2; //next tS16

      }
      else
      {
        ETG_TRACE_USR4(("End of EOL file reached break out of column loop"));
        break;
      }

      u16Col = (tU16)(u16Col + 2);
    } // loop the columns
    u8ElemCount = 0;// reset after end of each row
  } // loop the rows
}
#endif

// Expand teh compressed data from KDS
tVoid vExpandEquData(tU8* pu8FileBuf, tU8* pKDS, tU16& u16Len)
{
   // assume 24 lines (nr of steps, see define)
   tU8 u8Lines;
   tU16 in =0;
   tU16 out =0;

   //ETG_TRACE_USR3(("vExpandEquData from KDS u16Len=%d",u16Len));
   //et_vTraceBinary(TR_CLASS_VD_ADR3_MAIN, TR_LEVEL_FATAL, ET_EN_T8LIST, 144, pKDS, ET_EN_DONE);
   //ETG_TRACE_USR3(("vExpandEquData KDS dump done"));

   for(u8Lines=0; u8Lines < NR_OF_STEPS_FOR_EQU; u8Lines++)
   {
      // High Nibble -> tU8 for FilterID_Nr
      *(pu8FileBuf+out) = ((*(pKDS+in)) & 0xF0) >> 4;
      // Low Nibble -> tU8 for FilterID_Chan
      *(pu8FileBuf+out+1) = ((*(pKDS+in)) & 0x0F);
      // High Nibble -> tU16 for Characteristic (LSB first)
      *(pu8FileBuf+out+2) = ((*(pKDS+in+1)) & 0xF0) >> 4;
      // always 0
      *(pu8FileBuf+out+3) = 0;
      // Low Nibble -> tU16 for Order (LSB first)
      *(pu8FileBuf+out+4) = (*(pKDS+in+1)) & 0x0F;
      // always 0
      *(pu8FileBuf+out+5) = 0;
      // tU16 -> tU16 for Frequency byte order as is
      *(pu8FileBuf+out+6) = *(pKDS+in+2);
      *(pu8FileBuf+out+7) = *(pKDS+in+3);
      // tU8 -> tU16 for Gain (LSB first)
      *(pu8FileBuf+out+8) = *(pKDS+in+4);
      // Gain can be negative -> Check MSB to decide
      if( ( (*(pKDS+in+4)) & 0x80 ) != 0)
      {
         *(pu8FileBuf+out+9) = 0xFF; // negativ
      }
      else
      {
         *(pu8FileBuf+out+9) = 0;
      }
      // tU8 -> tU16 for Qual (LSB first)
      *(pu8FileBuf+out+10) = *(pKDS+in+5);
      *(pu8FileBuf+out+11) = 0;

      // increment offsets for in and out. Each line in is 6 Byte, each line out is 12 Byte
      in=(tU16)(in+6);
      out=(tU16)(out+12);
   }
   // adapt u16Len;
   u16Len = (tU16)(u16Len<<1); // same as *2

   u16Len = out;

   //ETG_TRACE_USR4(("vExpandEquData u16Len=%d",u16Len));
   // Dump the data
   //et_vTraceBinary(TR_CLASS_VD_ADR3_MAIN, TR_LEVEL_FATAL, ET_EN_T8LIST, 144, pu8FileBuf, ET_EN_DONE);
   //et_vTraceBinary(TR_CLASS_VD_ADR3_MAIN, TR_LEVEL_FATAL, ET_EN_T8LIST, 144, pu8FileBuf+144, ET_EN_DONE);
   ETG_TRACE_USR4(("vExpandEquData done, size=%d",u16Len));
}



tVoid vModify_Equ(adr3_tclFile& roFile)
{
  ETG_TRACE_USR4(("Suzuki Equ Modify File: %s",roFile.sName));
  ETG_TRACE_USR4(("Date: %u.%u.%u",roFile.oVersion.day,roFile.oVersion.month,roFile.oVersion.year));

  if(true == bIsSoundToolFlagSet())
  {
    ETG_TRACE_USR4(("SoundToolFlag is set, assume tuning session active. KDS Data not taken."));
    ETG_TRACE_USR4(("Do reset to factory settings first to allow KDS Data take over"));
    return;
  }
  if(false == bIsKDSAudioParameterAvailable())
  {
    ETG_TRACE_USR4(("Could not find AudioParameter tag. KDS for EQU not taken."));
    return;
  }




  // Read KDS
  //dp_tclKdsAudioParameterSet oKdsAudioParameterSet;
  //ToDo: dynamic ?
  tU8 u8Parameter1[KDSLEN_AUDIOPARAMETERSET_PARAMETER1];
  //tU8 u8Res;
  tU16 u16SkipLen;

  if((DP_S32_NO_ERR != DP_s32GetConfigItem("AudioParameterSet","Parameter1", u8Parameter1, KDSLEN_AUDIOPARAMETERSET_PARAMETER1)))
  {
    ETG_TRACE_USR4(("Could not get AudioParameterSet Parameter1. KDS for EQU not taken."));
    return;
  }

    //oKdsAudioParameterSet.u8GetParameter1(u8Parameter1,DP_U8_KDSLEN_AUDIOPARAMETERSET_PARAMETER1);

    // size of the data for delay
  u16SkipLen = (tU16)((u8Parameter1[1] <<8) + u8Parameter1[2]);
  // Skip the delay part
  tU8* pu8KdsEquCompressed = &u8Parameter1[3+u16SkipLen];
  // We should now point to the Equ Data
  if(*pu8KdsEquCompressed != CAR_EQU_DATA_ID)
  {
    ETG_TRACE_ERR(("Error File ID (%d) for EQU not as expected",CAR_EQU_DATA_ID));
    return;
  }

  // ToDo: should we do this dynamic ??
  tU8 u8EquDataExpanded[300];
  tU16 u16Len=0;
  vExpandEquData(u8EquDataExpanded, pu8KdsEquCompressed+3,u16Len);
  //ETG_TRACE_USR4(("Expanded size = %d",u16Len));

  // We dump the data section
  adr3_tclDataSection* poData   = roFile.poData;
  const adr3_tDataDimensions oDimension = poData->oGetDimensions();

  ETG_TRACE_USR4(("Data size = %d",poData->size()));
  ETG_TRACE_USR4(("Dimension: Min=%d, Max=%d, Colums=%d, Rows=%d",
      oDimension.s16Min,oDimension.s16Max,oDimension.u16Columns,oDimension.u16Rows()));

#if 0 // this is just for printout
  for(tU16 u16Sets=0;u16Sets<poData->size();u16Sets++)
  {
    adr3_tclDataSet oDataSet = (*poData)[u16Sets];
    ETG_TRACE_USR4(("Data Set Nr. %d",u16Sets));

    adr3_tDataDimensions oDataDimension = oDataSet.roGetDimensions();
    ETG_TRACE_USR4(("DataDimension: Min=%d, Max=%d, Colums=%d, Rows=%d",
        oDataDimension.s16Min,oDataDimension.s16Max,oDataDimension.u16Columns,oDataDimension.u16Rows()));

    // check how many rows
    for(tU16 row=0; row<oDataDimension.u16Rows(); row++)
    {
      ETG_TRACE_USR4(("Dump row %d",row));
      for(tU16 col=0; col<oDataDimension.u16Columns; col++)
      {
        ETG_TRACE_USR4(("oDataRow[%d]=%d  (0x%04x)",col,(oDataSet[row])[col],(oDataSet[row])[col]));
      }
    }
  }
#endif

    // we expect two Data Sets (Default and CarEQu)
  if(poData->size() == NR_OF_DATA_SETS_ALLOWED)
  {
    // attention: here we need a reference otherwise we get a copy and are out of scope
    adr3_tclDataSet& oDataSet = (*poData)[1];
    adr3_tDataDimensions oDataDimension = oDataSet.roGetDimensions();

    // we are only prepared to handle 2 Sets Default and CAR_EQU
    tS16 s16Value;
    tU16 u16Col = 0;
        tU16 idx=0;
        tBool bChanged = false;

        ETG_TRACE_USR4(("Equ loop counter rows is %d",oDataDimension.u16Rows()));
    for(tU16 row=0; row<oDataDimension.u16Rows(); row++)
    {
      adr3_tclDataRow oDataRow = oDataSet[row];

      ETG_TRACE_USR4(("Equ loop counter colums is %d",oDataDimension.u16Columns));
      for(u16Col=0; u16Col < oDataDimension.u16Columns; u16Col++)
      {
        s16Value=0;
        s16Value = *(u8EquDataExpanded+idx+1); //High
        s16Value = (tS16)(s16Value<<8);
        s16Value = (tS16)(s16Value + *(u8EquDataExpanded+idx)); //Low

        if(s16Value != oDataRow[u16Col])
        {
          // we are different and overwrite this value
          //ETG_TRACE_USR4(("Difference at %d: Kds=%04x, DP=%04x",u16Col,s16Value,oDataRow[u16Col]));
          bChanged=true; // mark that we had at least one modification
          oDataRow[u16Col] = s16Value;
        }
//        else
//        {
//          ETG_TRACE_USR4(("Equal at %d: Kds=%04x, DP=%04x",u16Col,s16Value,oDataRow[u16Col]));
//        }
        idx=(tU16)(idx+2); //u16Columns are 2Bytes and here we go for single bytes in KDS Data
      } // loop the columns
    } // loop the rows
    // check if we had any modification
    if(bChanged==true)
    {
      ETG_TRACE_USR4(("Equ Data was changed"));
    }
    else
    {
      ETG_TRACE_USR4(("Equ Data unchanged"));
    }
  }
  else
  {
    ETG_TRACE_ERR(("Number of DataSets %d is invalid",poData->size()));
  }
}

tVoid vModify_Delay(adr3_tclFile& roFile)
{
  ETG_TRACE_USR4(("Suzuki Delay Modify File: %s",roFile.sName));
  ETG_TRACE_USR4(("Date: %u.%u.%u",roFile.oVersion.day,roFile.oVersion.month,roFile.oVersion.year));

  // if SoundToolFlag is set, we have an ongoing Tuning sesssion and should not take KDS data
  // because the DP data is newer (tuning writes into DP) and is what we want
  if(true == bIsSoundToolFlagSet())
  {
    ETG_TRACE_USR4(("SoundToolFlag is set, assume tuning session. KDS Data not taken."));
    ETG_TRACE_USR4(("Do reset to factory settings first to allow KDS Data take over"));
    return;
  }
  // if we can not find the AudioParameter or identify version conflict we shoudl not take KDS data
  // we assume the configuration is not correct
  if(false == bIsKDSAudioParameterAvailable())
  {
    ETG_TRACE_USR4(("Could not find AudioParameter tag. KDS for DELAY not taken."));
    return;
  }

  // We dump the data section
  adr3_tclDataSection* poData   = roFile.poData;
  const adr3_tDataDimensions oDimension = poData->oGetDimensions();

  // this is the number of Data Sets e.g. Delay for Delay_Off and Car_Delay
  ETG_TRACE_USR4(("Data size = %d",poData->size()));
  ETG_TRACE_USR4(("Dimension: Min=%d, Max=%d, Colums=%d, Rows=%d",
      oDimension.s16Min,oDimension.s16Max,oDimension.u16Columns,oDimension.u16Rows()));

#if 0 // only for debug print
  for(tU16 u16Sets=0;u16Sets<poData->size();u16Sets++)
  {
    adr3_tclDataSet oDataSet = (*poData)[u16Sets];
    ETG_TRACE_USR4(("Data Set Nr. %d",u16Sets));

    adr3_tDataDimensions oDataDimension = oDataSet.roGetDimensions();
    ETG_TRACE_USR4(("DataDimension: Min=%d, Max=%d, Colums=%d, Rows=%d",
        oDataDimension.s16Min,oDataDimension.s16Max,oDataDimension.u16Columns,oDataDimension.u16Rows()));

    // check how many rows
    for(tU16 row=0; row<oDataDimension.u16Rows(); row++)
    {
      ETG_TRACE_USR4(("Dump row %d",row));
      for(tU16 col=0; col<oDataDimension.u16Columns; col++)
      {
        ETG_TRACE_USR4(("oDataRow[%d]=%d",col,(oDataSet[row])[col]));
      }
    }

  }
#endif

  // Read KDS
  //dp_tclKdsAudioParameterSet oKdsAudioParameterSet;
  tU8 u8Parameter1[KDSLEN_AUDIOPARAMETERSET_PARAMETER1];
  //tU8 u8ReadRes;

//  u8ReadRes = oKdsAudioParameterSet.u8GetParameter1(u8Parameter1,DP_U8_KDSLEN_AUDIOPARAMETERSET_PARAMETER1);
//  ETG_TRACE_ERR(("KDS Read Result: %u",u8ReadRes));

  if((DP_S32_NO_ERR != DP_s32GetConfigItem("AudioParameterSet","Parameter1", u8Parameter1, KDSLEN_AUDIOPARAMETERSET_PARAMETER1)))
  {
    ETG_TRACE_USR4(("Could not get AudioParameterSet Parameter1. KDS for Delay not taken."));
    return;
  }

  if(u8Parameter1[0] != DELAY_DATA_ID)
  {
    ETG_TRACE_ERR(("Error File ID for Delay (%d) not as expected",DELAY_DATA_ID));
    //ETG_TRACE_ERR(("Dump: %x,%x,%x,%x",u8Parameter1[0],u8Parameter1[1],u8Parameter1[2],u8Parameter1[3]));
    return;
  }

  //tU8 u8Res;
  //tU16 u16Len = (u8Parameter1[1] <<8) + u8Parameter1[2];

  tU8* pu8KdsDelay = &u8Parameter1[3];
  if(poData->size() == NR_OF_DATA_SETS_ALLOWED)
  {
    // attention: here we need a reference otherwise we get a copy and are out of scope
    adr3_tclDataSet& oDataSet = (*poData)[1];
    adr3_tDataDimensions oDataDimension = oDataSet.roGetDimensions();
    adr3_tclDataRow oDataRow = oDataSet[0]; // we expect only one row

    // we are only prepared to handle 2 Sets OFF and CAR_DELAY
    tS16 s16Value;
    tU16 u16Col = 0;
    tU16 idx=0;
    tBool bChanged = false;

    for(u16Col=0; u16Col<oDataDimension.u16Columns; u16Col++)
    {
      s16Value=0;
      s16Value = *(pu8KdsDelay+idx+1); //High
      s16Value = (tS16)(s16Value<<8);
      s16Value = (tS16)(s16Value + *(pu8KdsDelay+idx)); //Low

      if(s16Value != oDataRow[u16Col])
      {
        // we are different and can leave
        //ETG_TRACE_USR4(("Difference at %d: Kds=%d, DP=%d",u16Col,s16Value,oDataRow[u16Col]));
        oDataRow[u16Col] = s16Value;
        bChanged=true;
      }
      //      else
      //      {
      //        ETG_TRACE_USR4(("Equal at %d: Kds=%d, DP=%d",u16Col,s16Value,oDataRow[u16Col]));
      //      }
      idx=(tU16)(idx+2); // u16Columns are two byte values, idx is used for single bytes in KDS data
    }
    if(bChanged==true)
    {
      ETG_TRACE_USR4(("Equ Data was changed"));
    }
    else
    {
      ETG_TRACE_USR4(("Equ Data unchanged"));
    }
  }
  else
  {
    ETG_TRACE_ERR(("Number of DataSets %d is invalid",poData->size()));
  }
}


tBool bIsSoundToolFlagSet(void)
{
   dp_tclAudioManagerDPSoundToolFlag oSoundToolFlag;
   tU8 u8SoundToolFlag = 0;

   (void)oSoundToolFlag.s32GetData(u8SoundToolFlag); //lint
   if(u8SoundToolFlag == 0)
   {
      return false;
   }
   else
   {
      return true;
   }

}
// Check if AudioParameter is found with expected Major Version
tBool bIsKDSAudioParameterAvailable()
{
  tU8 u8Tag[KDSLEN_AUDIOPARAMETERSET_TAG+1];
  tU8 u8MajorVersion = 0;
  tU8 u8MajorVersionExpected = KDS_AUDIO_PARAMETER_MAJOR_VERS;
  tBool bRet = false;
  tU32 u32CompRes;
  tU32 u32CompSize = KDSLEN_AUDIOPARAMETERSET_TAG;

  // String termination
  OSAL_pvMemorySet(u8Tag,0,KDSLEN_AUDIOPARAMETERSET_TAG+1);

  // Read from KDS
  if((DP_S32_NO_ERR == DP_s32GetConfigItem("AudioParameterSet","Tag", u8Tag, KDSLEN_AUDIOPARAMETERSET_TAG, FALSE)))  // NCG3D-27236
  {
    if((DP_S32_NO_ERR == DP_s32GetConfigItem("AudioParameterSet","MajorVersion", &u8MajorVersion, 1)))
    {
      // check if the parameter name is there
      u32CompRes = OSAL_s32MemoryCompare(u8Tag,KDS_AUDIO_PARAMETER_NAME,KDSLEN_AUDIOPARAMETERSET_TAG);

      if((u32CompRes == 0) && (u8MajorVersion == u8MajorVersionExpected))
      {
        ETG_TRACE_USR3(("MemoryCompare bytes=%d returns 0 - Exp:  MajorVers=%c O.K., Exp:  Tag=%s O.K."
          , u32CompSize,KDS_AUDIO_PARAMETER_MAJOR_VERS, KDS_AUDIO_PARAMETER_NAME));
        // Return true if KDS Name matches
        bRet = true;
      }
      else
      {
        if(u32CompRes != 0)
        {
          ETG_TRACE_ERR(("MemoryCompare bytes=%d returns %d - Read: Tag=%s ERROR"
            , u32CompSize, u32CompRes, u8Tag));
        }
        if(u8MajorVersion != u8MajorVersionExpected)
        {
          ETG_TRACE_ERR(("MemoryCompare bytes=%d returns %d - Read: MajorVers=%c ERROR"
            , u32CompSize, u32CompRes, u8MajorVersion));
        }
      }
    }
    else
    {
      ETG_TRACE_ERR(("DP_s32GetConfigItem for AudioParameterSet and MajorVersion failed"));
    }

  }
  else
  {
    ETG_TRACE_ERR(("DP_s32GetConfigItem for AudioParameterSet failed"));
  }

  return (bRet);
}
// =============================================================================
