/*
 * plugin-receiver.h
 *
 *  Created on: Jan 20, 2014
 *      Author: rjk2kor
 */

#ifndef PLUGIN_RECEIVER_H_
#define PLUGIN_RECEIVER_H_

#include "../../../ext_amp_plugins/template/interface/vdamp-plugin-receive.h"
#include "../../../ext_amp_plugins/template/interface/vdamp-plugin-types.h"
#include "../../../ext_amp_plugins/template/interface/vdamp-plugin-send.h"

#include "../../fc_audiomanager_main.h"
#include "../../fc_audiomanager_trace.h"
#include "../../fc_audiomanager_trace_input.h"
#include "../vd_adr3/vd_adr3_If.h"
#include "../../InternalComponentCommunication/DataTypes/TypeDefines/ADR3StreamType.h"
#include "../../InternalComponentCommunication/DataTypes/MessageDataTypes/AmpVolumeData.h"
#include "../vd_adr3/vd_adr3_main.h"

class vd_adr3_config ;
class plugin_loader;
class vd_adr3_main;
class vd_amp_msg_mute;
class vd_amp_msg_power;
class vd_amp_msg_Settings;
class vd_amp_msg_GraphFilter;
class vd_amp_msg_beep;
class vd_amp_msg_beepparam;
class vd_amp_msg_CarSettings;
class vd_amp_msg_InputVolumeOffset;
class vd_amp_msg_source;
class vd_amp_msg_Surround;
class vd_amp_msg_Volume;
class vd_amp_msg_VolumeOffset;
class vd_amp_msg_ParamFilter;
class vd_amp_msg_PDC_VolumeOffset;

class vd_amp_if_tx_rx : public vdamp_plugin_receiver
{

private:
  //explicit privates


  plugin_loader* m_ptrloader;//Pointer to loader
  vd_adr3_main* m_ptrvdadr3main;
  uint16_t      m_active_plugin;

  vd_amp_msg_mute  *m_po_vd_ampmsg_mute;
  vd_amp_msg_power *m_po_vd_ampmsg_power;
  vd_amp_msg_Settings *m_po_vd_ampmsg_settings;
  vd_amp_msg_GraphFilter *m_po_vd_ampmsg_graphfilter;
  vd_amp_msg_beep *m_po_vd_ampmsg_beep;
  vd_amp_msg_beepparam *m_po_vd_ampmsg_beepparam;
  vd_amp_msg_CarSettings *m_po_vd_ampmsg_carsettings;
  vd_amp_msg_InputVolumeOffset *m_po_vd_ampmsg_inputvoloffset;
  vd_amp_msg_source *m_po_vd_ampmsg_source;
  vd_amp_msg_Surround *m_po_vd_ampmsg_surround;
  vd_amp_msg_Volume *m_po_vd_ampmsg_volume;
  vd_amp_msg_VolumeOffset *m_po_vd_ampmsg_volumeoffset;
  vd_amp_msg_ParamFilter *m_po_vd_ampmsg_paramfilter;
  vd_amp_msg_PDC_VolumeOffset *m_po_ampmsg_PDCVolumeOffset;
    tenStream Stream;
    tU8 VolStep;
    tS16 VoldB;
    tU16 RampLin;
    tU16 RampdB;

    AmpVolumeData Obj_VolumeData;

    void vSenderFunctionInit(vdamp_plugin_sender* Target);

  void vReloadData(tU8 AmpConfig);

  bool m_extAmpconnected;

public:
  vd_amp_if_tx_rx();
  vd_amp_if_tx_rx(const vd_amp_if_tx_rx&);
  vd_amp_if_tx_rx(plugin_loader*, vd_adr3_main*);
  virtual ~vd_amp_if_tx_rx();
  /**
  * Default destructor
  */

  /**
   * General receiver functions
   */
  virtual void vChangeConfig(tU8 AmplifierConfig);
  virtual void vPluginConnect(vdamp_pluginID_t  pluginID, bool bCompatible);
  virtual void vAmp_IndPowerState(vdamp_pluginID_t  pluginID, amp_tenPowerStatus enStatus, amp_tenPowerState enState);
  virtual void vAmp_ErrPowerState(vdamp_pluginID_t  pluginID, uint8_t ubErrorCode);
    virtual void vAmp_IndSource(vdamp_pluginID_t  pluginID, amp_tenStream enStream,amp_tenSource enSource);
    virtual void vAmp_IndSource_UnMapped(vdamp_pluginID_t  pluginID, amp_tenStream enStream,amp_tenSource_unmapped enSource);
    virtual void vAmp_ErrSource(vdamp_pluginID_t  pluginID, uint8_t ubErrorCode);
  virtual void vAmp_IndVolume(vdamp_pluginID_t  pluginID, amp_tenStream enStream, uint8_t ubStep, int16_t swdB, amp_tenVolumeState enState);
  virtual void vAmp_IndVolumePrem2(vdamp_pluginID_t  PluginID, uint8_t VolumeStep, amp_tenExtAmpVolumeType enVolGroup);
  virtual void vAmp_IndVolumeListPrem2(vdamp_pluginID_t  PluginID, uint8_t* List);
    virtual void vAmp_ErrVolume(vdamp_pluginID_t  pluginID, uint8_t ubErrorCode);
  virtual void vAmp_SetFixAdrVolume (vdamp_pluginID_t  pluginID,amp_tenStream enStream, uint8_t ubStep,int16_t swdB,uint16_t uwRampLin,uint16_t uwRampdB);
    virtual void vAmp_IndVolumeOffset(vdamp_pluginID_t  pluginID, int16_t swOffset, amp_tenVolumeOffsetStatus enStatus);
    virtual void vamp_ErrVolumeOffset(vdamp_pluginID_t  pluginID, uint8_t ubErrorCode);
    virtual void vAmp_IndInputVolumeOffset(vdamp_pluginID_t  pluginID, amp_tenStream enStream, uint16_t uwOffset, amp_tenVolumeOffsetStatus enStatus);
    virtual void vAmp_ErrInputVolumeOffset(vdamp_pluginID_t  pluginID, uint8_t ubErrorCode);
    virtual void vAmp_IndSettings(vdamp_pluginID_t  pluginID, amp_tenStream enStream, amp_tenSettingType enSettingType, int16_t swSteps);
    virtual void vAmp_ErrSettings(vdamp_pluginID_t  pluginID, uint8_t ubErrorCode);
    virtual void vAmp_AvailSettings(vdamp_pluginID_t  pluginID, uint16_t swValue);
    virtual void vAmp_IndSetParamFilter(vdamp_pluginID_t  pluginID, uint8_t ubFilterID, amp_tenParamFilterChar enChar,uint8_t ubOrder, uint16_t uwFreq, int16_t swGain,uint8_t ubQ);
    virtual void vAmp_ErrSetParamFilter(vdamp_pluginID_t  pluginID, uint8_t ubErrorCode);
    virtual void vAmp_IndSetGraphFilter(vdamp_pluginID_t  pluginID, uint8_t ubEqID, uint8_t ubBand, int16_t swGain, amp_tenFrequencyIndex enFreqIndex);
    virtual void vAmpErr_SetGraphFilter(vdamp_pluginID_t  pluginID,uint8_t ubErrorCode);
    virtual void vAmp_IndMute(vdamp_pluginID_t  pluginID, amp_tenStream enStream,amp_tenMuteStatus enMuteStatus);
    virtual void vAmp_ErrMute(vdamp_pluginID_t  pluginID,uint8_t ubErrorCode);
    virtual void vAmp_IndBeepParam(vdamp_pluginID_t  pluginID, amp_tenBeepID enSignalBeepID, uint8_t ubSignalToneID,uint16_t uwFreq,int16_t swGain);
    virtual void vAmp_ErrBeepParam(vdamp_pluginID_t  pluginID,uint8_t ubErrorCode);
    virtual void vAmp_IndBeep(vdamp_pluginID_t  pluginID, amp_tenBeepID enSignalBeepID, amp_tenBeepState  enBeepState);
    virtual void vAmp_ErrBeep(vdamp_pluginID_t  pluginID,uint8_t ubErrorCode);
    virtual void vAmp_ErrCarSetting(vdamp_pluginID_t  pluginID, uint8_t ubErrorCode);
    virtual void vAmp_IndSurround(vdamp_pluginID_t  pluginID,uint8_t ubMode, int8_t sbLevel, int8_t sbCenterLevel);
    virtual void vAmp_ErrSurround(vdamp_pluginID_t  pluginID, uint8_t ubErrorCode);
    virtual void vAmp_Tx_ToCCALoopback (vdamp_pluginID_t  pluginID, uint8_t *    ptrStream, size_t datalength  );
    virtual void vAmp_SetADRSoundConfigItem(tU8 ubSoundSystem);
    virtual void vAmp_SetADRSpeakerSoundConfigItem(tU8 ubSpeakerSoundSystem);
  virtual void vAmp_IndPDCVolOffset(vdamp_pluginID_t  pluginID, int16_t swSteps);
  virtual void vAmp_ErrPDCVolOffset(vdamp_pluginID_t  pluginID, uint8_t ErrorCode);
  virtual void vAmp_ConnectionState(vdamp_pluginID_t  pluginID, uint8_t state);
  virtual void vAmp_MainAudioAttenuation(vdamp_pluginID_t  pluginID, int8_t dbValue);
    /**
     * Helper function to get the current active plugin
     */
    uint16_t u16GetActivePlugin()const
    {
      return m_active_plugin;
      //return 1;
    }
     /**
     * Helper function to get the current external amplifier connection status
     */
  bool bGetExtAmplifierConnStatus()const
  {
    return m_extAmpconnected;
  }
};


#endif /* PLUGIN_RECEIVER_H_ */
