/*
 * plugin-loader.h
 */

#ifndef PLUGIN_LOADER_H_
#define PLUGIN_LOADER_H_

//#define SYSTEM_S_IMPORT_INTERFACE_MAP
//#define SYSTEM_S_IMPORT_INTERFACE_STRING
//#include <stl_pif.h>



#include <string>
#include <map>

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"


#include <stdint.h>
#include <inttypes.h>
#include <unistd.h>
#include <dlfcn.h>

#include "../../../ext_amp_plugins/template/interface/vdamp-plugin-send.h"
#include "../../fc_audiomanager_trace_input.h"
using namespace std;

class vdamp_plugin_sender;
class vdamp_plugin_receiver;

class plugin_info
{
public:
  //Absolute path from which plugin has been loaded
  string m_abs_path;
  //Plugin api version
  int m_api_version;
  //Plugin sender pointer
  vdamp_plugin_sender*   m_ptr_sender;
  //Initialize sent ??
  bool m_bInitialized;
  //Handle of the plugin
  void* m_handle;

  plugin_info()
  {
  m_bInitialized = false;
  m_handle = NULL;
  m_api_version = 0;
  m_ptr_sender = 0;
  }

  ~plugin_info()
  {
    m_ptr_sender = NULL;
    m_handle = NULL;
  }

};

typedef vdamp_plugin_sender* (*Fnptrsender)(void);
/**
 * This is an internal class of the plugin manager module.
 * This class will be used to load and unload plugins
 */
class plugin_loader: public fc_audiomanager_tclTraceInput
{
private:
  //Table of plugin ID along with its info
  map<uint16_t, plugin_info> m_loadedplugins;
  //Plugin index counter
  uint16_t   m_pidindex;
  vdamp_plugin_sender* pSender;

public:
  plugin_loader();
  ~plugin_loader();
  virtual void vTraceRx(tU32 size, tPCUChar pcu8Data);
  /**
   * Load/ Unload functions
   */
  enum tenLoadResult {enSuccess = 1, /* enError = -1, */ enDefault = 0};
  tenLoadResult enLoadAllPlugins();
  void vUnLoadAllPlugins();

  bool bInitializePlugins(vdamp_plugin_receiver*);

  string sGetPluginManagerVersion()const;

  /**
   * Internal management functions
   */
  virtual vdamp_plugin_sender* poGetPluginSender(uint16_t pluginid);

  /**
   * get list loaded plugins
   */
  void vGetListLoadedPlugins(void);
  bool bIsPluginDirLoaded();
  Fnptrsender fptrGetPluginFunc(void* x, const char* y)const
  {
    if((x == NULL)||(y==NULL))
      return NULL;
    return (Fnptrsender) dlsym(x, y);//lint !e611
  }

private:
  uint16_t u16LoadPlugin(string plugin_full_path);
  void vUnLoadPlugin(uint16_t pluginid);
};


#endif /* PLUGIN_LOADER_H_ */
