/***********************************************************************
     vd_amp_plugin_loader
************************************************************** */



#include "vd_amp_plugin_loader.h"
#include "vd_amp_plugin_tx_rx.h"


#include <unistd.h>
#include <linux/limits.h>
#include <sys/types.h>
#include <dirent.h>
#include <dlfcn.h>

//#define SYSTEM_S_IMPORT_INTERFACE_STRING
//#define SYSTEM_S_IMPORT_INTERFACE_VECTOR
//#include <stl_pif.h>





#include <string>
#include <vector>

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION
#include "trcGenProj/Header/vd_amp_plugin_loader.cpp.trc.h"
#endif

using namespace std;

//Globals

//Lookup function in all plugins
#define PLUGIN_LOOKUP_FUNCTION "getpluginpointer"

/**
 * Constructor
 */
plugin_loader::plugin_loader()
{
  //REgistering for trace inputs.
  fc_audiomanager_tclApp::theServer()->vRegisterTraceInputs(TRC::enAmpIf, this);

  m_loadedplugins.clear();
  m_pidindex = 0;
  pSender = NULL;
}
/**
 * Destructor
 */
plugin_loader::~plugin_loader()
{
  pSender = NULL;
}
/**
 * Helper function to load a plugin from a particular directory
 */
plugin_loader::tenLoadResult plugin_loader::enLoadAllPlugins()
{

   ETG_TRACE_USR4(("plugin_loader::bLoadAllPlugins() entered "));
  vector<string> library_list;
  //Get list of all shared object files from this directory
  {
    string s1 = "/opt/bosch/audioservice/plugins";

    DIR* plugin_dir = opendir(s1.c_str());
    if(plugin_dir != NULL)
    {
          struct dirent *itemInDirectory = 0;
      itemInDirectory = readdir(plugin_dir);
          while (itemInDirectory != 0)
          {
              unsigned char entryType = itemInDirectory->d_type;
              string entryName = itemInDirectory->d_name;

              bool regularFile = (entryType == DT_REG || entryType == DT_LNK);
              bool sharedLibExtension = ("so" == entryName.substr(entryName.find_last_of(".") + 1));

              if (regularFile && sharedLibExtension)
              {
                string ss = s1 + string("/") + entryName;
                library_list.push_back(ss);
              }
        itemInDirectory = readdir(plugin_dir);
          }
          closedir(plugin_dir);
    }
    else
    {
       ETG_TRACE_USR4(("Plugins directory doesn't exist "));
    }
  }

  if (library_list.empty())
     // no plug-in available - default to on-board amplifier (sound system 1)
     return enDefault;

  for(vector<string>::iterator it1 = library_list.begin(); it1 != library_list.end();it1++)
  {
    if(0xFFFF == u16LoadPlugin(*it1))
    {
      ETG_TRACE_FATAL(("Failed to load: %s", it1->c_str()));
    }
  }

  return enSuccess;
}
/**
 * Initialize all plugins
 */
bool plugin_loader::bInitializePlugins(vdamp_plugin_receiver* ptrreceiver)
{

  for(map<uint16_t, plugin_info>::iterator it = m_loadedplugins.begin();it != m_loadedplugins.end();)
  {
    if(!it->second.m_bInitialized)
    {
      it->second.m_bInitialized = true;
      if(!it->second.m_ptr_sender->bInitPlugin(it->first,ptrreceiver))
      {
        uint16_t pginid = it->first;
        it++;

        ETG_TRACE_USR4(("Failed to initalize the plugin... unloading"));

        vUnLoadPlugin(pginid);

        continue;
      }
    }
    it++;
  }

  return true;
}

/**
 * Load a particular plugin
 */
uint16_t plugin_loader::u16LoadPlugin(string path)
{

  //cout<<"Trying to load :"<<path<<endl;
  ETG_TRACE_USR4(("Trying to load from %s, ",path.c_str()));

  //1. clear all errors
  dlerror();

  //2. open the library dlopen, lazy mode
  void* libraryHandle = dlopen(path.c_str(), RTLD_LAZY);

    const char* dlopen_error = dlerror();
    if (!libraryHandle || dlopen_error)
    {
        if(libraryHandle)
          dlclose(libraryHandle);//Close the library handle
      ETG_TRACE_USR4(("dlopen failed %s ", dlopen_error));
        return false;
    }

    // get entry point from shared lib
    dlerror(); // Clear any existing error

  //3. check for symbol using dlsym
    vdamp_plugin_sender* (*plugincreatefunction)(void);

  plugincreatefunction = fptrGetPluginFunc(libraryHandle, PLUGIN_LOOKUP_FUNCTION);

    const char* dlsym_error = dlerror();

    if (!plugincreatefunction || dlsym_error)
    {
      dlclose(libraryHandle);//Close the library handle

      ETG_TRACE_USR4(("getCreateFunction: Not a valid plugin, Desired entry point not found %s", (dlsym_error)));
    }
    else
    {
    //4. create a instance and add it to internal list
      vdamp_plugin_sender* ptrplugin = (*plugincreatefunction)();
      if(ptrplugin != NULL)
      {
        plugin_info obj;
        obj.m_abs_path = path;
        obj.m_api_version = ptrplugin->iGetPluginSenderAPIVersion();
        obj.m_ptr_sender = ptrplugin;
        obj.m_handle = libraryHandle;
        m_loadedplugins[++m_pidindex] = obj;
        //Plugin is automatically set to unitialized

        ETG_TRACE_USR4(("Plugin loaded at index :%4x", m_pidindex));

        return m_pidindex;
      }
      else
        dlclose(libraryHandle);//Close the library handle
    }
    return 0xFFFF;
}

/**
 * Helper function to unload all loaded plugins
 */
void plugin_loader::vUnLoadAllPlugins()
{
  ETG_TRACE_USR4(("plugin_loader::vUnLoadAllPlugins() entered"));
  for(map<uint16_t, plugin_info>::iterator it = m_loadedplugins.begin();it != m_loadedplugins.end();)
  {
    vUnLoadPlugin(it->first);//Unload

    //Re initalize the iterator
    it = m_loadedplugins.begin();
  }
}

/**
 * Helper function to unload plugins
 */
void plugin_loader::vUnLoadPlugin(uint16_t pluginid)
{

  ETG_TRACE_USR4(("Unloading plugin at index: %x",pluginid));
  map<uint16_t, plugin_info>::iterator it = m_loadedplugins.find(pluginid);
  if(it != m_loadedplugins.end())
  {
    //call deinit plugin
    if(it->second.m_ptr_sender != NULL)
    {
      if(it->second.m_bInitialized)//If initialized, invoke deinit
      {
        it->second.m_ptr_sender->vDeInitPlugin();
      }
      //free memory allocated
      delete it->second.m_ptr_sender;
      it->second.m_ptr_sender = NULL;
    }
    /*if(it->second.m_handle != NULL)//reset observed on dl-close
    {
      //dlclose(it->second.m_handle);
    }*/
    //Remove it from lookup table..;
    m_loadedplugins.erase(it);
  }
}
/**
 * Return a plugin sender pointer, by using its plugin load index
 */
vdamp_plugin_sender* plugin_loader::poGetPluginSender(uint16_t pluginid)
{
  map<uint16_t,plugin_info>::iterator it = m_loadedplugins.find(pluginid);

  if(it != m_loadedplugins.end())
  {
    return it->second.m_ptr_sender;
  }
  return NULL;
}

/**
 * get list of all loaded plugins
 */
void plugin_loader::vGetListLoadedPlugins(void)
{
  for(map<uint16_t, plugin_info>::iterator it = m_loadedplugins.begin();it != m_loadedplugins.end();it++)
  {
    ETG_TRACE_USR4(("Plugin ID : %x",it->first));

    }

}

#define PLUGIN_MGR_VERSION "v02"

string plugin_loader::sGetPluginManagerVersion()const
{
  return string(PLUGIN_MGR_VERSION);
}

/********************************************************************************
 * vTraceRx( )   ////return buffer from CCA to amplifier plugin
 *******************************************************************************/
void plugin_loader::vTraceRx(tU32 size, tPCUChar pcu8Data)
{
  ETG_TRACE_USR4((" vd_amp_If::vTraceRx()."));
  uint16_t plugin_Id;


  if(pcu8Data == NULL)
    return;
  if(size < 4)
    return;

  if( (TRC::enAmpIf == pcu8Data[0]) && (TRC::enAmpResponse == pcu8Data[1]))
  {
    //Extract plugin ID

    plugin_Id = (uint16_t)(((pcu8Data[2])<<8) | pcu8Data[3]);
    ETG_TRACE_USR4(("  pluginID 0x%4x",plugin_Id ));

    map<uint16_t,plugin_info>::iterator it = m_loadedplugins.find(plugin_Id);
    if(it != m_loadedplugins.end())//This data is from a loaded plugin
    {
      if(it->second.m_ptr_sender != NULL)
      {
        if(size == 4)
        {

          it->second.m_ptr_sender->vAmp_Rx_FromCCAThread(NULL,0);
        }
        else
        {

          it->second.m_ptr_sender->vAmp_Rx_FromCCAThread(const_cast<uint8_t*>(&pcu8Data[4]), size - 4);
        }
      }
    }

  }
}

/********************************************************************************
 * bIsPluginDirLoaded( )   //// To check if plugin directory is loaded or not
 *******************************************************************************/
bool plugin_loader::bIsPluginDirLoaded()
{
  if(m_loadedplugins.size() != 0)
    return true;
  return false;
}

