/*
 * vd_amp_msg_volumeoffset.h
 *
 *  Created on: Jan 11, 2014
 *      Author: sea6kor
 */

#ifndef VD_AMP_MSG_VOLUME_H_
#define VD_AMP_MSG_VOLUME_H_

#include "InternalCommunicationAdapter.h"
#include "../../../PostOffice/PostOffice.hpp"
#include "../vd_amp_if/vd_amp_plugin_loader.h"
#include "../vd_amp_if/vd_amp_plugin_tx_rx.h"
#include "../../../ext_amp_plugins/template/interface/vdamp-plugin-send.h"
#include "../../../ext_amp_plugins/template/interface/vdamp-plugin-receive.h"
#include "../../InternalComponentCommunication/Messages/Volume/ID_Amp_SetVolume.h"
#include "../../InternalComponentCommunication/Messages/Volume/ID_ADRSetVolume.h"
#include "../../InternalComponentCommunication/Messages/Volume/ID_ExtAmpADR_Volume.h"
#include "../../InternalComponentCommunication/Messages/Volume/IDSetExtAmpVolume.h"
#include "../../InternalComponentCommunication/Messages/Volume/ID_AmpVolumeStatus.h"
#include "../../InternalComponentCommunication/Messages/Volume/ID_AmpVolumeListStatus.h"
#include "../../InternalComponentCommunication/Messages/Volume/ID_ExtAmpVolumeList.h"
#include "../../InternalComponentCommunication/Messages/Volume/ID_Premium2Amp_Attenuation.h"
#include "../../InternalComponentCommunication/Messages/BOSE_Amp/ID_BOSE_Amplifier_ConnectionStatus.h"
#include "../../InternalComponentCommunication/DataTypes/TypeDefines/Ext_Amp_ConnectionState.h"
#include "../../InternalComponentCommunication/DataTypes/TypeDefines/SourceDefines.h"
#include "../../InternalComponentCommunication/DataTypes/TypeDefines/VolumeModeDefines.h"
#include "../../InternalComponentCommunication/Messages/BOSE_Amp/ID_MainAudioAttenuation.h"

#include "../vd_adr3/vd_adr3Msg_volume.h"
#include "util/Macro.h"
#include "../vd_adr3/vd_adr3_main.h"

class vd_amp_msg_Volume : public IF_MessageObserver<PO_MessageConfig::enID>
{
public:
  vd_amp_msg_Volume(plugin_loader* ptrloader, vd_amp_if_tx_rx *ptrx, vd_adr3_main* ptrvdadrmain);
  void vd_Amp_Msg_IndVolume(vdamp_pluginID_t  PluginID, amp_tenStream Stream, uint8_t Step, int16_t dB, amp_tenVolumeState State)const;
  void vd_Amp_Msg_IndVolumePrem2(vdamp_pluginID_t  PluginID, uint8_t VolumeStep, amp_tenExtAmpVolumeType enVolGroup);
  void vd_Amp_Msg_IndVolumeListPrem2(vdamp_pluginID_t  PluginID, uint8_t* List);
  void vd_Amp_Msg_ErrVolume(vdamp_pluginID_t  PluginID, uint8_t ErrorCode)const;
  void vd_Amp_Msg_MainAudioAttenuation(vdamp_pluginID_t  PluginID, int8_t dbValue);
  virtual ~vd_amp_msg_Volume()
  {
    InternalCommunicationAdapter::getInstance()->POMessages->DeRegisterObserver(this);
    m_ptrloader = NULL;
    m_ptrreceiver = NULL;
    m_ptrvdadr3main = NULL;
  }
  virtual void MessageNotification(PO_MessageConfig::enID MsgId);
  void vReloadADRData_Volume(tU8 ampconfig,tenStream Stream,tU8 VolStep,tS16 VoldB,tU16 RampLin,tU16 RampdB);
  void vReloadExtAmpData_Volume(tU8 ampconfig);

private:
  void vAddObserver();
  void sendVolumeMessage();
  void sendVolumeListMessage(const map<amp_tenExtAmpVolumeType, tS8>& VolumeList);
  void sendDuckingdBMessage();

  plugin_loader* m_ptrloader ;
  vd_amp_if_tx_rx* m_ptrreceiver;
  vd_adr3_main* m_ptrvdadr3main;
  tU8 m_AmplifierConfig;
  tenStream m_Stream;
  tU8 m_Step;
  tS16 m_dB;
  tU16 m_RampLn;
  tU16 m_RampDb;
  tU16 m_Sink;
  VolumeType m_VolumeType;
  tU8 m_Volume;
  tenVolumeType m_VolumeGroup;

  AmpVolumeData Obj_Volume;
};



#endif /* VD_AMP_MSG_VOLUME_H_ */
