/*
 * vd_amp_msg_volume.cpp
 *
 *  Created on: Jan 11, 2014
 *      Author: sea6kor
 */

#include "vd_amp_msg_volume.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#include "fc_audiomanager_trace.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION
#include "trcGenProj/Header/vd_amp_msg_volume.cpp.trc.h"
#endif



vd_amp_msg_Volume::vd_amp_msg_Volume(plugin_loader* ptrloader, vd_amp_if_tx_rx *ptrx, vd_adr3_main* ptrvdadrmain)
:IF_MessageObserver<PO_MessageConfig::enID>("vd_amp_msg_Volume")
{
  m_ptrloader = ptrloader;
  m_ptrreceiver = ptrx;
  m_ptrvdadr3main = ptrvdadrmain;
  Obj_Volume.m_enStream = (tenStream)0 ;
  Obj_Volume.m_VolStep = 0;
  Obj_Volume.m_VoldB = 0;
  Obj_Volume.m_RampLin = 0;
  Obj_Volume.m_RampdB = 0;
  Obj_Volume.m_Sink = 1; //1-> LoudSpeaker

  m_Stream = (tenStream)0;
  m_Step = 0;
  m_dB = 0;
  m_RampLn = 0;
  m_RampDb = 0;
  m_Sink = 1; //1-> LoudSpeaker
  m_AmplifierConfig = 0;
  m_VolumeType.vSetToDefault();
  m_Volume = 0;
  m_VolumeGroup = EN_VOLTYPE_NONE;
  ETG_TRACE_USR4(("vd_amp_msg_Volume::vd_amp_msg_Volumeconstructor. "));

  vAddObserver();

}

void vd_amp_msg_Volume::vAddObserver()
{

  ETG_TRACE_USR4(("vd_amp_msg_Volume::vAddObserver"));
  InternalCommunicationAdapter* pPO; // Pointer for post office access
  pPO = InternalCommunicationAdapter::getInstance();
  if(pPO != NULL)
  {
    ETG_TRACE_USR4(("vd_amp_msg_Volume::vAddObserver  pPO != NULL"));
    pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_Amp_SetVolume);
      pPO->POMessages->AddObserver(this, PO_MessageConfig::IDSetExtAmpVolume);
      pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_ExtAmpVolumeList);
      pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_BOSE_Amplifier_ConnectionStatus);
      pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_Premium2Amp_Attenuation);
  }

}

void vd_amp_msg_Volume::sendVolumeMessage()
{
  vdamp_plugin_sender* ptr_plugin_sender = NULL;

  if((m_ptrreceiver!=NULL)&&(m_ptrloader!=NULL))
  {
    ETG_TRACE_USR4(("m_ptrMain!=NULL"));
      ptr_plugin_sender  =   m_ptrloader->poGetPluginSender(m_ptrreceiver->u16GetActivePlugin());
  }

  AUD_POINTER_CHECK_CALL_NO_RET_VALUE (ptr_plugin_sender);

  ETG_TRACE_USR4(("oGetInterfaceData called"));
  vdamp_plugin_sender_interfaces tmp = ptr_plugin_sender->oGetInterfaceData();

  AUD_POINTER_CHECK_CALL_NO_RET_VALUE (tmp.m_ptrvolumeSender);
  ETG_TRACE_USR4(("vAmp_Volume called"));

  tmp.m_ptrvolumeSender->vAmp_Volume((amp_tenStream)m_Stream,m_Step,
             (int16_t) m_dB, m_RampLn,m_RampDb);
  tmp.m_ptrvolumeSender->vAmp_VolumeRelative((amp_tenVolumeType)m_VolumeType.getVolumeType(), (uint8_t)m_Volume, (amp_tenExtAmpVolumeType)m_VolumeGroup);
}

void vd_amp_msg_Volume::sendVolumeListMessage(const map<amp_tenExtAmpVolumeType, tS8>& VolumeList)
{
  vdamp_plugin_sender* ptr_plugin_sender = NULL;

  if((m_ptrreceiver!=NULL)&&(m_ptrloader!=NULL))
    {
      ETG_TRACE_USR4(("m_ptrMain!=NULL"));
      ptr_plugin_sender  =   m_ptrloader->poGetPluginSender(m_ptrreceiver->u16GetActivePlugin());
    }

  AUD_POINTER_CHECK_CALL_NO_RET_VALUE (ptr_plugin_sender);

  vdamp_plugin_sender_interfaces tmp = ptr_plugin_sender->oGetInterfaceData();

  AUD_POINTER_CHECK_CALL_NO_RET_VALUE (tmp.m_ptrvolumeSender);
  ETG_TRACE_USR4(("vAmp_VolumeList called"));

  tmp.m_ptrvolumeSender->vAmp_VolumeList(VolumeList);
}

void vd_amp_msg_Volume::MessageNotification(PO_MessageConfig::enID MsgId)
{
  ETG_TRACE_USR4(("vd_amp_msg_Volume::MessageNotification entered. "));
  InternalCommunicationAdapter* pPO; // Pointer for post office access
  pPO = InternalCommunicationAdapter::getInstance();
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE (pPO);
  switch(MsgId)
  {
    case PO_MessageConfig::ID_Amp_SetVolume:
      {
  const ID_Amp_SetVolume*     pMsg = pPO->POMessages->QueryMessage<ID_Amp_SetVolume>(MsgId);

  ETG_TRACE_USR4(("Audio volume Observer received Ramplin: 0x%4x.", pMsg->value.m_RampLin));
  ETG_TRACE_USR4(("Audio volume Observer received Rampdb: 0x%4x.", pMsg->value.m_RampdB));
  ETG_TRACE_USR4(("Audio volume Observer received VolumeStep: 0x%4x.", pMsg->value.m_VolStep));
  ETG_TRACE_USR4(("Audio volume Observer received VoldB: 0x%4x.", pMsg->value.m_VoldB));
  ETG_TRACE_USR4(("Audio volume Observer received Stream: 0x%4x.", pMsg->value.m_enStream));

  m_Stream = pMsg->value.m_enStream;
  m_Step = pMsg->value.m_VolStep;
  m_dB = pMsg->value.m_VoldB;
  m_RampLn =  pMsg->value.m_RampLin;
  m_RampDb =  pMsg->value.m_RampdB;
  m_Sink = pMsg->value.m_Sink;

  if(m_AmplifierConfig == EXTAMP_CONNECTED)
  {
      //Send volume to External amplifier only if it is connected
      sendVolumeMessage();
    }
  else
    ETG_TRACE_USR4(("External amplifier not present.."));
      }
      break;

    case PO_MessageConfig::IDSetExtAmpVolume:
      {
  const IDSetExtAmpVolume*     pMsg = pPO->POMessages->QueryMessage<IDSetExtAmpVolume>(MsgId);
  m_VolumeType.setVolumeType(pMsg->value.m_VolumeType.getVolumeType());
  m_Volume = pMsg->value.m_Volume;

  m_VolumeGroup = pMsg->value.m_VolumeGroup;

  ETG_TRACE_USR4(("Audio volume Observer received m_VolumeType: %d", m_VolumeType.getVolumeType()));
  ETG_TRACE_USR4(("Audio volume Observer received m_Volume: %d", m_Volume));
  ETG_TRACE_USR4(("Audio volume Observer received m_VolumeGroup: %d", pMsg->value.m_VolumeGroup));

  if(m_AmplifierConfig == EXTAMP_CONNECTED)
    {
      //Send volume to External amplifier only if it is connected
      sendVolumeMessage();
    }
  else
    ETG_TRACE_USR4(("External amplifier not present.."));
      }
      break;

    case PO_MessageConfig::ID_BOSE_Amplifier_ConnectionStatus:
      {
        const ID_BOSE_Amplifier_ConnectionStatus* pMsg = pPO->POMessages->QueryMessage<ID_BOSE_Amplifier_ConnectionStatus>(MsgId);

        ETG_TRACE_USR4(("Amplifier status Received : %d", pMsg->connectionstate))

        if(pMsg->connectionstate == (tU8)EXTAMP_CONNECTED)
          {
       ETG_TRACE_USR2(("Bose Ext_Amplifier is connected,Removing irrelevant message observer"));
       InternalCommunicationAdapter::getInstance()->POMessages->RemoveObserver(this, PO_MessageConfig::ID_Amp_SetVolume);
          }
      }
      break;

    case PO_MessageConfig::ID_ExtAmpVolumeList:
      {
  const ID_ExtAmpVolumeList*     pMsg = pPO->POMessages->QueryMessage<ID_ExtAmpVolumeList>(MsgId);

    if(m_AmplifierConfig == EXTAMP_CONNECTED)
      {
        //Reload the latest received Post Office message values

        map<amp_tenExtAmpVolumeType, tS8> volListMap;
        map<tenVolumeType, tS8>::const_iterator it;


        for(it = pMsg->volumeListValue.begin(); it != pMsg->volumeListValue.end(); ++it)
      volListMap.insert(make_pair((amp_tenExtAmpVolumeType)it->first, it->second));

        sendVolumeListMessage(volListMap);
      }
      }
      break;
    case PO_MessageConfig::ID_Premium2Amp_Attenuation:
    {

    const ID_Amp_SetVolume*     pMsg = pPO->POMessages->QueryMessage<ID_Amp_SetVolume>(MsgId);


ETG_TRACE_USR4(("ID_Premium2Amp_Attenuation message received, VolumeStep: 0x%4x, VoldB: 0x%4x, Stream: 0x%4x.", pMsg->value.m_VolStep, pMsg->value.m_VoldB, pMsg->value.m_enStream));

  m_Stream = pMsg->value.m_enStream;
  m_Step = pMsg->value.m_VolStep;
  m_dB = (pMsg->value.m_VoldB);
  if ((m_AmplifierConfig == EXTAMP_CONNECTED) && ((m_Stream == EN_AUDIO_SOURCE_STREAM_MIX1)||(m_Stream == EN_AUDIO_SOURCE_STREAM_MIX2)))
  {
    sendDuckingdBMessage();
  }
  else
    ETG_TRACE_USR4(("External amplifier not present.."));
  }


    break;
    default:
      break;
  }
}
void  vd_amp_msg_Volume::vd_Amp_Msg_IndVolume(vdamp_pluginID_t  PluginID, amp_tenStream Stream, uint8_t Step, int16_t dB, amp_tenVolumeState State)const
{
  ETG_TRACE_USR4(("vd_Amp_Msg_IndVolume:Received Stream: 0x%4x  ", Stream));
  ETG_TRACE_USR4(("vd_Amp_Msg_IndVolume:Received Step 0x%4x ", Step));
  ETG_TRACE_USR4(("vd_Amp_Msg_IndVolume:Received dB 0x%4x .", dB));
  ETG_TRACE_USR4(("vd_Amp_Msg_IndVolume:Received State 0x%4x .", State));
  ETG_TRACE_USR4(("vd_Amp_Msg_IndVolume:Received Plugin Id 0x%4x .", PluginID));
  (void)PluginID;
}

void vd_amp_msg_Volume::vd_Amp_Msg_IndVolumePrem2(vdamp_pluginID_t  PluginID, uint8_t VolumeStep, amp_tenExtAmpVolumeType VolGroup)
{
  ETG_TRACE_USR4(("vd_Amp_Msg_IndVolumePrem2:Received Step: 0x%4x  ", VolumeStep));
  ETG_TRACE_USR4(("vd_Amp_Msg_IndVolumePrem2:Received VolumeGroup 0x%4x ", VolGroup));

  ID_AmpVolumeStatus obj((tU8)VolumeStep, (tenVolumeType)VolGroup);
  InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&obj);
  (void)PluginID;

}

void vd_amp_msg_Volume::vd_Amp_Msg_IndVolumeListPrem2(vdamp_pluginID_t  PluginID, uint8_t* List)
{
    ETG_TRACE_USR4(("vd_Amp_Msg_IndVolumeListPrem2 update received "));
    ID_AmpVolumeListStatus obj((tU8*)List);
    InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&obj);
    (void)PluginID;
}

void vd_amp_msg_Volume::vd_Amp_Msg_ErrVolume(vdamp_pluginID_t  PluginID, uint8_t ErrorCode)const
{
  ETG_TRACE_USR4(("vd_amp_msg_Settings:Received errorcode 0x%4x from plugin : 0x%4x amp_volume_sender.", ErrorCode,PluginID));
}


void vd_amp_msg_Volume::vReloadADRData_Volume(tU8 ampconfig,tenStream Stream,tU8 VolStep,tS16 VoldB,tU16 RampLin,tU16 RampdB)
{
  ETG_TRACE_USR4(("vReloadADRData_Volume::Amplifier COnfiguration = 0x%4x",ampconfig));

  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_ptrvdadr3main);
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_ptrvdadr3main->m_povd_adr3Msg_volume);

  m_ptrvdadr3main->m_povd_adr3Msg_volume->vHandleObserver_AmpConfig(ampconfig);

  if(ampconfig == EXTAMP_CONNECTED)
  {
    //update to ADR the volume values that are received from the plugin
    Obj_Volume.m_enStream = Stream ;
    Obj_Volume.m_VolStep = VolStep;
    Obj_Volume.m_VoldB = VoldB;
    Obj_Volume.m_RampLin = RampLin;
    Obj_Volume.m_RampdB = RampdB;
    Obj_Volume.m_Sink = 1; // 1 -> LoudSpeaker
   }

   else if(ampconfig == EXTAMP_DISCONNECTED)
   {
     //Reloading the latest received PO message to the ADR when the external amplifier is disconnected.
     Obj_Volume.m_enStream = m_Stream ;
     Obj_Volume.m_VolStep =  m_Step;
     Obj_Volume.m_VoldB =    m_dB;
     Obj_Volume.m_RampLin = m_RampLn;
     Obj_Volume.m_RampdB = m_RampDb;
     Obj_Volume.m_Sink = 1; // 1 -> LoudSpeaker
   }

  ETG_TRACE_USR4(("Posting the PO message ID_ADR_SetVolume"));

  ID_ADR_SetVolume ADR_SetVolume(Obj_Volume);
  InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&ADR_SetVolume);
}

void vd_amp_msg_Volume::vReloadExtAmpData_Volume(tU8 ampconfig)
{
  ETG_TRACE_USR4(("vReloadExtAmpData_Volume() called"));
  m_AmplifierConfig = ampconfig;

  if(ampconfig == EXTAMP_CONNECTED)
  {
    //Reload the latest received Post Office message values
    sendVolumeMessage();
  }

  else
  ETG_TRACE_USR4(("External amplifier not present.."));
}

void vd_amp_msg_Volume::vd_Amp_Msg_MainAudioAttenuation(vdamp_pluginID_t  PluginID, int8_t dbValue)
{
  ETG_TRACE_USR4(("vd_amp_msg_Settings:Received attenuation value 0x%4x from plugin : 0x%4x amp_volume_sender.", dbValue,PluginID));
  ID_MainAudioAttenuation oAttenuationValue(dbValue);
  InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oAttenuationValue);
}

void vd_amp_msg_Volume::sendDuckingdBMessage()
{
uint8_t dB = (uint8_t)std::abs(m_dB);//to send positive value to amplifier
  if(dB > 80)
     dB = 80;

  vdamp_plugin_sender* ptr_plugin_sender = NULL;

  if((m_ptrreceiver!=NULL)&&(m_ptrloader!=NULL))
  {

      ptr_plugin_sender  =   m_ptrloader->poGetPluginSender(m_ptrreceiver->u16GetActivePlugin());
  }

  AUD_POINTER_CHECK_CALL_NO_RET_VALUE (ptr_plugin_sender);

  vdamp_plugin_sender_interfaces tmp = ptr_plugin_sender->oGetInterfaceData();

  AUD_POINTER_CHECK_CALL_NO_RET_VALUE (tmp.m_ptrvolumeSender);
  ETG_TRACE_USR4(("vd_amp_msg_Volume::oGetInterfaceData called,Sending Ducking dB value to plugin %d ",dB));


  tmp.m_ptrvolumeSender->vAmp_DuckingValue((uint8_t)dB ,(amp_tenStream) m_Stream);
}
