/*
 * vd_amp_msg_source.h
 *
 *  Created on: Jan 11, 2014
 *      Author: sea6kor
 */

#ifndef VD_AMP_MSG_SOURCE_H_
#define VD_AMP_MSG_SOURCE_H_

#include "InternalCommunicationAdapter.h"
#include "../../../PostOffice/PostOffice.hpp"
#include "../vd_amp_if/vd_amp_plugin_loader.h"
#include "../vd_amp_if/vd_amp_plugin_tx_rx.h"
#include "../../InternalComponentCommunication/DataTypes/TypeDefines/ADR3StreamType.h"
#include "../../InternalComponentCommunication/Messages/Source/IDSetSource.h"
#include "../../../ext_amp_plugins/template/interface/vdamp-plugin-send.h"
#include "../../../ext_amp_plugins/template/interface/vdamp-plugin-receive.h"
#include "../../InternalComponentCommunication/DataTypes/TypeDefines/Ext_Amp_ConnectionState.h"
#include "util/Macro.h"

class vd_amp_msg_source : public IF_MessageObserver<PO_MessageConfig::enID>
{
public:
  vd_amp_msg_source(plugin_loader* ptrloader, vd_amp_if_tx_rx *ptrx);
  void vd_Amp_Msg_IndSource(vdamp_pluginID_t  PluginID, amp_tenStream Stream,amp_tenSource source)const;
  void vd_Amp_Msg_IndSource_UnMapped(vdamp_pluginID_t  PluginID, amp_tenStream stream,amp_tenSource_unmapped Source)const;
  void vd_Amp_Msg_ErrSource(vdamp_pluginID_t  PluginID, uint8_t ErrorCode)const;
    virtual ~vd_amp_msg_source()
    {
    InternalCommunicationAdapter::getInstance()->POMessages->DeRegisterObserver(this);
      m_ptrloader = NULL;
      m_ptrreceiver = NULL;

    }

    virtual void MessageNotification(PO_MessageConfig::enID MsgId);
    void vReloadExtAmpData_Source(tU8 ampconfig);
private:
    void vAddObserver();
    void sendSourceMessage();

    plugin_loader* m_ptrloader ;
    vd_amp_if_tx_rx* m_ptrreceiver;
    tenStream Stream;
    amp_tenSource_unmapped CCA_AudioSource;
    amp_tenSource SourceType;
    int API_Version;
};


#endif /* VD_AMP_MSG_SOURCE_H_ */
