/*
 * vd_amp_msg_source.cpp
 *
 *  Created on: Jan 11, 2014
 *      Author: sea6kor
 */



#include "vd_amp_msg_source.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#include "fc_audiomanager_trace.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION
#include "trcGenProj/Header/vd_amp_msg_source.cpp.trc.h"
#endif



vd_amp_msg_source::vd_amp_msg_source(plugin_loader* ptrloader, vd_amp_if_tx_rx *ptrx)
:IF_MessageObserver<PO_MessageConfig::enID>("vd_amp_msg_source")
{
  m_ptrloader = ptrloader;
  m_ptrreceiver = ptrx;
  Stream = EN_AUDIO_SOURCE_STREAM_MIX3;
  CCA_AudioSource = EN_AMP_SOURCE_CUE;
  SourceType = EN_AMP_SOURCE_SOURCETYPE_CUE1;
  ETG_TRACE_USR4(("vd_amp_msg_source::vd_amp_msg_source constructor. "));
  API_Version = 0;
  vAddObserver();

}

void vd_amp_msg_source::vAddObserver()
{

  ETG_TRACE_USR4(("vd_amp_msg_source::vAddObserver"));
  InternalCommunicationAdapter* pPO; // Pointer for post office access
  pPO = InternalCommunicationAdapter::getInstance();
  if(pPO != NULL)
  {
    ETG_TRACE_USR4(("vd_amp_msg_source::vAddObserver  pPO != NULL"));
    pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_SetSource);

  }
}

void vd_amp_msg_source::sendSourceMessage()
{
  vdamp_plugin_sender* ptr_plugin_sender = NULL;

  if((m_ptrreceiver!=NULL)&&(m_ptrloader!=NULL))
  {
    ETG_TRACE_USR4(("m_ptrMain!=NULL"));
      ptr_plugin_sender  =   m_ptrloader->poGetPluginSender(m_ptrreceiver->u16GetActivePlugin());
  }

  AUD_POINTER_CHECK_CALL_NO_RET_VALUE (ptr_plugin_sender);

  ETG_TRACE_USR4(("oGetInterfaceData called"));
  vdamp_plugin_sender_interfaces tmp = ptr_plugin_sender->oGetInterfaceData();

  AUD_POINTER_CHECK_CALL_NO_RET_VALUE (tmp.m_ptrsourceSender);

  API_Version = ptr_plugin_sender->iGetPluginSenderAPIVersion();

  ETG_TRACE_USR4(("API version %d", API_Version));

  if(API_Version > 2)
  {
    ETG_TRACE_USR4(("vAmp_Source_Unmapped called"));
    tmp.m_ptrsourceSender->vAmp_Source_Unmapped((amp_tenStream)Stream,CCA_AudioSource);
  }

      ETG_TRACE_USR4(("vAmp_Source called"));
      tmp.m_ptrsourceSender->vAmp_Source((amp_tenStream)Stream,SourceType);

}


void vd_amp_msg_source::MessageNotification(PO_MessageConfig::enID MsgId)
{
  ETG_TRACE_USR4(("vd_amp_msg_source::MessageNotification entered. "));
  InternalCommunicationAdapter* pPO; // Pointer for post office access
  pPO = InternalCommunicationAdapter::getInstance();
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE (pPO);
  const MSG_SetSource*     pMsg = pPO->POMessages->QueryMessage<MSG_SetSource>(MsgId);

  ETG_TRACE_USR4(("Audio source Observer received Stream: 0x%4x.", pMsg->enStream));

  Stream =  pMsg->enStream;
  CCA_AudioSource = (amp_tenSource_unmapped)pMsg->audioSource ;
  SourceType = (amp_tenSource)pMsg->enSourceType ;

    ETG_TRACE_USR4(("Audio Sourcetype Observer received Unmapped source: 0x%4x , Mapped source:0x%4x .", CCA_AudioSource , SourceType));

  sendSourceMessage();
}


void  vd_amp_msg_source::vd_Amp_Msg_IndSource(vdamp_pluginID_t  PluginID, amp_tenStream stream,amp_tenSource Source)const
{
  ETG_TRACE_USR4(("vd_Amp_Msg_IndSource:Received Stream: 0x%4x  ", stream));
  ETG_TRACE_USR4(("vd_Amp_Msg_IndSource:Received Source0x%4x ", Source));
  ETG_TRACE_USR4(("vd_Amp_Msg_IndSource:Received pluginID 0x%4x .", PluginID));

}

void  vd_amp_msg_source::vd_Amp_Msg_IndSource_UnMapped(vdamp_pluginID_t  PluginID, amp_tenStream stream,amp_tenSource_unmapped Source)const
{
  ETG_TRACE_USR4(("vd_Amp_Msg_IndSource_UnMapped:Received Stream: 0x%4x  ", stream));
  ETG_TRACE_USR4(("vd_Amp_Msg_IndSource_UnMapped:Received Source0x%4x ", Source));
  ETG_TRACE_USR4(("vd_Amp_Msg_IndSource_UnMapped:Received pluginID 0x%4x .", PluginID));

}

void vd_amp_msg_source::vd_Amp_Msg_ErrSource(vdamp_pluginID_t  PluginID, uint8_t ErrorCode)const
{
  ETG_TRACE_USR4(("vd_amp_msg_Settings:Received errorcode 0x%4x from plugin : 0x%4x amp_source_sender.", ErrorCode,PluginID));
}

void vd_amp_msg_source::vReloadExtAmpData_Source(tU8 ampconfig)
{
  ETG_TRACE_USR4(("vReloadExtAmpData_Source() called"));

  if(ampconfig == EXTAMP_CONNECTED)
  {
    //Reload the latest received Post Office message values
    sendSourceMessage();
  }

  else
  ETG_TRACE_USR4(("External amplifier not present.."));
}
