/*
 * vd_amp_msg_powerstate.cpp
 *
 *  Created on: Jan 11, 2014
 *      Author: sea6kor
 */

#include "vd_amp_msg_powerstate.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#include "fc_audiomanager_trace.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION
#include "trcGenProj/Header/vd_amp_msg_powerstate.cpp.trc.h"
#endif


vd_amp_msg_power::vd_amp_msg_power(plugin_loader* ptrloader, vd_amp_if_tx_rx *ptrx)
:IF_MessageObserver<PO_MessageConfig::enID>("vd_amp_msg_power")
{
  m_ptrloader = ptrloader;
  m_ptrreceiver = ptrx;
  ETG_TRACE_USR4(("vd_amp_msg_mute::vd_amp_msg_mute constructor. "));
  ApplicationState = AUD_APP_PWR_EVENT_DEFAULT;
  //Appstate_Flag = false;
  ExtAmpState = EN_AUDIO_AMP_POWER_MODE_OFF;
  vAddObserver();
  powerstate = 0x00;
}

void vd_amp_msg_power::vAddObserver()//Observe also for ID_ApplicationStatus.Initialise with APP_State _NORMAL.
{

  ETG_TRACE_USR4(("vd_amp_msg_power::vAddObserver"));
  InternalCommunicationAdapter* pPO; // Pointer for post office access
  pPO = InternalCommunicationAdapter::getInstance();
  if(pPO != NULL)
  {
    ETG_TRACE_USR4(("vd_amp_msg_power::vAddObserver  pPO != NULL"));
    //pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_SysPowerMode);
    pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_ApplicationStatus);
    pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_PowerState);
  }

}

void vd_amp_msg_power::sendApplicationStateMessage()
{
  vdamp_plugin_sender* ptr_plugin_sender = NULL;

  if((m_ptrreceiver!=NULL)&&(m_ptrloader!=NULL))
  {
    ETG_TRACE_USR4(("m_ptrMain!=NULL"));
      ptr_plugin_sender  =   m_ptrloader->poGetPluginSender(m_ptrreceiver->u16GetActivePlugin());
  }


  AUD_POINTER_CHECK_CALL_NO_RET_VALUE (ptr_plugin_sender);

  ETG_TRACE_USR4(("oGetInterfaceData called"));
  vdamp_plugin_sender_interfaces tmp = ptr_plugin_sender->oGetInterfaceData();

  AUD_POINTER_CHECK_CALL_NO_RET_VALUE (tmp.m_ptrappstateSender);

  ETG_TRACE_USR4(("sendApplicationStateMessage called with ApplicationState = %d",ApplicationState));

  tmp.m_ptrappstateSender->vAmp_ApplicationState((tU16)ApplicationState);
}

void vd_amp_msg_power::sendPowerStateMessage()
{
  vdamp_plugin_sender* ptr_plugin_sender = NULL;

  if((m_ptrreceiver!=NULL)&&(m_ptrloader!=NULL))
  {
    ETG_TRACE_USR4(("m_ptrMain!=NULL"));
      ptr_plugin_sender  =   m_ptrloader->poGetPluginSender(m_ptrreceiver->u16GetActivePlugin());
  }


  AUD_POINTER_CHECK_CALL_NO_RET_VALUE (ptr_plugin_sender);

  ETG_TRACE_USR4(("oGetInterfaceData called"));
  vdamp_plugin_sender_interfaces tmp = ptr_plugin_sender->oGetInterfaceData();

  AUD_POINTER_CHECK_CALL_NO_RET_VALUE (tmp.m_ptrpowerSender);

  ETG_TRACE_USR4(("vAmp_PowerState called with ExtAmpState = %d",ExtAmpState));

  tmp.m_ptrpowerSender->vAmp_PowerState((amp_tenPowerState)ExtAmpState);
}

void vd_amp_msg_power::MessageNotification(PO_MessageConfig::enID MsgId)
{
  ETG_TRACE_USR4(("vd_amp_msg_power::MessageNotification entered. "));
  InternalCommunicationAdapter* pPO; // Pointer for post office access
  pPO = InternalCommunicationAdapter::getInstance();
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE (pPO);

  switch(MsgId)
     {
     //case(PO_MessageConfig::ID_SysPowerMode):
    //   {
      //  const ID_SysPowerMode*     pMsg = pPO->POMessages->QueryMessage<ID_SysPowerMode>(MsgId);

      //  ETG_TRACE_USR4(("Power received 0x%4x.", pMsg->PowerState));

      //  powerstate = pMsg->PowerState;
      //    break;
    //   }

     case(PO_MessageConfig::ID_ApplicationStatus):
      {
      const ID_ApplicationStatus*     pMsg = pPO->POMessages->QueryMessage<ID_ApplicationStatus>(MsgId);

      ETG_TRACE_USR4(("ApplicationStatus received state: 0x%4x.", pMsg->value.m_State));

      ApplicationState = pMsg->value.m_State;
      if(ApplicationState== AUD_APP_PWR_EVENT_APP_NORMAL || ApplicationState== AUD_APP_PWR_EVENT_APP_PAUSE || ApplicationState==AUD_APP_PWR_EVENT_APP_OFF || ApplicationState==AUD_APP_PWR_EVENT_APP_DIAGNOSIS)
    {
    sendApplicationStateMessage();
    }
      break;
      }
     case (PO_MessageConfig::ID_PowerState):
     {
       const ID_PowerState*     pMsg = pPO->POMessages->QueryMessage<ID_PowerState>(MsgId);
       ETG_TRACE_USR4(("ID_PowerState received state: 0x%4x.", pMsg->PowerState));
       vUpdateExtAmpState(pMsg->PowerState);
       if(pMsg->Optype != 0x01) //VD_ADR3_OPTYPE_GET
         sendPowerStateMessage();
       break;
     }
     default:
       break;
     }

      //if(powerstate > 1 && powerstate < 5 && Appstate_Flag == false)
      //  ExtAmpState = EN_AUDIO_AMP_POWER_MODE_ON;

      //else if (powerstate <= 1 || Appstate_Flag == true)
      //  ExtAmpState = EN_AUDIO_AMP_POWER_MODE_OFF;



}
  /*******************************************************************************
   *
   * FUNCTION:  vUpdateExtAmpState(tenAdrPowerState AdrPowerState)
   *
   *******************************************************************************/
void vd_amp_msg_power::vUpdateExtAmpState(tenAdrPowerState AdrPowerState)
{
  switch (AdrPowerState)
  {
  case EN_AUDIO_ADR_POWER_STATE_OFF:
    ExtAmpState = EN_AUDIO_AMP_POWER_MODE_OFF;
    break;
  case EN_AUDIO_ADR_POWER_STATE_STANDBY:
    ExtAmpState = EN_AUDIO_AMP_POWER_MODE_STANDBY;
    break;
  case EN_AUDIO_ADR_POWER_STATE_ON:
    ExtAmpState = EN_AUDIO_AMP_POWER_MODE_ON;
    break;
  default:
    break;
  }
}

void  vd_amp_msg_power::vd_Amp_Msg_IndPower(vdamp_pluginID_t  pluginID, amp_tenPowerStatus enStatus, amp_tenPowerState enState)const
{
  ETG_TRACE_USR4(("vd_Amp_Msg_IndPower:Received State: 0x%4x  ", enState));
  ETG_TRACE_USR4(("vd_Amp_Msg_IndPower:Received Status 0x%4x ", enStatus));
  ETG_TRACE_USR4(("vd_Amp_Msg_IndPower:Received pluginID 0x%4x .", pluginID));

  ETG_TRACE_USR4(("Sending Amp response from vd_amp_msg_power."));
  vSendAmpResponse(enStatus,enState);
}


void vd_amp_msg_power::vd_Amp_Msg_ErrPower(vdamp_pluginID_t  pluginID, uint8_t ubErrorCode)const
{
  ETG_TRACE_USR4(("vd_Amp_Msg_ErrPower:Received errorcode 0x%4x from plugin : 0x%4x amp_power_sender.", ubErrorCode,pluginID));
}


void vd_amp_msg_power::vSendAmpResponse(amp_tenPowerStatus enstatus, amp_tenPowerState enstate)const
{
  ETG_TRACE_USR4(("Posting the ID_AmpResposePower PO message"));

  ID_AmpResponsePower AmpResponsePower(enstatus,(tenAdrPowerState)enstate);
  InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&AmpResponsePower);
}

void vd_amp_msg_power::vReloadExtAmpData_Power(tU8 ampconfig)
{
  ETG_TRACE_USR4(("vReloadExtAmpData_Power() called"));

  if(ampconfig == EXTAMP_CONNECTED)
  {
    //Reload the latest received Post Office message values
    sendPowerStateMessage();
  }

  else
  ETG_TRACE_USR4(("External amplifier not present.."));
}
void vd_amp_msg_power::vd_Amp_Msg_ConnectionState(vdamp_pluginID_t  pluginID, uint8_t ubState)const
{
  ETG_TRACE_USR4(("vd_Amp_Msg_ConnectionState:Received connection state 0x%4x from plugin : 0x%4x amp_power_sender.", ubState,pluginID));
  ID_BOSE_Amplifier_ConnectionStatus oAmpConnectionState(ubState);
  InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oAmpConnectionState);
}
