/*
 * vd_amp_msg_mute.cpp
 *
 *  Created on: Jan 8, 2014
 *      Author: sea6kor
 */
#include "vd_amp_msg_mute.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#include "fc_audiomanager_trace.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION
#include "trcGenProj/Header/vd_amp_msg_mute.cpp.trc.h"
#endif

vd_amp_msg_mute::vd_amp_msg_mute(plugin_loader* ptrloader, vd_amp_if_tx_rx *ptrx)
:IF_MessageObserver<PO_MessageConfig::enID>("vd_amp_Msg_mute")
{
  m_ptrloader = ptrloader;
  m_ptrreceiver = ptrx;
  ETG_TRACE_USR4(("vd_amp_msg_mute::vd_amp_msg_mute constructor. "));
  enStream = EN_AUDIO_SOURCE_STREAM_DEFAULT;
  enMuteAction = EN_AUDIO_MUTE_MUTEACTION_Off;
  vAddObserver();

}

void vd_amp_msg_mute::vAddObserver()
{

  ETG_TRACE_USR4(("vd_amp_msg_mute::vAddObserver"));
    InternalCommunicationAdapter* pPO; // Pointer for post office access
  pPO = InternalCommunicationAdapter::getInstance();
  if(pPO != NULL)
  {
    ETG_TRACE_USR4(("vd_amp_msg_mute::vAddObserver  pPO != NULL"));
    pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_SetMute);
  }
}

void vd_amp_msg_mute::sendMuteMessage()
{

  vdamp_plugin_sender* ptr_plugin_sender = NULL;

  if((m_ptrreceiver!=NULL)&&(m_ptrloader!=NULL))
  {
    ETG_TRACE_USR4(("m_ptrMain!=NULL"));
      ptr_plugin_sender  =   m_ptrloader->poGetPluginSender(m_ptrreceiver->u16GetActivePlugin());
  }

  AUD_POINTER_CHECK_CALL_NO_RET_VALUE (ptr_plugin_sender);

  ETG_TRACE_USR4(("oGetInterfaceData called"));
  vdamp_plugin_sender_interfaces tmp = ptr_plugin_sender->oGetInterfaceData();

  AUD_POINTER_CHECK_CALL_NO_RET_VALUE (tmp.m_ptrmuteSenderIF);

  ETG_TRACE_USR4(("vAmp_Mute called"));
  tmp.m_ptrmuteSenderIF->vAmp_Mute((amp_tenStream)enStream,(amp_tenMuteAction)enMuteAction);
}

void vd_amp_msg_mute::MessageNotification(PO_MessageConfig::enID MsgId)
{
  ETG_TRACE_USR4(("vd_adr3Msg_mute::MessageNotification entered. "));
    InternalCommunicationAdapter* pPO;
  pPO = InternalCommunicationAdapter::getInstance();
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE (pPO);
  const ID_SetMute*     pMsg = pPO->POMessages->QueryMessage<ID_SetMute>(MsgId);

  ETG_TRACE_USR4(("Audio mute Observer received Stream: 0x%4x.", pMsg->enStream));
  ETG_TRACE_USR4(("Audio mute Observer received Mute Action: 0x%4x.", pMsg->enMuteAction));
  ETG_TRACE_USR4(("Audio mute Observer received RampLin: 0x%4x.", pMsg->u16RampLin));
  ETG_TRACE_USR4(("Audio mute Observer received RampdB: 0x%4x.", pMsg->u16RampdB));

  enStream = pMsg->enStream ;
  enMuteAction = pMsg->enMuteAction;

  sendMuteMessage();
}


void  vd_amp_msg_mute::vd_Amp_Msg_IndMute(vdamp_pluginID_t  PluginID, amp_tenStream Stream,amp_tenMuteStatus MuteStatus)const
{
  ETG_TRACE_USR4(("vAmp_IndMute:Received Stream: 0x%4x amp_mute_senderfrom ", Stream));
  ETG_TRACE_USR4(("vAmp_IndMute:Received MuteStatus 0x%4x amp_mute_sender.", MuteStatus));
  ETG_TRACE_USR4(("vAmp_IndMute:Received pluginID 0x%4x amp_mute_sender.", PluginID));

  ETG_TRACE_USR4(("Sending Amp response from vd_amp_msg_mute."));
  vSendAmpResponse(Stream,MuteStatus);
}


void vd_amp_msg_mute::vd_Amp_Msg_ErrMute(vdamp_pluginID_t  PluginID,uint8_t ErrorCode)const
{
  ETG_TRACE_USR4(("vAmp_IndMute:Received ErrorCode 0x%4x amp_mute_sender.", ErrorCode));
  ETG_TRACE_USR4(("vAmp_IndMute:Received pluginID 0x%4x amp_mute_sender.", PluginID));
}


void vd_amp_msg_mute::vSendAmpResponse(amp_tenStream stream , amp_tenMuteStatus mutestatus)const
{
  ETG_TRACE_USR4(("vd_amp_msg_mute::vSendAmpResponse()"));
  ETG_TRACE_USR4(("Posting the ID_AmpResposeMute PO message"));

  ID_AmpResponseMute AmpResponseMute((tenStream)stream,(tenMuteResult)mutestatus);
  InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&AmpResponseMute);
}

void vd_amp_msg_mute::vReloadExtAmpData_Mute(tU8 ampconfig)
{
  ETG_TRACE_USR4(("vReloadExtAmpData_Mute() called"));

  if(ampconfig == EXTAMP_CONNECTED)
  {
    //Reload the latest received Post Office message values
    sendMuteMessage();
  }

  else
  ETG_TRACE_USR4(("External amplifier not present.."));

}
