/*
 * vd_amp_msg_VolumeOffset.h
 *
 *  Created on: Jan 13, 2014
 *      Author: sea6kor
 */

#ifndef VD_AMP_MSG_VOLUMEOFFSET_H_
#define VD_AMP_MSG_VOLUMEOFFSET_H_

#include "InternalCommunicationAdapter.h"
#include "../../../PostOffice/PostOffice.hpp"
#include "../vd_amp_if/vd_amp_plugin_loader.h"
#include "../vd_amp_if/vd_amp_plugin_tx_rx.h"
#include "../../../ext_amp_plugins/template/interface/vdamp-plugin-send.h"
#include "../../../ext_amp_plugins/template/interface/vdamp-plugin-receive.h"
#include "../../InternalComponentCommunication/Messages/Volume/IDSetVolumeOffset.h"
#include "../../InternalComponentCommunication/DataTypes/TypeDefines/Ext_Amp_ConnectionState.h"
#include "util/Macro.h"

class vd_amp_msg_VolumeOffset : public IF_MessageObserver<PO_MessageConfig::enID>
{
public:
  vd_amp_msg_VolumeOffset(plugin_loader* ptrloader, vd_amp_if_tx_rx *ptrx);
  void vd_Amp_Msg_IndVolumeOffset(vdamp_pluginID_t  PluginID, int16_t Offset, amp_tenVolumeOffsetStatus Status)const;
  void vd_Amp_Msg_ErrVolumeOffset(vdamp_pluginID_t  PluginID, uint8_t ErrorCode)const;
  virtual ~vd_amp_msg_VolumeOffset()
  {
    InternalCommunicationAdapter::getInstance()->POMessages->DeRegisterObserver(this);
    m_ptrloader = NULL;
    m_ptrreceiver = NULL;

  }
  virtual void MessageNotification(PO_MessageConfig::enID MsgId);
  void vReloadExtAmpData_VolumeOffset(tU8 ampconfig);
private:
    void vAddObserver();
    void sendVolumeOffsetMessage();
  void vReadOffsetDataFromDP();
    plugin_loader* m_ptrloader ;
    vd_amp_if_tx_rx* m_ptrreceiver;
    VolumeOffsetData OffsetValues;
};



#endif /* VD_AMP_MSG_VOLUMEOFFSET_H_ */
