/*
 * vd_amp_msg_Settings.h
 *
 *  Created on: Jan 11, 2014
 *      Author: sea6kor
 */

#ifndef VD_AMP_MSG_SETTINGS_H_
#define VD_AMP_MSG_SETTINGS_H_

#include "InternalCommunicationAdapter.h"
#include "../vd_amp_if/vd_amp_plugin_loader.h"
#include "../vd_amp_if/vd_amp_plugin_tx_rx.h"
#include "../../../ext_amp_plugins/template/interface/vdamp-plugin-send.h"
#include "../../../ext_amp_plugins/template/interface/vdamp-plugin-receive.h"
#include "../../InternalComponentCommunication/Messages/settings/IDSettings.h"
#include "../../InternalComponentCommunication/DataTypes/TypeDefines/Ext_Amp_ConnectionState.h"
#include "util/Macro.h"

class vd_amp_msg_Settings : public IF_MessageObserver<PO_MessageConfig::enID>
{
public:
  vd_amp_msg_Settings(plugin_loader* ptrloader, vd_amp_if_tx_rx *ptrx);
  void vd_Amp_Msg_IndSettings(vdamp_pluginID_t  pluginID, amp_tenStream enStream, amp_tenSettingType enSettingType, int16_t swSteps)const;
  void vd_Amp_Msg_ErrSettings(vdamp_pluginID_t  PluginID, uint8_t ErrorCode)const;
  void vd_Amp_Msg_AvailSetting(vdamp_pluginID_t  PluginID, uint16_t swValue)const;
    virtual ~vd_amp_msg_Settings()
    {
    InternalCommunicationAdapter::getInstance()->POMessages->DeRegisterObserver(this);
      m_ptrloader = NULL;
      m_ptrreceiver = NULL;

    };

    virtual void MessageNotification(PO_MessageConfig::enID MsgId);
    void vReloadExtAmpData_Settings(tU8 ampconfig);
private:
    void vAddObserver();
    void sendSettingsMessage();
    void sendSettingsListMessage(tU8* u8Data, tU16 u16Len);

    plugin_loader* m_ptrloader ;
    vd_amp_if_tx_rx* m_ptrreceiver;

    tU8 m_AmplifierConfig;
    tenStream stream;
    tenSettingType SettingType;
    tS16 Steps;
};


#endif /* VD_AMP_MSG_SETTINGS_H_ */
