/*
 * vd_amp_GraphFilter.h
 *
 *  Created on: Jan 25, 2014
 *      Author: sea6kor
 */

#ifndef VD_AMP_GRAPHFILTER_H_
#define VD_AMP_GRAPHFILTER_H_


#include "InternalCommunicationAdapter.h"
#include "../../../PostOffice/PostOffice.hpp"
#include "../vd_amp_if/vd_amp_plugin_loader.h"
#include "../vd_amp_if/vd_amp_plugin_tx_rx.h"
#include "../../InternalComponentCommunication/Messages/Equ_Filter/IDEquSetting.h"
#include "../../../ext_amp_plugins/template/interface/vdamp-plugin-send.h"
#include "../../../ext_amp_plugins/template/interface/vdamp-plugin-receive.h"
#include "../../InternalComponentCommunication/DataTypes/TypeDefines/Ext_Amp_ConnectionState.h"
#include "util/Macro.h"

class vd_amp_msg_GraphFilter : public IF_MessageObserver<PO_MessageConfig::enID>
{
public:
  vd_amp_msg_GraphFilter(plugin_loader* ptrloader, vd_amp_if_tx_rx *ptrx);
  void vd_Amp_Msg_IndGraphFilter(vdamp_pluginID_t  PluginID, uint8_t EqID, uint8_t Band,
                                     int16_t gain, amp_tenFrequencyIndex FreqIndex)const;
  void vd_Amp_Msg_ErrGraphFilter(vdamp_pluginID_t  PluginID, uint8_t ErrorCode)const;
    virtual ~vd_amp_msg_GraphFilter()
    {
    InternalCommunicationAdapter::getInstance()->POMessages->DeRegisterObserver(this);
      m_ptrloader = NULL;
      m_ptrreceiver = NULL;
     }

    virtual void MessageNotification(PO_MessageConfig::enID MsgId);
    void vReloadExtAmpData_GraphFilter(tU8 ampconfig);
private:
    void vAddObserver();
    void sendGraphFilterMessage();

    plugin_loader* m_ptrloader ;
    vd_amp_if_tx_rx* m_ptrreceiver;

    tU8 EquID;
    tU8 EquBand;
    tS16 Gain;
    tU8 FrequencyIndex;
};





#endif /* VD_AMP_GRAPHFILTER_H_ */
