/*
 * vd_amp_msg_BeepParam.cpp
 *
 *  Created on: Jan 25, 2014
 *      Author: sea6kor
 */

#include "vd_amp_msg_BeepParam.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#include "fc_audiomanager_trace.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION
#include "trcGenProj/Header/vd_amp_msg_BeepParam.cpp.trc.h"
#endif



vd_amp_msg_beepparam::vd_amp_msg_beepparam(plugin_loader* ptrloader, vd_amp_if_tx_rx *ptrx)
:IF_MessageObserver<PO_MessageConfig::enID>("vd_amp_msg_beepparam")
{
  m_ptrloader = ptrloader;
  m_ptrreceiver = ptrx;
  ETG_TRACE_USR4(("vd_amp_msg_beepparam::vd_amp_msg_beepparam constructor. "));

  vAddObserver();

}

void vd_amp_msg_beepparam::vAddObserver()
{

  ETG_TRACE_USR4(("vd_amp_msg_beepparam::vAddObserver"));
  InternalCommunicationAdapter* pPO; // Pointer for post office access
  pPO = InternalCommunicationAdapter::getInstance();
  if(pPO != NULL)
  {
    ETG_TRACE_USR4(("vd_amp_msg_beepparam::vAddObserver  pPO != NULL"));
    pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_SignalToneParameters);
    pPO->POMessages->AddObserver(this, PO_MessageConfig::IDCCAUPATempMute);
  pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_ADASSoundCollection);
  pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_NotifyParkAssistVolume);
  pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_NotifyLDWUserVolume);
    pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_NotifyBeepName);
  }

}

void vd_amp_msg_beepparam::sendBeepParamMessage()
{
  vdamp_plugin_sender* ptr_plugin_sender = NULL;

  if((m_ptrreceiver!=NULL)&&(m_ptrloader!=NULL))
  {
    ETG_TRACE_USR4(("m_ptrMain!=NULL"));
      ptr_plugin_sender  =   m_ptrloader->poGetPluginSender(m_ptrreceiver->u16GetActivePlugin());
  }

  AUD_POINTER_CHECK_CALL_NO_RET_VALUE (ptr_plugin_sender);

  ETG_TRACE_USR4(("oGetInterfaceData called"));
  vdamp_plugin_sender_interfaces tmp = ptr_plugin_sender->oGetInterfaceData();

  AUD_POINTER_CHECK_CALL_NO_RET_VALUE (tmp.m_ptrBeepParamSender);
  ETG_TRACE_USR4(("vAmp_BeepParam called"));
  tmp.m_ptrBeepParamSender->vAmp_BeepParam(EN_AMP_BEEP_ERROR,tU8_SignalToneID,tU16_Frequency,tS16_Gain);

}

void vd_amp_msg_beepparam::MessageNotification(PO_MessageConfig::enID MsgId)
{
  ETG_TRACE_USR4(("vd_amp_msg_beepparam::MessageNotification entered. "));
  InternalCommunicationAdapter* pPO; // Pointer for post office access
  pPO = InternalCommunicationAdapter::getInstance();
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE (pPO);

  switch(MsgId){


  case (PO_MessageConfig::ID_NotifyBeepName):{

    const ID_NotifyBeepName* pMsg = pPO->POMessages->QueryMessage <ID_NotifyBeepName> (MsgId);
    vdamp_plugin_sender* ptr_plugin_sender = NULL;
     if((m_ptrreceiver!=NULL)&&(m_ptrloader!=NULL))
     {
       ETG_TRACE_USR4(("m_ptrMain!=NULL"));
       ptr_plugin_sender  =   m_ptrloader->poGetPluginSender(m_ptrreceiver->u16GetActivePlugin());
     }
     AUD_POINTER_CHECK_CALL_NO_RET_VALUE (ptr_plugin_sender);
     ETG_TRACE_USR4(("oGetInterfaceData called"));
     vdamp_plugin_sender_interfaces tmp = ptr_plugin_sender->oGetInterfaceData();
     AUD_POINTER_CHECK_CALL_NO_RET_VALUE (tmp.m_ptrBeepParamSender);
     ETG_TRACE_USR4(("vAmp_BeepParam called tp premium 2 "));
     tmp.m_ptrBeepParamSender->vAmp_BeepParam( (amp_tenBeepID)pMsg->m_tBeepName,0,0,0);
    break;
  }
  case (PO_MessageConfig::ID_SignalToneParameters):{
      const MSG_SignalToneParameters*     pMsg_signaltoneparam = pPO->POMessages->QueryMessage<MSG_SignalToneParameters>(MsgId);
      ETG_TRACE_USR4(("vd_amp_msg_beepparam received SignalToneID: 0x%4x.", pMsg_signaltoneparam->values.SignalToneID));
      tU8_SignalToneID = pMsg_signaltoneparam->values.SignalToneID;
      tU16_Frequency =  pMsg_signaltoneparam->values.Frequency;
      tS16_Gain = pMsg_signaltoneparam->values.Gain;
      sendBeepParamMessage();
    break;
  }
case (PO_MessageConfig::IDCCAUPATempMute):{
  const IDCCAUPATempMute* pMsg = InternalCommunicationAdapter::getInstance()->POMessages->QueryMessage<IDCCAUPATempMute>(MsgId);
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pMsg);
   vd_Amp_Msg_SendSettingsMessage( EN_AMP_SETTINGS_UPA_TEMP_MUTE, pMsg->m_UPATempMute);
break;

}

case (PO_MessageConfig::ID_ADASSoundCollection):{

   const ID_ADASSoundCollection* pMsg = InternalCommunicationAdapter::getInstance()->POMessages->QueryMessage<ID_ADASSoundCollection>(MsgId);
   AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pMsg);
    vd_Amp_Msg_SendSettingsMessage(EN_AMP_SETTINGS_UPA_SOUND_COLLECTION,pMsg->m_SoundType);
break;
}


case (PO_MessageConfig::ID_NotifyParkAssistVolume):
  {
        const ID_NotifyParkAssistVolume* pMsg = InternalCommunicationAdapter::getInstance()->POMessages->QueryMessage<ID_NotifyParkAssistVolume>(MsgId);
        AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pMsg);
       vd_Amp_Msg_SendSettingsMessage(EN_AMP_SETTINGS_PARK_ASSIST_VOLUME,pMsg->m_volume);

          break;

}
case (PO_MessageConfig::ID_NotifyLDWUserVolume):
  {
      const ID_NotifyLDWUserVolume* pMsg = InternalCommunicationAdapter::getInstance()->POMessages->QueryMessage<ID_NotifyLDWUserVolume>(MsgId);
      AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pMsg);
      ETG_TRACE_USR2(("ID_NotifyLDWUserVolume received : %d", pMsg->m_volume));
        vd_Amp_Msg_SendSettingsMessage(EN_AMP_SETTINGS_LDW_USER_VOLUME,pMsg->m_volume);

          break;
  }
default : break;
}
}

void vd_amp_msg_beepparam:: vd_Amp_Msg_SendSettingsMessage(amp_tenSettingType enSettingType, int16_t swSteps)
{
  ETG_TRACE_USR2(("vd_amp_msg_beepparam::vd_Amp_Msg_SendSettingsMessage for type %d with value %d", enSettingType,swSteps));

  vdamp_plugin_sender* ptr_plugin_sender = NULL;

  if((m_ptrreceiver!=NULL)&&(m_ptrloader!=NULL))
  {
      ptr_plugin_sender  =   m_ptrloader->poGetPluginSender(m_ptrreceiver->u16GetActivePlugin());
  }
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE (ptr_plugin_sender);
  vdamp_plugin_sender_interfaces tmp = ptr_plugin_sender->oGetInterfaceData();
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE (tmp.m_ptrsettingsSender);
  tmp.m_ptrsettingsSender->vAmp_Settings(EN_AMP_SOURCE_STREAM_ENTERTAIN1,enSettingType ,swSteps);
}
void  vd_amp_msg_beepparam::vd_Amp_Msg_IndBeepParam(vdamp_pluginID_t  PluginID, amp_tenBeepID SignalBeepID, uint8_t SignalToneID,uint16_t Freq,int16_t Gain)const
{
  ETG_TRACE_USR4(("vd_amp_msg_beepparam:Received SignalBeepID: 0x%4x  ", SignalBeepID));
  ETG_TRACE_USR4(("vd_amp_msg_beepparam:Received SignalToneID 0x%4x ", SignalToneID));
  ETG_TRACE_USR4(("vd_amp_msg_beepparam:Received Freq 0x%4x .", Freq));
  ETG_TRACE_USR4(("vd_amp_msg_beepparam:Received Gain 0x%4x .", Gain));
  ETG_TRACE_USR4(("vd_amp_msg_beepparam:Received pluginID 0x%4x .", PluginID));

}

void vd_amp_msg_beepparam::vd_Amp_Msg_ErrBeepParam(vdamp_pluginID_t  PluginID, uint8_t ErrorCode)const
{
  ETG_TRACE_USR4(("vd_amp_msg_beepparam :Received errorcode 0x%4x from plugin : 0x%4x .", ErrorCode,PluginID));
}

void vd_amp_msg_beepparam::vReloadExtAmpData_BeepParam(tU8 ampconfig)
{
  ETG_TRACE_USR4(("vReloadExtAmpData_BeepParam() called"));

  if(ampconfig == EXTAMP_CONNECTED)
  {
    //Reload the latest received Post Office message values
      sendBeepParamMessage();
  }

  else
  ETG_TRACE_USR4(("External amplifier not present.."));
}

