/*
 * vd_amp_msg_Beep.cpp
 *
 *  Created on: Jan 25, 2014
 *      Author: sea6kor
 */

#include "vd_amp_msg_Beep.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#include "fc_audiomanager_trace.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION
#include "trcGenProj/Header/vd_amp_msg_Beep.cpp.trc.h"
#endif



vd_amp_msg_beep::vd_amp_msg_beep(plugin_loader* ptrloader, vd_amp_if_tx_rx *ptrx)
:IF_MessageObserver<PO_MessageConfig::enID>("vd_amp_msg_beep")
{
  m_ptrloader = ptrloader;
  m_ptrreceiver = ptrx;
  ETG_TRACE_USR4(("vd_amp_msg_beep::vd_amp_msg_beep constructor. "));

  vAddObserver();

}

void vd_amp_msg_beep::vAddObserver()
{

  ETG_TRACE_USR4(("vd_amp_msg_beep::vAddObserver"));
  InternalCommunicationAdapter* pPO; // Pointer for post office access
  pPO = InternalCommunicationAdapter::getInstance();
  if(pPO != NULL)
  {
    ETG_TRACE_USR4(("vd_amp_msg_beep::vAddObserver  pPO != NULL"));
    pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_SignalToneParameters);
    pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_ChimeParameters);
  }
}

void vd_amp_msg_beep::sendBeepMessage()
{

  vdamp_plugin_sender* ptr_plugin_sender = NULL;

    if((m_ptrreceiver!=NULL)&&(m_ptrloader!=NULL))
   {
  ETG_TRACE_USR4(("m_ptrMain!=NULL"));
    ptr_plugin_sender  =   m_ptrloader->poGetPluginSender(m_ptrreceiver->u16GetActivePlugin());
   }

   AUD_POINTER_CHECK_CALL_NO_RET_VALUE (ptr_plugin_sender);

   ETG_TRACE_USR4(("oGetInterfaceData called"));
   vdamp_plugin_sender_interfaces tmp = ptr_plugin_sender->oGetInterfaceData();

   AUD_POINTER_CHECK_CALL_NO_RET_VALUE (tmp.m_ptrBeepSender);
   ETG_TRACE_USR4(("vAmp_Beep called"));
   tmp.m_ptrBeepSender->vAmp_Beep(EN_AMP_BEEP_ERROR,
                           tU16_Pulses,
                           tU16_AttackTime,
                           tU16_AttackTimeLog,
                           tU16_AttackTimeLin,
                           tU16_ReleaseTime,
                           tU16_ReleaseTimeLog,
                           tU16_ReleaseTimeLin,
                          (amp_tenSignalToneAction)tU16_SignalToneAction);

}


void vd_amp_msg_beep::MessageNotification(PO_MessageConfig::enID MsgId)
{
  ETG_TRACE_USR4(("vd_amp_msg_beep::MessageNotification entered. "));
  InternalCommunicationAdapter* pPO; // Pointer for post office access
  pPO = InternalCommunicationAdapter::getInstance();
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE (pPO);
  const MSG_ChimeParameters*     pMsg_ChimeParam= pPO->POMessages->QueryMessage<MSG_ChimeParameters>(MsgId);
    ETG_TRACE_USR4(("vd_amp_msg_beep received AttackTime: 0x%4x.", pMsg_ChimeParam->values.AttackTime));
   ETG_TRACE_USR4(("vd_amp_msg_beep received AttackTimeLin: 0x%4x.", pMsg_ChimeParam->values.AttackTimeLin));
   ETG_TRACE_USR4(("vd_amp_msg_beep received AttackTimeLog: 0x%4x.", pMsg_ChimeParam->values.AttackTimeLog));
   ETG_TRACE_USR4(("vd_amp_msg_beep received Pulses: 0x%4x.", pMsg_ChimeParam->values.Pulses));
   ETG_TRACE_USR4(("vd_amp_msg_beep received ReleaseTime: 0x%4x.", pMsg_ChimeParam->values.ReleaseTime));
   ETG_TRACE_USR4(("vd_amp_msg_beep received ReleaseTimeLin: 0x%4x.", pMsg_ChimeParam->values.ReleaseTimeLin));
   ETG_TRACE_USR4(("vd_amp_msg_beep received ReleaseTimeLog: 0x%4x.", pMsg_ChimeParam->values.ReleaseTimeLog));
   ETG_TRACE_USR4(("vd_amp_msg_beep received SignalToneAction: 0x%4x.", pMsg_ChimeParam->values.SignalToneAction));
  tU16_Pulses =   pMsg_ChimeParam->values.Pulses;
  tU16_AttackTime = pMsg_ChimeParam->values.AttackTime;
  tU16_AttackTimeLog = pMsg_ChimeParam->values.AttackTimeLog ;
  tU16_AttackTimeLin = pMsg_ChimeParam->values.AttackTimeLin;
  tU16_ReleaseTime =  pMsg_ChimeParam->values.Pulses;
  tU16_ReleaseTimeLog =  pMsg_ChimeParam->values.ReleaseTimeLog;
  tU16_ReleaseTimeLin =  pMsg_ChimeParam->values.ReleaseTimeLin;
  tU16_SignalToneAction =  pMsg_ChimeParam->values.SignalToneAction;

  sendBeepMessage();

}


void  vd_amp_msg_beep::vd_Amp_Msg_IndBeep(vdamp_pluginID_t  PluginID, amp_tenBeepID SignalBeepID, amp_tenBeepState  BeepState)const
{
  ETG_TRACE_USR4(("vd_amp_msg_beep:Received SignalBeepID: 0x%4x  ", SignalBeepID));
  ETG_TRACE_USR4(("vd_amp_msg_beep:Received BeepState 0x%4x ", BeepState));
  ETG_TRACE_USR4(("vd_amp_msg_beep:Received pluginID 0x%4x .", PluginID));

}

void vd_amp_msg_beep::vd_Amp_Msg_ErrBeep(vdamp_pluginID_t  PluginID, uint8_t ErrorCode)const
{
  ETG_TRACE_USR4(("vd_amp_msg_beep :Received errorcode 0x%4x from plugin : 0x%4x .", ErrorCode,PluginID));
}



