/************************************************************************
 * FILE:         vd_adr3_thread.h
 * PROJECT:      NissanLCN2kai
 * SW-COMPONENT: vd_adr
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  workthread for handling of messages that should be send to adr3
 *
 *----------------------------------------------------------------------
 * COPYRIGHT:    (c) 2009 Robert Bosch GmbH, Hildesheim
 * HISTORY:
 * Date      | Author   | Modification
 * 30.07.08  | Hessling | initial
 * 02.03.09  | Liebanas | adaption for fc_ipod
 *************************************************************************/
#ifndef _VD_ADR3THREAD_H_
#define _VD_ADR3THREAD_H_

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define AHL_S_IMPORT_INTERFACE_THREAD
#include "ahl_if.h"         // standard CCA Server framework
#include "vd_adr3_main.h"

//define event for vd_adr3_thread
const tU32 EVENT_VD_ADR3_CHECK_NEXT_MESSAGE = 0x00000001;


class ahl_tclEventThread;

class vd_adr3_thread : public ahl_tclEventThread
{
public:
  vd_adr3_thread(vd_adr3_main* povd_adr3_main);
  virtual ~vd_adr3_thread();

  // thread loop worker function
  virtual tBool bThreadFunction(OSAL_tEventMask u32EventMask);


protected:
  vd_adr3_thread(); //don't use

private:
  static vd_adr3_main *m_povd_adr3_main;

};

#endif // _VD_ADR3THREAD_H_
