///////////////////////////////////////////////////////////
//  vd_adr3_main.cpp
//  Implementation of the Class vd_adr3_main
//  Created on:      08-Jun-2012 10:34:12
//  Original author: hag2hi
///////////////////////////////////////////////////////////
#include "vd_adr3Msg_source.h"
#include "vd_adr3Msg_volume.h"
#include "vd_adr3Msg_route.h"
#include "vd_adr3Msg_mute.h"
#include "vd_adr3Msg_muteChannel.h"
#include "vd_adr3Msg_sequenceCtrl.h"
#include "vd_adr3Msg_settings.h"
#include "vd_adr3Msg_chimeParameters.h"
#include "vd_adr3Msg_equSetting.h"
#include "vd_adr3Msg_filter.h"
#include "vd_adr3Msg_inputVolumeOffset.h"
#include "vd_adr3Msg_maintenanceMode.h"
#include "vd_adr3Msg_signalTone.h"
#include "vd_adr3Msg_signalToneParameters.h"
#include "vd_adr3Msg_soundMode.h"
#include "vd_adr3Msg_volumeOffset.h"
#include "vd_adr3Msg_startup.h"
#include "vd_adr3Msg_diagResult.h"
#include "vd_adr3_Config_Types.h"
#include "vd_adr3_Config.h"
#include "vd_adr3Msg_carSetting.h"
#include "vd_adr3_thread.h"
#include "vd_adr3Msg_voltageState.h"
#include "vd_adr3Msg_clipping.h"
#include "vd_adr3Msg_notification.h"
#include "vd_adr3Msg_powerState.h"
#include "vd_adr3Msg_diagSpeaker.h"
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS
#include "vd_adr3Msg_arkamysParameter.h"
#endif // VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS

#ifdef VARIANT_S_FTR_ENABLE_G3G
#include "vd_adr3_INC.h"
#endif

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
//#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "../../fc_audiomanager_trace.h"
#include "../../fc_audiomanager_trace_macros.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_ADR3_MAIN
#include "trcGenProj/Header/vd_adr3_main.cpp.trc.h"
#endif


//GLOBAL VARIABLES
vd_adr3Msg_source*              vd_adr3_main::m_povd_adr3Msg_source            = NULL;
vd_adr3Msg_volume*             vd_adr3_main::m_povd_adr3Msg_volume            = NULL;
vd_adr3Msg_route*              vd_adr3_main::m_povd_adr3Msg_route             = NULL;
vd_adr3Msg_mute*               vd_adr3_main::m_povd_adr3Msg_mute              = NULL;
vd_adr3Msg_muteChannel*        vd_adr3_main::m_povd_adr3Msg_muteChannel       = NULL;
vd_adr3Msg_sequenceCtrl*       vd_adr3_main::m_povd_adr3Msg_sequence          = NULL;
vd_adr3Msg_settings*         vd_adr3_main::m_povd_adr3Msg_settings          = NULL;
vd_adr3Msg_chimeParameters*      vd_adr3_main::m_povd_adr3Msg_chimeParameters      = NULL;
vd_adr3Msg_equSetting*        vd_adr3_main::m_povd_adr3Msg_equSetting          = NULL;
vd_adr3Msg_filter*          vd_adr3_main::m_povd_adr3Msg_filter            = NULL;
vd_adr3Msg_inputVolumeOffset*    vd_adr3_main::m_povd_adr3Msg_inputVolumeOffset      = NULL;
vd_adr3Msg_maintenanceMode*      vd_adr3_main::m_povd_adr3Msg_maintenanceMode      = NULL;
vd_adr3Msg_signalTone*        vd_adr3_main::m_povd_adr3Msg_signalTone          = NULL;
vd_adr3Msg_signalToneParameters*  vd_adr3_main::m_povd_adr3Msg_signalToneParameters  = NULL;
vd_adr3Msg_soundMode*        vd_adr3_main::m_povd_adr3Msg_soundMode          = NULL;
vd_adr3Msg_volumeOffset*      vd_adr3_main::m_povd_adr3Msg_volumeOffset        = NULL;
vd_adr3Msg_startup*          vd_adr3_main::m_povd_adr3Msg_startup          = NULL;
vd_adr3Msg_diagResult*        vd_adr3_main::m_povd_adr3Msg_diagResult          = NULL;
vd_adr3_config*                     vd_adr3_main::m_povd_adr3_config                    = NULL;
vd_adr3Msg_carSetting*              vd_adr3_main::m_povd_adr3Msg_carSetting          = NULL;
vd_adr3_thread*            vd_adr3_main::m_povd_adr3_thread                    = NULL;
vd_adr3Msg_voltageState*      vd_adr3_main::m_povd_adr3Msg_voltageState           = NULL;
vd_adr3Msg_clipping*                vd_adr3_main::m_povd_adr3Msg_clipping               = NULL;
vd_adr3Msg_notification*            vd_adr3_main::m_povd_adr3Msg_notification           = NULL;
vd_adr3Msg_powerState*              vd_adr3_main::m_povd_adr3Msg_powerState             = NULL;
vd_adr3Msg_diagSpeaker*        vd_adr3_main::m_povd_adr3Msg_diagSpeaker        = NULL;
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS
vd_adr3Msg_arkamysParameter*          vd_adr3_main::m_povd_adr3Msg_arkamysParameter        = NULL;
#endif // VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS

#ifdef VARIANT_S_FTR_ENABLE_G3G
vd_adr3_INC*              vd_adr3_main::m_povd_adr3_INC_Comm          = NULL;
#endif

vd_adr3_If*           vd_adr3_main::m_povd_adr3_If          = NULL;

/********************************************************************************
 * constructor
 *******************************************************************************/
vd_adr3_main::vd_adr3_main(){
}

/********************************************************************************
 * destructor
 *******************************************************************************/
vd_adr3_main::~vd_adr3_main(){
}

/********************************************************************************
 * vInit
 *******************************************************************************/
void vd_adr3_main::vInit(void){
  tBool bSuccess = TRUE;
  tBool bRet;
  ETG_TRACE_USR4(("vd_adr3_main::vInit() entered."));


  m_povd_adr3_thread = new vd_adr3_thread(this);
  if (m_povd_adr3_thread != NULL)
  {
    // Start Worker Thread (the thread is spawned and will idle until a
    // message is sent to it, which requires any processing).
    ETG_TRACE_USR4(("m_povd_adr3_thread->bStart"));
    bRet = m_povd_adr3_thread->bStart();
    ETG_TRACE_USR4(("m_povd_adr3_thread->bStart bRet = %u",bRet));
  }
  else
  {
    ETG_TRACE_ERR(( "bOnInit: creation of Worker Thread failed" ));
  }

  m_povd_adr3Msg_voltageState = OSAL_NEW vd_adr3Msg_voltageState(this);
  ETG_TRACE_USR4(("m_povd_adr3Msg_voltageState = %p",m_povd_adr3Msg_voltageState));
  if (NULL == m_povd_adr3Msg_voltageState)
  {
    bSuccess = FALSE;
    FATAL_M_ASSERT_ALWAYS();
  }

  m_povd_adr3Msg_route = OSAL_NEW vd_adr3Msg_route(this);
  ETG_TRACE_USR4(("m_povd_adr3Msg_route = %p",m_povd_adr3Msg_route));
  if (NULL == m_povd_adr3Msg_route)
  {
    bSuccess = FALSE;
    FATAL_M_ASSERT_ALWAYS();
  }

  m_povd_adr3Msg_source = OSAL_NEW vd_adr3Msg_source(this);
  ETG_TRACE_USR4(("m_povd_adr3Msg_source = %p",m_povd_adr3Msg_source));
  if (NULL == m_povd_adr3Msg_source)
  {
    bSuccess = FALSE;
    FATAL_M_ASSERT_ALWAYS();
  }

  m_povd_adr3Msg_volume = OSAL_NEW vd_adr3Msg_volume();
  ETG_TRACE_USR4(("m_povd_adr3Msg_volume = %p",m_povd_adr3Msg_volume));
  if (NULL == m_povd_adr3Msg_volume)
  {
    bSuccess = FALSE;
    FATAL_M_ASSERT_ALWAYS();
  }

  m_povd_adr3Msg_mute = OSAL_NEW vd_adr3Msg_mute(this);
  ETG_TRACE_USR4(("m_povd_adr3Msg_mute = %p",m_povd_adr3Msg_mute));
  if (NULL == m_povd_adr3Msg_mute)
  {
    bSuccess = FALSE;
    FATAL_M_ASSERT_ALWAYS();
  }

  m_povd_adr3Msg_muteChannel  = OSAL_NEW vd_adr3Msg_muteChannel(this);
  ETG_TRACE_USR4(("m_povd_adr3Msg_muteChannel  = %p",m_povd_adr3Msg_muteChannel ));
  if (NULL == m_povd_adr3Msg_muteChannel )
  {
    bSuccess = FALSE;
    FATAL_M_ASSERT_ALWAYS();
  }

  m_povd_adr3Msg_sequence = OSAL_NEW vd_adr3Msg_sequenceCtrl(this);
  ETG_TRACE_USR4(("m_povd_adr3Msg_sequence = %p",m_povd_adr3Msg_sequence));
  if (NULL == m_povd_adr3Msg_sequence)
  {
    bSuccess = FALSE;
    FATAL_M_ASSERT_ALWAYS();
  }

  m_povd_adr3Msg_settings = OSAL_NEW vd_adr3Msg_settings(this);
  ETG_TRACE_USR4(("m_povd_adr3Msg_settings = %p",m_povd_adr3Msg_settings));
  if (NULL == m_povd_adr3Msg_settings)
  {
    bSuccess = FALSE;
    FATAL_M_ASSERT_ALWAYS();
  }

  m_povd_adr3Msg_chimeParameters = OSAL_NEW vd_adr3Msg_chimeParameters(this);
  ETG_TRACE_USR4(("m_povd_adr3Msg_chimeParameters = %p",m_povd_adr3Msg_chimeParameters));
  if (NULL == m_povd_adr3Msg_chimeParameters)
  {
    bSuccess = FALSE;
    FATAL_M_ASSERT_ALWAYS();
  }
  m_povd_adr3Msg_equSetting = OSAL_NEW vd_adr3Msg_equSetting(this);
  ETG_TRACE_USR4(("m_povd_adr3Msg_equSetting = %p",m_povd_adr3Msg_equSetting));
  if (NULL == m_povd_adr3Msg_equSetting)
  {
    bSuccess = FALSE;
    FATAL_M_ASSERT_ALWAYS();
  }
  m_povd_adr3Msg_filter = OSAL_NEW vd_adr3Msg_filter(this);
  ETG_TRACE_USR4(("m_povd_adr3Msg_filter = %p",m_povd_adr3Msg_filter));
  if (NULL == m_povd_adr3Msg_filter)
  {
    bSuccess = FALSE;
    FATAL_M_ASSERT_ALWAYS();
  }
  m_povd_adr3Msg_inputVolumeOffset = OSAL_NEW vd_adr3Msg_inputVolumeOffset(this);
  ETG_TRACE_USR4(("m_povd_adr3Msg_inputVolumeOffset = %p",m_povd_adr3Msg_inputVolumeOffset));
  if (NULL == m_povd_adr3Msg_inputVolumeOffset)
  {
    bSuccess = FALSE;
    FATAL_M_ASSERT_ALWAYS();
  }
  m_povd_adr3Msg_maintenanceMode = OSAL_NEW vd_adr3Msg_maintenanceMode(this);
  ETG_TRACE_USR4(("m_povd_adr3Msg_maintenanceMode = %p",m_povd_adr3Msg_maintenanceMode));
  if (NULL == m_povd_adr3Msg_maintenanceMode)
  {
    bSuccess = FALSE;
    FATAL_M_ASSERT_ALWAYS();
  }
  m_povd_adr3Msg_signalTone = OSAL_NEW vd_adr3Msg_signalTone(this);
  ETG_TRACE_USR4(("m_povd_adr3Msg_signalTone = %p",m_povd_adr3Msg_signalTone));
  if (NULL == m_povd_adr3Msg_signalTone)
  {
    bSuccess = FALSE;
    FATAL_M_ASSERT_ALWAYS();
  }
  m_povd_adr3Msg_signalToneParameters = OSAL_NEW vd_adr3Msg_signalToneParameters(this);
  ETG_TRACE_USR4(("m_povd_adr3Msg_signalToneParameters = %p",m_povd_adr3Msg_signalToneParameters));
  if (NULL == m_povd_adr3Msg_signalToneParameters)
  {
    bSuccess = FALSE;
    FATAL_M_ASSERT_ALWAYS();
  }
  m_povd_adr3Msg_soundMode = OSAL_NEW vd_adr3Msg_soundMode(this);
  ETG_TRACE_USR4(("m_povd_adr3Msg_soundMode = %p",m_povd_adr3Msg_soundMode));
  if (NULL == m_povd_adr3Msg_soundMode)
  {
    bSuccess = FALSE;
    FATAL_M_ASSERT_ALWAYS();
  }
  m_povd_adr3Msg_volumeOffset = OSAL_NEW vd_adr3Msg_volumeOffset(this);
  ETG_TRACE_USR4(("m_povd_adr3Msg_volumeOffset = %p",m_povd_adr3Msg_volumeOffset));
  if (NULL == m_povd_adr3Msg_volumeOffset)
  {
    bSuccess = FALSE;
    FATAL_M_ASSERT_ALWAYS();
  }
m_povd_adr3Msg_startup = OSAL_NEW vd_adr3Msg_startup(this);
  ETG_TRACE_USR4(("m_povd_adr3Msg_startup = %p",m_povd_adr3Msg_startup));
  if (NULL == m_povd_adr3Msg_startup)
  {
    bSuccess = FALSE;
    FATAL_M_ASSERT_ALWAYS();
  }

  m_povd_adr3Msg_diagResult = OSAL_NEW vd_adr3Msg_diagResult(this);
  ETG_TRACE_USR4(("m_povd_adr3Msg_diagResult = %p",m_povd_adr3Msg_diagResult));
  if (NULL == m_povd_adr3Msg_diagResult)
  {
    bSuccess = FALSE;
    FATAL_M_ASSERT_ALWAYS();
  }

   m_povd_adr3_config = OSAL_NEW vd_adr3_config();
   ETG_TRACE_USR4(("m_povd_adr3_config = %p",m_povd_adr3_config));
   if (NULL == m_povd_adr3_config)
   {
      bSuccess = FALSE;
      FATAL_M_ASSERT_ALWAYS();
   }

  m_povd_adr3Msg_carSetting = OSAL_NEW vd_adr3Msg_carSetting(this);
  ETG_TRACE_USR4(("m_povd_adr3Msg_carSetting = %p",m_povd_adr3Msg_carSetting));
  if (NULL == m_povd_adr3Msg_carSetting)
  {
    bSuccess = FALSE;
    FATAL_M_ASSERT_ALWAYS();
  }

  m_povd_adr3Msg_clipping = OSAL_NEW vd_adr3Msg_clipping(this);
  ETG_TRACE_USR4(("m_povd_adr3Msg_clipping = %p",m_povd_adr3Msg_clipping));
  if (NULL == m_povd_adr3Msg_clipping)
  {
    bSuccess = FALSE;
    FATAL_M_ASSERT_ALWAYS();
  }

  m_povd_adr3Msg_notification = OSAL_NEW vd_adr3Msg_notification(this);
  ETG_TRACE_USR4(("m_povd_adr3Msg_notification = %p",m_povd_adr3Msg_notification));
  if (NULL == m_povd_adr3Msg_notification)
  {
    bSuccess = FALSE;
    FATAL_M_ASSERT_ALWAYS();
  }

  m_povd_adr3Msg_powerState = OSAL_NEW vd_adr3Msg_powerState(this);
  ETG_TRACE_USR4(("m_povd_adr3Msg_powerState = %p",m_povd_adr3Msg_powerState));
  if (NULL == m_povd_adr3Msg_powerState)
  {
    bSuccess = FALSE;
    FATAL_M_ASSERT_ALWAYS();
  }

   m_povd_adr3Msg_diagSpeaker = OSAL_NEW vd_adr3Msg_diagSpeaker(this);
   ETG_TRACE_USR4(("m_povd_adr3Msg_diagSpeaker = %p",m_povd_adr3Msg_diagSpeaker));
   if (NULL == m_povd_adr3Msg_diagSpeaker)
   {
      bSuccess = FALSE;
      FATAL_M_ASSERT_ALWAYS();
   }

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS
   m_povd_adr3Msg_arkamysParameter = OSAL_NEW vd_adr3Msg_arkamysParameter(this);
   ETG_TRACE_USR4(("m_povd_adr3Msg_arkamysParameter = %p",m_povd_adr3Msg_arkamysParameter));
   if (NULL == m_povd_adr3Msg_arkamysParameter)
   {
      bSuccess = FALSE;
      FATAL_M_ASSERT_ALWAYS();
   }
#endif // VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS

  ETG_TRACE_USR4(("bSuccess = %u",bSuccess));
  vd_adr3Msg_If::vInit();

  m_povd_adr3_If = OSAL_NEW vd_adr3_If(this);
  if (NULL == m_povd_adr3_If)
  {
    FATAL_M_ASSERT_ALWAYS();
  }

  m_povd_adr3_If->vInit();

#ifdef VARIANT_S_FTR_ENABLE_G3G
  m_povd_adr3_INC_Comm = new vd_adr3_INC(this);
  if(NULL == m_povd_adr3_INC_Comm)
  {
    bSuccess = FALSE;
    FATAL_M_ASSERT_ALWAYS();
  }
#endif

}

/********************************************************************************
 * vDeInit
 *******************************************************************************/
void vd_adr3_main::vDeInit(void){
  vd_adr3Msg_If::vDeInit();
  vd_adr3_If::vDeInit();
  vd_adr3_main::m_povd_adr3Msg_source            = NULL;
  vd_adr3_main::m_povd_adr3Msg_volume            = NULL;
  vd_adr3_main::m_povd_adr3Msg_route             = NULL;
  vd_adr3_main::m_povd_adr3Msg_mute              = NULL;
  vd_adr3_main::m_povd_adr3Msg_muteChannel       = NULL;
  vd_adr3_main::m_povd_adr3Msg_sequence          = NULL;
  vd_adr3_main::m_povd_adr3Msg_settings          = NULL;
  vd_adr3_main::m_povd_adr3Msg_chimeParameters      = NULL;
  vd_adr3_main::m_povd_adr3Msg_equSetting          = NULL;
  vd_adr3_main::m_povd_adr3Msg_filter            = NULL;
  vd_adr3_main::m_povd_adr3Msg_inputVolumeOffset      = NULL;
  vd_adr3_main::m_povd_adr3Msg_maintenanceMode      = NULL;
  vd_adr3_main::m_povd_adr3Msg_signalTone          = NULL;
  vd_adr3_main::m_povd_adr3Msg_signalToneParameters  = NULL;
  vd_adr3_main::m_povd_adr3Msg_soundMode          = NULL;
  vd_adr3_main::m_povd_adr3Msg_volumeOffset        = NULL;
  vd_adr3_main::m_povd_adr3Msg_startup          = NULL;
  vd_adr3_main::m_povd_adr3Msg_diagResult          = NULL;
    vd_adr3_main::m_povd_adr3_config                    = NULL;
    vd_adr3_main::m_povd_adr3Msg_carSetting          = NULL;
    vd_adr3_main::m_povd_adr3Msg_voltageState          = NULL;
  vd_adr3_main::m_povd_adr3Msg_clipping               = NULL;
  vd_adr3_main::m_povd_adr3Msg_notification          = NULL;
  vd_adr3_main::m_povd_adr3Msg_powerState          = NULL;
  vd_adr3_main::m_povd_adr3Msg_diagSpeaker        = NULL;

#ifdef VARIANT_S_FTR_ENABLE_G3G
  vd_adr3_main::m_povd_adr3_INC_Comm           = NULL;
#endif

  if (m_povd_adr3_thread != NULL)
  {
    m_povd_adr3_thread->vPostStopRequest();
    m_povd_adr3_thread->bStop();
    m_povd_adr3_thread->vClearEvents();
  }
  OSAL_DELETE m_povd_adr3_thread;
  m_povd_adr3_thread = NULL;

}

/********************************************************************************
 * vSendAdr3WorkerThreadEvent
 *******************************************************************************/
void vd_adr3_main::vSendAdr3WorkerThreadEvent(tU32 u32Event){

  ETG_TRACE_USR4(("vSendAdr3WorkerThreadEvent() entered: event %u", u32Event));
  if(m_povd_adr3_thread != NULL)
  {

    ETG_TRACE_USR4(("m_povd_adr3_thread->vPostEvent(u32Event)"));
    m_povd_adr3_thread->vPostEvent(u32Event);
  }

}

/*void threadtrace()
{
  ETG_TRACE_USR4(("Hello? = %u",4711));
}*/

