
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
// #define ET_TRACE_INFO_ON
#include <etrace_if.h>  // implicitly links generic osal_if.h

#include "vd_adr3_If.h"
#include "vd_adr3_thread.h"
#include "vd_adr3Msg_If.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_generic_if.h"

#define SINK_DEV_WITHOUT_ADR (tU8)42
#define SINK_DEV_PASSTHRU_ADR (tU8)43

#include "../../ai_osal_linux/components/devices/dev_adr3ctrl/include/dev_adr3ctrl.h"

#include "../../fc_audiomanager_trace.h"

#include "../../fc_audiomanager_main.h"
#include "aud_sinkmgr_main.h"
#include "aud_sinkmgr_pwramp.h"
#include "Messages/power/IDPowerState.h"
#include "Messages/Startup/IDNotifyStartup.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_ADR3_IF
#include "trcGenProj/Header/vd_adr3_If.cpp.trc.h"
#endif

/******************************************************************************/
/* DEFINES                                                                    */
/******************************************************************************/

#define VD_ADR3_PING_COUNTER_FOR_ADR_RESET    10

#define VD_ADR3_STRING_ADR3_CONTROL           "/dev/adr3ctrl"
/******************************************************************************/
/* GLOBAL VARIABLES                                                           */
/******************************************************************************/
OSAL_tEventHandle  hEvent;                 /* Event Handle for OSAL */
#ifndef VARIANT_S_FTR_ENABLE_G3G
static void  *pvHandle1 = 0;
#endif
static volatile tBool SSI_TX_BUSY = FALSE;

// workaround to start sound-file initialization sequence
// as long as startup message from ADR is not properly forwarded
static bool bIsFirstPingResponse = true;

vd_adr3_tenComState  m_enCommunicationState;
OSAL_tIODescriptor   m_hAdr3CtrlDevice;
tU32               m_u32CommunicationLostCounter;
tU8                   m_u8PingCounter;
vd_adr3_tenADR3State m_enADR3State;

#ifdef VARIANT_S_FTR_ENABLE_G3G
#include "vd_adr3_INC.h"
//#define NODE_SEND_RECV_ERR    -1
#endif

//workaround to avoid ADR reset after lost first loopback message. Investigations at CF3 ongoing.
tU8 ubStartupMessageState;
#define STARTUP_INIT              0
#define STARTUP_RECEIVED_FROM_ADR 1
#define STARTUP_READY             2
#define STARTUP_LOOPBACK_LOST     3

tBool vd_adr3_If::bSystemstateDownload = FALSE;

/********************************************************************************
 * constructor
 *******************************************************************************/
vd_adr3_If::vd_adr3_If(vd_adr3_main *poAdr3Main):
              m_vd_adr3_main(poAdr3Main)
{
  ETG_TRACE_USR1(("vd_adr3_If constructor"));

  m_enCommunicationState        = enComState_Off;
  m_u32CommunicationLostCounter = 0;
  m_u8PingCounter               = 0;
  m_hAdr3CtrlDevice             = OSAL_ERROR;
  m_enADR3State                 = enADR3State_Unknown;
  ubStartupMessageState         = STARTUP_INIT;
}

/********************************************************************************
 * destructor
 *******************************************************************************/
vd_adr3_If::~vd_adr3_If(tVoid)
{
  ETG_TRACE_USR1(("vd_adr3_If destructor"));

  m_vd_adr3_main = NULL;

/**vdu1kor: Currently commented for migration to G3 Platform.*/
#ifndef VARIANT_S_FTR_ENABLE_G3G
  vCloseChannel();
#endif
}

/********************************************************************************
 * vInit(tVoid)
 *******************************************************************************/
void vd_adr3_If::vInit(tVoid) const{
  m_enADR3State = enADR3State_Unknown;

  ubStartupMessageState = STARTUP_INIT;

  if(!isSBRVariant())
      vOpenAdr3CtrlDevice();
  
  vOpenChannel();

  vStartPingTimer();
  aud_sinkmgr_main::vUpdateProperty();

}


/********************************************************************************
 * vDeInit(tVoid)
 *******************************************************************************/
void vd_adr3_If::vDeInit(tVoid){
  vCloseChannel();
  m_enADR3State    = enADR3State_Unknown;
}


/********************************************************************************
 * vOpenChannel(tVoid)
 *******************************************************************************/
void vd_adr3_If::vOpenChannel(tVoid){
#ifndef VARIANT_S_FTR_ENABLE_G3G
  tS32 s32RetVal;
  tBool bOpenChannel = TRUE;

  // channel configuration
  ssi_tChannelConfig rChannelConfig =
  {
      SSI_INSTANCE_ADR3,   // Instance
      0x16,                // LUN
      vDataCon,            // data confirmation callback
      vDataInd,            // data indication callback
      AUD_MAX_ADR_OUT_LEN, // transmit buffer size
      AUD_MAX_ADR_OUT_LEN, // receive buffer size
      FALSE         // TRUE-> After SSI_s32OpenChannel() the channel is in Xoff state
  };

  // open channel
  s32RetVal = SSI_s32OpenChannel( &pvHandle1, &rChannelConfig);
  if( s32RetVal != SSI_C_NO_ERROR)
  {
    bOpenChannel = FALSE;
    ETG_TRACE_USR1((" vd_adr3_If::vOpen() bOpenChannel =  FALSE  %u", bOpenChannel));
    NORMAL_M_ASSERT_ALWAYS();
  }
  else
  {
    ETG_TRACE_USR1(("vOpenChannel. enComState_WaitForStartup"));
    m_enCommunicationState = enComState_WaitForStartup;
    ubStartupMessageState  = STARTUP_INIT;
  }
  ETG_TRACE_USR1((" vd_adr3_If::vOpen() bOpenChannel = TRUE %u", bOpenChannel));
#endif

}


/********************************************************************************
 * vCloseChannel(tVoid)
 *******************************************************************************/
void vd_adr3_If::vCloseChannel(tVoid){
  if( m_enCommunicationState != enComState_Off)
  {
/**vdu1kor: Currently commented for migration to G3 Platform.*/
#ifndef VARIANT_S_FTR_ENABLE_G3G
    SSI_s32CloseChannel( &pvHandle1);
#endif
    m_enCommunicationState = enComState_Off;
  }
}

/********************************************************************************
 * tBool isSBRVariant(tVoid)
 *******************************************************************************/
tBool vd_adr3_If::isSBRVariant(tVoid) {

    tU8 u8KDSParam = 0; //initializing with internal amplifier
    if ((DP_S32_NO_ERR== DP_s32GetConfigItem("GenericTunerParameter", "MuteOrAttenuationForAbsoluteStationChangeAMFM", &u8KDSParam, 1)))
    {
        ETG_TRACE_USR4(("GenericTunerParameter value  : %d", u8KDSParam));
        if ((u8KDSParam == SINK_DEV_WITHOUT_ADR )|| (u8KDSParam == SINK_DEV_PASSTHRU_ADR ))
            return true;
    }
    return false;
}

/********************************************************************************
 * vOpenAdr3CtrlDevice(tVoid)
 *******************************************************************************/
void vd_adr3_If::vOpenAdr3CtrlDevice(tVoid){
/**vdu1kor: Currently commented for migration to G3 Platform.*/

  m_hAdr3CtrlDevice = OSAL_IOOpen( VD_ADR3_STRING_ADR3_CONTROL, OSAL_EN_READWRITE);

  if ( OSAL_ERROR != m_hAdr3CtrlDevice )
  {
    tU32 u32ErrorCode = OSAL_s32IOControl( m_hAdr3CtrlDevice,
        OSAL_C_S32_IOCTRL_ADR3CTRL_REGISTER_RESET_CALLBACK,
        (intptr_t) vCallBackADRState);

    NORMAL_M_ASSERT( OSAL_OK == u32ErrorCode);
    ETG_TRACE_USR1((" register reset callback   0x%x", m_hAdr3CtrlDevice));
  }
  else
  {
    ETG_TRACE_USR1((" vOpenAdr3CtrlDevice handler not available  0x%x", OSAL_ERROR));
  }

}

/********************************************************************************
 * vCloseChannel(tVoid)
 *******************************************************************************/
/**vdu1kor: Currently commented for migration to G3 Platform.*/
#ifndef VARIANT_S_FTR_ENABLE_G3G
/********************************************************************************
 * vd_adr3_If::vDataCon()                                                       *
 * Description: The result of lld_ssi_s32DataReq () is reported.           *
 * result of the DataReq values:                          *
 *                 LLD_SSI_C_CONF_OKAY    data transferred      *
 *                 LLD_SSI_C_CONF_FAULT  transmission faulty      *
 *******************************************************************************/
void vd_adr3_If::vDataCon( void *pvHandle, enSsiConfState enState)
{
  ETG_TRACE_USR2(("vDataCon() enLldSsiConfState=%u",enState));
  (tVoid)pvHandle;
  SSI_TX_BUSY =  FALSE;

  vd_adr3Msg_If::vDataCon();

  vd_adr3_main::vSendAdr3WorkerThreadEvent((tU32) EVENT_VD_ADR3_CHECK_NEXT_MESSAGE);
}

/********************************************************************************
 * vd_adr3_If::vDataInd()                                                       *
 * Description: Using this function an application (yyy) receives data via      *
 * an application channel.                                  *
 *     *pvHandle  pointer to handle                        *
 *      *pu8Data  pointer to received application data              *
 *     u32Length  message length in byte                      *
 *******************************************************************************/
void vd_adr3_If::vDataInd( void *pvHandle, tU8 *pu8Data, tU32 u32Length)
{
  ETG_TRACE_USR4(("vDataInd() pu8Data[enAdrMsgOffset_FKT_ID] = 0x%04x", AUD_GET_U16(&pu8Data[enAdrMsgOffset_FKT_ID])));
  if((AUD_GET_U16(&pu8Data[enAdrMsgOffset_FKT_ID]) == VD_ADR3_FKT_ID_PING))
  {

    et_vTraceBinary(TR_CLASS_VD_ADR3_IF , TR_LEVEL_USER_4, ET_EN_T8LIST, u32Length, pu8Data, ET_EN_DONE);

  }
  else
  {

    et_vTraceBinary(TR_CLASS_VD_ADR3_IF , TR_LEVEL_USER_2, ET_EN_T8LIST, u32Length, pu8Data, ET_EN_DONE);
  }

  (tVoid)pvHandle;

  if((AUD_GET_U16(&pu8Data[enAdrMsgOffset_FKT_ID]) == VD_ADR3_FKT_ID_STARTUP)&&(pu8Data[enAdrMsgOffset_OP_TYPE]==VD_ADR3_OPTYPE_STATUS))
  {
    ubStartupMessageState = STARTUP_RECEIVED_FROM_ADR;
  }

  tPU8 pu8DataCpy = new tU8[TRACE_MSG_LEN];
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE (pu8DataCpy);
  pu8DataCpy[0] = TRC::enAdr3MsgIf;
  pu8DataCpy[1] = TRC::enADRResponse;
  memcpy(pu8DataCpy+2, pu8Data, u32Length);

  fc_audiomanager_tclApp::vRxFromOtherThreads(TRACE_MSG_LEN, pu8DataCpy);
  OSAL_DELETE []pu8DataCpy;

  SSI_s32DataIndProcessed( pvHandle1);  // inform the driver about the end of data processing.

}
#else
/********************************************************************************
 * vd_adr3_If::vDataCon()                                                       *
 * Description: The result of lld_ssi_s32DataReq () is reported.           *
 * result of the DataReq values:                          *
 *                 LLD_SSI_C_CONF_OKAY    data transferred      *
 *                 LLD_SSI_C_CONF_FAULT  transmission faulty      *
 *******************************************************************************/
void vd_adr3_If::vDataCon()
{
  ETG_TRACE_USR4(("vDataCon() enLldSsiConfState"));
  //(tVoid)pvHandle;
  SSI_TX_BUSY =  FALSE;
  vd_adr3Msg_If::vDataCon();
  vd_adr3_main::vSendAdr3WorkerThreadEvent((tU32) EVENT_VD_ADR3_CHECK_NEXT_MESSAGE);
}

/********************************************************************************
 * vd_adr3_If::vDataInd()                                                       *
 * Description: Using this function an application (yyy) receives data via      *
 * an application channel.                                  *
 *      *pu8Data  pointer to received application data              *
 *     u32Length  message length in byte                      *
 *******************************************************************************/
void vd_adr3_If::vDataInd(tU8 *pu8Data, tU32 u32Length)
{
  ETG_TRACE_USR4(("vd_adr3_If::vDataInd()\n u32Length =0x%x,\n pu8Data=0x%02x", u32Length,
      ETG_LIST_LEN(u32Length), ETG_LIST_PTR_T8(pu8Data)));

  tPU8 pu8DataCpy = new tU8[TRACE_MSG_LEN];
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE (pu8DataCpy);


  if((AUD_GET_U16(&pu8Data[enAdrMsgOffset_FKT_ID]) == VD_ADR3_FKT_ID_PING))
  {

    et_vTraceBinary(TR_CLASS_VD_ADR3_IF , TR_LEVEL_USER_4, ET_EN_T8LIST, u32Length, pu8Data, ET_EN_DONE);

  }
  else
  {

    et_vTraceBinary(TR_CLASS_VD_ADR3_IF , TR_LEVEL_USER_2, ET_EN_T8LIST, u32Length, pu8Data, ET_EN_DONE);
  }

  pu8DataCpy[0] = TRC::enAdr3MsgIf;
  pu8DataCpy[1] = TRC::enADRResponse;
  memcpy(pu8DataCpy+2, pu8Data, u32Length);

  if((AUD_GET_U16(&pu8Data[enAdrMsgOffset_FKT_ID]) == VD_ADR3_FKT_ID_STARTUP)&&(pu8Data[enAdrMsgOffset_OP_TYPE]==VD_ADR3_OPTYPE_STATUS))
  {
    ubStartupMessageState = STARTUP_RECEIVED_FROM_ADR;
  }

  fc_audiomanager_tclApp::vRxFromOtherThreads(TRACE_MSG_LEN, pu8DataCpy);
  OSAL_DELETE []pu8DataCpy;

  //OSAL_tEventHandle hRxSSI = OSAL_C_INVALID_HANDLE;

  //memcpy( SSI_abTestData, pu8Data, u32Length);
  //SSI_s32DataIndProcessed( hRxSSI);  // inform the driver about the end of data processing.

}

void vd_adr3_If::vSetCommunicationState(vd_adr3_tenComState enCommunicationState)
{
  ETG_TRACE_USR4(("vd_adr3_If::vSetCommunicationState() entered"));
  m_enCommunicationState = enCommunicationState;
}

#endif

/********************************************************************************
 * bSend(trMsgAdrOutput  * poMsgAdrOutput)
 *******************************************************************************/
tBool vd_adr3_If::bSend(trMsgAdrOutput  * poMsgAdrOutput)
{
  tBool bRet;

  bRet = FALSE;


  ETG_TRACE_USR4((" vd_adr3_If::bSend() entered"));

  //ETG_TRACE_USR4(("bSend() poMsgAdrOutput->au8AdrMsg[enAdrMsgOffset_FKT_ID] = 0x%04x", AUD_GET_U16(&(poMsgAdrOutput->au8AdrMsg[enAdrMsgOffset_FKT_ID]))));
  if((AUD_GET_U16(&poMsgAdrOutput->au8AdrMsg[enAdrMsgOffset_FKT_ID]) == VD_ADR3_FKT_ID_PING)||
      (AUD_GET_U16(&poMsgAdrOutput->au8AdrMsg[enAdrMsgOffset_FKT_ID]) == VD_ADR3_FKT_ID_CLIPPING)||
      (AUD_GET_U16(&poMsgAdrOutput->au8AdrMsg[enAdrMsgOffset_FKT_ID]) == VD_ADR3_FKT_ID_CAR_SETTING))
  {

    et_vTraceBinary(TR_CLASS_VD_ADR3_IF , TR_LEVEL_USER_4, ET_EN_T8LIST, poMsgAdrOutput->u32MsgLen, poMsgAdrOutput->au8AdrMsg, ET_EN_DONE);

  }
  else
  {

    et_vTraceBinary(TR_CLASS_VD_ADR3_IF , TR_LEVEL_USER_2, ET_EN_T8LIST, poMsgAdrOutput->u32MsgLen, poMsgAdrOutput->au8AdrMsg, ET_EN_DONE);

  }



#if ( !defined( LSIM) )  // presently no communication in LSIM available

#endif
  if(SSI_TX_BUSY == FALSE)
  {
    //transmission allowed. Block SSI and send message
    SSI_TX_BUSY = TRUE;

/**vdu1kor: Currently commented for migration to G3 Platform.*/
#ifndef VARIANT_S_FTR_ENABLE_G3G
    tS32 s32SSIRetVal = SSI_C_GENERAL_ERROR;
    s32SSIRetVal = SSI_s32DataReq( pvHandle1, poMsgAdrOutput->au8AdrMsg, poMsgAdrOutput->u32MsgLen);
    bRet = TRUE;
    if (s32SSIRetVal != SSI_C_NO_ERROR)
    {
      SSI_TX_BUSY = FALSE;
      bRet = FALSE;
    }
#else
    int iNumberOfBytes =0;
    iNumberOfBytes = vd_adr3_INC::vSendINC(poMsgAdrOutput->au8AdrMsg,poMsgAdrOutput->u32MsgLen);
    bRet = TRUE;
    //ETG_TRACE_USR2(("vd_adr3_If::bSend(), MsgLength = %d ,iNumberOfBytes Sent = %d,",poMsgAdrOutput->u32MsgLen, iNumberOfBytes));
    ETG_TRACE_USR4(("After vSendINC() \n poMsgAdrOutput->u32MsgLen =0x%x,\n poMsgAdrOutput->au8AdrMsg=0x%02x", poMsgAdrOutput->u32MsgLen,
        ETG_LIST_LEN(poMsgAdrOutput->u32MsgLen), ETG_LIST_PTR_T8(poMsgAdrOutput->au8AdrMsg)));

    if(iNumberOfBytes >= 0 && (tU32)iNumberOfBytes == poMsgAdrOutput->u32MsgLen )
    {
      vDataCon();
    }
    else
    {
      SSI_TX_BUSY = FALSE;
      bRet = FALSE;
      ETG_TRACE_FATAL(("vd_adr3_If::bSend() -> number of bytes posted and written in INC buffer are different .\n"));

    }
#endif
  }

  return bRet;
}


/********************************************************************************
 * vCallBackADRState(tVoid)
 *******************************************************************************/
tVoid vd_adr3_If::vCallBackADRState( tU32 u32State)
{
  ETG_TRACE_USR1(("vCallBackADRState() u32State=%u",u32State));
  m_enADR3State = (vd_adr3_tenADR3State)u32State;
  m_u32CommunicationLostCounter = 0;

  if( (m_enCommunicationState == enComState_Run) && (m_enADR3State != enADR3State_INIT) && (m_enADR3State != enADR3State_ALIVE))
  {
    ETG_TRACE_USR1(("vCallBackADRState() reset detected"));

    m_enCommunicationState        = enComState_WaitForStartup;
    ubStartupMessageState         = STARTUP_INIT;
  }

  fc_audiomanager_tclApp::vEventFromOtherThreads(FC_AUDIOMANAGER_EVENT_ID_CHECK_PWR_AMP);

  /*Send Service (Un)availability when ADR state is Dead. Will handle use case when some other module would reset ADR*/
  aud_sinkmgr_main::vUpdateProperty();
}


/********************************************************************************
 * vPingTimerCallback( tVoid* pArg)
 *******************************************************************************/
tVoid vd_adr3_If::vPingTimerCallback(tVoid)
{
  if( ( m_u32CommunicationLostCounter > 0) || ( m_enCommunicationState != enComState_Run) )
  {
     ETG_TRACE_ERR(("vPingTimerCallback() : m_u32CommunicationLostCounter = %u, m_enCommunicationState = %u"
           , m_u32CommunicationLostCounter, ETG_ENUM( AUD_DRVADRIF_COM_STATE, m_enCommunicationState)))
  }

  if( m_enCommunicationState == enComState_DiagnoseSession )      /* do nothing during diagnose session */
  {
    return;
  }

  if( bSystemstateDownload == TRUE )
  {
    return;
  }

  aud_sinkmgr_pwramp* pPwrAmp = aud_sinkmgr_main::poGetPowerAmp();
  if(pPwrAmp && pPwrAmp->ubGetLowPowerActiveFlag())
  {
     m_u32CommunicationLostCounter = 0;
     return;
  }

  if(( m_enCommunicationState == enComState_WaitForStartup)&&(ubStartupMessageState == STARTUP_LOOPBACK_LOST))
  {
    vResendStartupMessage();
  }

  if( m_enCommunicationState != enComState_Off)
  {
    if( m_u32CommunicationLostCounter < VD_ADR3_PING_COUNTER_FOR_ADR_RESET)
    {
      m_u32CommunicationLostCounter++;

      vStartPingTimer();

      if( m_enCommunicationState == enComState_Run)
      {
        m_u8PingCounter++;
        ETG_TRACE_USR2(("vPingTimerCallback() - requesting next Ping %u, bIsFirstPingResponse = %u"
              , m_u8PingCounter, bIsFirstPingResponse))

        vd_adr3Msg_If::vSendMsg(VD_ADR3_INST_ID_LS_1, VD_ADR3_FKT_ID_PING, VD_ADR3_OPTYPE_GET, 1, &m_u8PingCounter, PING);

        // workaround to start sound-file initialization sequence
        // as long as startup message from ADR is not properly forwarded
        if (bIsFirstPingResponse)
          vResendStartupMessage();    // implicitly resets bIsFirstPingResponse
      }
    }
    else
    {
      /*======================================================================
       * Reset the ADR
       *--------------------------------------------------------------------*/
      ETG_TRACE_ERR(( " vPingTimerCallback() ->  m_u32CommunicationLostCounter == VD_ADR3_PING_COUNTER_FOR_ADR_RESET, m_u32CommunicationLostCounter=%d, m_enCommunicationState=%d"
                    ,m_u32CommunicationLostCounter
                    ,ETG_ENUM( AUD_DRVADRIF_COM_STATE, m_enCommunicationState)
                ));

      vd_adr3_If::vResetAdr3();

      // send update of property midw_fi_tcl_e8_AudioDevice_Availability
      aud_sinkmgr_main::vUpdateProperty();

      /*--------------------------------------------------------------------
       * restart Ping timer but send no Ping
       *------------------------------------------------------------------*/
      vStartPingTimer();
      /*==================================================================*/
    }
  }
}


/********************************************************************************
 * vStartPingTimer
 *******************************************************************************/
void vd_adr3_If::vStartPingTimer(void)
{
  fc_audiomanager_tclApp::vEventFromOtherThreads(FC_AUDIOMANAGER_EVENT_ID_PING);

  ETG_TRACE_USR4((" vStartPingTimer  "));

}

/********************************************************************************
 * vClearCommunicationLostCounter
 *******************************************************************************/
void vd_adr3_If::vClearCommunicationLostCounter(void)
{
  m_u32CommunicationLostCounter = 0;
  //todo: pau4kor- enable this code only for sbr variant
  /* this workaround is done to resolve no-audio issue when enabling journal log
   * in Gen4 SBR. We are re-sending the start-up messages once the ping message
   * is received after timer expiry. In Gen3 this is taken care by ADR
   * start-up messages
   */
  if((m_enCommunicationState == enComState_WaitForStartup)
          && (ubStartupMessageState == STARTUP_INIT))
     vResendStartupMessage();
}

/********************************************************************************
 * vResetADR
 *******************************************************************************/
void vd_adr3_If::vResetAdr3(tVoid)
{
  ETG_TRACE_ERRMEM(("vd_adr_If::vResetAdr() ComState=%d,ADRState=%d,ubStartup=%d,CommLostCounter=%d",
      ETG_CENUM(vd_adr3_tenComState,m_enCommunicationState),
      ETG_CENUM(vd_adr3_tenADR3State,m_enADR3State),
      ubStartupMessageState,
      m_u32CommunicationLostCounter));

  ETG_TRACE_USR1(("vd_adr3_If::vResetADR entered"));
  m_u32CommunicationLostCounter = 0;
  m_enCommunicationState        = enComState_WaitForStartup;
  ubStartupMessageState         = STARTUP_INIT;
  m_enADR3State                 = enADR3State_Unknown;

  //Do no reset the ADR3 ctrl in case of without ADR device
  if((!isSBRVariant()) && (OSAL_ERROR != m_hAdr3CtrlDevice) )
  {


    tU32 u32ErrorCode = OSAL_s32IOControl( m_hAdr3CtrlDevice,
        OSAL_C_S32_IOCTRL_ADR3CTRL_RESET_ADR3,
        (tS32) NULL );

    NORMAL_M_ASSERT( OSAL_OK == u32ErrorCode);

    ETG_TRACE_FATAL(( "vd_adr_If::vResetAdr3() -> ADR communication has lost.\n"));

  }
}

/********************************************************************************
 * bGetSsiBusyState(tVoid)
 *******************************************************************************/
tBool vd_adr3_If::bGetSsiBusyState(tVoid)
{
  return SSI_TX_BUSY;
}

/********************************************************************************
 * bGetAdr3StateRunning(tVoid)
 *******************************************************************************/
tBool vd_adr3_If::bGetAdr3StateRunning(tVoid)
{
  tBool bRet;

  ETG_TRACE_USR4(("bGetAdr3StateRunning entered. m_enCommunicationState = %u"
        , ETG_CENUM(vd_adr3_tenComState, m_enCommunicationState)))

  bRet = FALSE;
  if ( m_enCommunicationState == enComState_Run)
  {
    bRet = TRUE;
  }
  //DataInd of startup message received. Loopback message to CCA thread on the way
  else if(ubStartupMessageState == STARTUP_RECEIVED_FROM_ADR)
  {
    ETG_TRACE_USR4(("bGetAdr3StateRunning. ubStartupMessageState == STARTUP_RECEIVED_FROM_ADR "));
    bRet = TRUE;
  }

  return bRet;
}

/********************************************************************************
 * vRxStartup
 *******************************************************************************/
void vd_adr3_If::vRxStartup()
{
  if( m_enCommunicationState == enComState_WaitForStartup)
  {
    ETG_TRACE_USR1(("vRxStartup. enComState_WaitForStartup"));
    vd_adr3_main::vSendAdr3WorkerThreadEvent((tU32) EVENT_VD_ADR3_CHECK_NEXT_MESSAGE);
  }
  else
  {
    ETG_TRACE_ERR(( " ADR reset." ));
  }
  ETG_TRACE_USR1(("vRxStartup. enComState_Run"));
  m_enCommunicationState = enComState_Run;
  ubStartupMessageState = STARTUP_READY;

  vStartPingTimer();
  aud_sinkmgr_main::vUpdateProperty();

  // suppress subsequent invocations via Ping indication
  bIsFirstPingResponse = false;
}


/********************************************************************************
 * vSetLoopbackStartupMessageLost
 *******************************************************************************/
void vd_adr3_If::vSetLoopbackStartupMessageLost(void)
{

  ETG_TRACE_FATAL(("vSetLoopbackStartupMessageLost. \n"
      " Old ubStartupMessageState = %u  \n "
      "new ubStartupMessageState = STARTUP_LOOPBACK_LOST", ubStartupMessageState));
  ubStartupMessageState = STARTUP_LOOPBACK_LOST;
}

/********************************************************************************
 * vResendStartupMessage
 *******************************************************************************/
void vd_adr3_If::vResendStartupMessage()
{
  ETG_TRACE_ERR(( "vResendStartupMessage() " ))

  //call get current status of internal amplifier
  ID_PowerState setPowerState((EN_AUDIO_ADR_POWER_STATE_OFF),(VD_ADR3_OPTYPE_GET));
  InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&setPowerState);

  //Delivering the ID_NotifyStartup  Message
  ID_NotifyStartup notifyStartup(EN_AUDIO_ADR3_AVAILABLE);
  InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&notifyStartup);

  //set communication state and check for waiting messages
  vd_adr3_If::vRxStartup();
  vd_adr3Msg_If::vReloadADRData();  //add this line

  aud_sinkmgr_pwramp* pPwrAmp = aud_sinkmgr_main::poGetPowerAmp();
  if (pPwrAmp)
     pPwrAmp->vCheckPwrAmp();
  else
  {
     ID_PowerState setPowerStateOn(EN_AUDIO_ADR_POWER_STATE_ON, VD_ADR3_OPTYPE_SETGET);
     InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&setPowerStateOn);
  }
}


/********************************************************************************
 * vSetSystemStateDownload
 *******************************************************************************/
void vd_adr3_If::vSetSystemStateDownload(void)
{
  ETG_TRACE_USR2(( "vSetSystemStateDownload"));
  vd_adr3_If::bSystemstateDownload = TRUE;
}

/********************************************************************************
 * vClearSystemStateDownload
 *******************************************************************************/
void vd_adr3_If::vClearSystemStateDownload(void)
{
  ETG_TRACE_USR2(( "vClearSystemStateDownload"));
  vd_adr3_If::bSystemstateDownload = FALSE;
}
