#ifndef VD_ADR_INC_H
#define VD_ADR_INC_H

#include "system_types.h"
#include "vd_adr3_main.h"
#include "dgram_service.h"

#define AUD_WAITINGTHREAD_DEFAULT_PRIO                133
#define AUD_WAITINGTHREAD_DEFAULT_STACKSIZE           4096

#define SINK_DEVICE_NAME_SIZE  256
#define SINK_DEVICE_PORT_SIZE  10

/* sink device info structure */
struct AUDSinkCfg
{
    tC8 c8HostLocal[SINK_DEVICE_NAME_SIZE];
    tC8 c8HostRemote[SINK_DEVICE_NAME_SIZE];
    tC8 c8LocalPort[SINK_DEVICE_PORT_SIZE];
    tC8 c8RemotePort[SINK_DEVICE_PORT_SIZE];
    tU16 u16AudioPort;
    tU8 u8Domain;
    tU8 u8Stream;
};

class vd_adr3_main;

class vd_adr3_INC
{
private:

  tVoid   vRxThreadSetup();
  static tVoid vWaitForADRMessage(tVoid* pvArg);
  tVoid   vGetThreadPrioandStacksize(tU32 &u32ThreadPrio, tU32 &u32StackSize) const;
#if 0 /*  bOpenADRSocket is deprecated and call instead bOpenSinkDevice */
  bool    bOpenADRSocket(uint8_t u8Domain, uint16_t u16Type, int iChannel) const;
#endif
  tBool   bOpenINCCommunication();
  tBool   bParseSinkConfiguration (void);
  tBool   bOpenSinkDevice (void) const;

  OSAL_tThreadID   _hRxThreadId;

protected:
  vd_adr3_main *m_vd_adr3_main;

public:

  vd_adr3_INC(vd_adr3_main *poAdr3Main);
  vd_adr3_INC();
  ~vd_adr3_INC();

  static int vSendINC(void*,size_t);

  tBool            _bTerminate;
  static int       m_nADRSocketFd;
  static sk_dgram* m_pSkDgram;
  AUDSinkCfg       m_stSinkCfg;

};


#endif //VD_ADR_INC_H
