
#ifndef ADR3CONFIGTYPES_HEADER
#define ADR3CONFIGTYPES_HEADER

// =============================================================================

class   adr3_tclFile;
class   adr3_tclMappingSection;
class   adr3_tclDataSet;
class   adr3_tclDataSection;

// =============================================================================
//
//             Project-specific  Settings

enum adr3_tenDataFunctionID
{
   // Note: All these values must have corresponding data-pool name entries
   // in adr3_tclStreamerBase :: sGetDpElementName,
   //    defined in vd_adr3_Config_Streamers.cpp
   // and in below conversion function

   UNDEFINED            =  0,
   BASS_DATA_ID         =  1,
   MID_DATA_ID          =  2,
   TREB_DATA_ID         =  3,
   LOUD_LOW_DATA_ID     =  4,
   BAL_DATA_ID          =  5,
   FAD_DATA_ID          =  6,
   CAR_EQU_DATA_ID      =  7,
   SRCOFF_DATA_ID       =  8,
   LOUD_HIGH_DATA_ID    =  9,
   DELAY_DATA_ID        = 10,
   SDVC_DATA_ID         = 11,
   SDDC_DATA_ID         = 12,
   INPUT_DATA_ID        = 13,
   OUTPUT_DATA_ID       = 14,
   PREMIX_DATA_ID       = 15,
   SDVC_FILTER_DATA_ID  = 16,
   OUTPUTPHASE_DATA_ID  = 17,
   SD_BASS_DATA_ID      = 18,
   SD_TREBLE_DATA_ID    = 19
};

// function prototype for all modifier functions
typedef tVoid (*pfnADRFileModifier)(adr3_tclFile& roFile);

// factory to obtain modifier function
extern pfnADRFileModifier pfnGetModifierFunction(adr3_tenDataFunctionID enDataFID);

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS_CLASSIC
extern tVoid vModify_SDVCFilter(adr3_tclFile& roFile, tU32 u32length, tU8 *u8Data, tBool& bDataChanged);
#endif

// copy customer sound configuration data to local memory (e. g. from datapool)
extern void vSetupCustomerSoundConfiguration(tVoid);
extern void vReleaseCustomerSoundConfiguration(tVoid);

// =============================================================================

inline adr3_tenDataFunctionID adr3_enDataFunctionID(tU8 u8FileID)
{
   // conversion function from numerical value to enumeration
   switch (u8FileID)
   {
      case 1:
         return BASS_DATA_ID;
      case 2:
         return MID_DATA_ID;
      case 3:
         return TREB_DATA_ID;
      case 4:
         return LOUD_LOW_DATA_ID;
      case 5:
         return BAL_DATA_ID;
      case 6:
         return FAD_DATA_ID;
      case 7:
         return CAR_EQU_DATA_ID;
      case 8:
         return SRCOFF_DATA_ID;
      case 9:
         return LOUD_HIGH_DATA_ID;  // not supported
      case 10:
         return DELAY_DATA_ID;
      case 11:
         return SDVC_DATA_ID;
      case 12:
         return SDDC_DATA_ID;
      case 13:
         return INPUT_DATA_ID;
      case 14:
         return OUTPUT_DATA_ID;
      case 15:
         return PREMIX_DATA_ID;
      case 16:
         return SDVC_FILTER_DATA_ID;
      case 17:
         return OUTPUTPHASE_DATA_ID;
      case 18:
         return SD_BASS_DATA_ID;
      case 19:
         return SD_TREBLE_DATA_ID;
      default:
         return UNDEFINED;
   }
}

// =============================================================================

typedef tU32 tCRCCheckSum;

// =============================================================================

struct  tFileVersion
{
   // helper class to handle version information in ADR3 configuration files
   //
   // read / write format is 4 bytes in total, located at the beginning of the file:
   //      month | year | major version | day

   tU8 year;
   tU8 month;
   tU8 day;
   tU8 majorVersion;

   inline /* default constructor */ tFileVersion();
   inline /* constructor */ tFileVersion(tU8 month, tU8 year, tU8 majorVersion, tU8 day);

   inline /* conversion */ operator tU32() const;
   inline bool /* comparison */ operator==(const tFileVersion& roRef) const;
};

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

inline /* default constructor */ tFileVersion :: tFileVersion()
   : year(0), month(0), day(0), majorVersion(0)
{
}

inline /* constructor */ tFileVersion :: tFileVersion(tU8 _month, tU8 _year, tU8 _majorVersion, tU8 _day)
   :  year(_year), month(_month),day(_day), majorVersion(_majorVersion)
{
}

inline /* conversion */ tFileVersion :: operator tU32() const
{
   return (day << 24u) + (majorVersion << 16u) + (year << 8u) + month;
}

inline bool /* comparison */ tFileVersion :: operator==(const tFileVersion& roRef) const
{
   return (    (month == roRef.month) && (year == roRef.year)
             && (day == roRef.day) && (majorVersion == roRef.majorVersion));
}

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

// well-known ADR3-Software versions
#define ADR3_SoftwareVersion_2012_11_08   tFileVersion(0x0b, 0x0c, 0x01, 0x08)
#define ADR3_SoftwareVersion_2014_01_06   tFileVersion(0x01, 0x0e, 0x01, 0x06)
#define ADR3_SoftwareVersion_2015_01_23   tFileVersion(0x01, 0x0f, 0x01, 0x17)

// =============================================================================

struct adr3_tDataDimensions
{
public:
   tS16 s16Min;
   tS16 s16Max;
   tU16 u16Columns;

   tU16 u16Rows() const;

   /* constructor */ adr3_tDataDimensions();
   /* constructor */ adr3_tDataDimensions(tS16 s16Min, tS16 s16Max, tU16 u16Columns);

   inline bool /* inverse comparison */ operator!=(const adr3_tDataDimensions& roRef) const;
};

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

inline /* constructor */ adr3_tDataDimensions :: adr3_tDataDimensions()
   : s16Min(0), s16Max(0), u16Columns(0)
{
}

inline /* constructor */ adr3_tDataDimensions :: adr3_tDataDimensions(tS16 _s16Min, tS16 _s16Max, tU16 _u16Columns)
   : s16Min(_s16Min), s16Max(_s16Max), u16Columns(_u16Columns)
{
}

inline tU16 adr3_tDataDimensions :: u16Rows() const
{
   if ((u16Columns > 0) && (s16Max >= s16Min))
      return (tU16)(1 + s16Max - s16Min);
   else
      return 0;
}

inline bool /* inverse comparison */ adr3_tDataDimensions :: operator!=(const adr3_tDataDimensions& roRef) const
   {  return (s16Min != roRef.s16Min) || (s16Max != roRef.s16Max) || (u16Columns != roRef.u16Columns);  }


// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

#define ADR3_DefaultDelayDimensions          adr3_tDataDimensions(0, 0, 6)
#define ADR3_DefaultSourceOffsetDimensions   adr3_tDataDimensions(0, 0, 11)

// =============================================================================

struct adr3_tMappingNode
{
   tU16 line;
   tU16 column;
   tU16 item;

   /* default constructor */ adr3_tMappingNode();
   /* constructor */ adr3_tMappingNode(const tU16 _line, const tU16 _column, const tU16 _item);
};

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

inline /* default constructor */ adr3_tMappingNode :: adr3_tMappingNode()
   : line(1), column(1), item(0)
{
}

inline /* constructor */ adr3_tMappingNode :: adr3_tMappingNode(const tU16 _line, const tU16 _column, const tU16 _item)
   : line(_line), column(_column), item(_item)
{
}

// =============================================================================


#endif  // ADR3CONFIGTYPES_HEADER

