#ifndef ADR3CONFIGMAP_HEADER
#define ADR3CONFIGMAP_HEADER


// =============================================================================

class adr3_tclMappingSection
{
   friend class adr3_tclFile;

public:

   /* default constructor */ adr3_tclMappingSection ();  // intentionally not implemented
   /* constructor */ adr3_tclMappingSection (const adr3_tenDataFunctionID enDataFID);
   /* destructor */ ~adr3_tclMappingSection ();

   // deep-copy support - intentionally not implemented
   /* copy constructor */ adr3_tclMappingSection (const adr3_tclMappingSection& roRef);
   adr3_tclMappingSection& /* assignment */ operator= (const adr3_tclMappingSection& roRef);

   // populate from ADR3-formatted binary buffer
   tVoid vParse (adr3_tclParser& oIn);

   // writing function to fill this structure into ADR3-formatted binary buffer
   tVoid vSerialize(adr3_tclSerializer& oOut) const;
   tU32 u32SerializedSize() const;

   tVoid vPrintLog(FILE* LogFile) const;

   // member variables
   const tU16  u16ConfigFID;
private:
   std::vector<tU16>               mappingLines;
   std::vector<adr3_tMappingNode>  nodes;
   std::vector<tString>            oNames;
};

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

inline /* constructor */ adr3_tclMappingSection :: adr3_tclMappingSection (const adr3_tenDataFunctionID enDataFID)
   : u16ConfigFID((tU16)(100 + enDataFID))
   , mappingLines()
   , nodes()
   , oNames()
{
}

// =============================================================================

typedef std::vector<adr3_tMappingNode>::iterator tNodeIterator;
typedef std::vector<tU16>::iterator tMappingLineIterator;
typedef std::vector<tString>::iterator tNameIterator;

// =============================================================================

#endif  // ADR3CONFIGMAP_HEADER

