
#ifndef ADR3CONFIGFILE_HEADER
#define ADR3CONFIGFILE_HEADER

class adr3_tclParser;
class adr3_tclSerializer;

// =============================================================================

class adr3_tclFile
{
   // structured (hierarchical) representation of ADR3 sound configuration file
   //
   //  - parses either from data pool or from Parser object
   //  - allows for single value patching as well as complete replacement of existing content
   //  - can serialize back to data pool and to Serializer object
   //  - can update settings in ADR3

public:
   tCString           sName;
   tFileVersion       oVersion;
   adr3_tclMappingSection* poMap;
   adr3_tclDataSection*    poData;

   /* constructor */ adr3_tclFile (const adr3_tenDataFunctionID enDataFID, adr3_tclParser& oParser);
   /* destructor */ ~adr3_tclFile();

   // other constructors & deep-copy support - usage prohibited; implementation intentionally missing
   /* default constructor */ adr3_tclFile ();
   /* copy constructor */ adr3_tclFile (const adr3_tclFile& roref);
   const adr3_tclFile& /* assignment */ operator=(const adr3_tclFile& roref);

   adr3_tDataDimensions oGetDataSetDimensions() const;

   // streaming support
   tVoid vParse (adr3_tclParser& oIn);
   tVoid vSerialize (adr3_tclSerializer& oOut) const;
   tU32 u32SerializedSize() const;

   // persistence support
   /* constructor */ adr3_tclFile (const adr3_tenDataFunctionID enDataFID);  // parse from datapool
   tVoid vUpdateDataPoolElement() const;

   // visualize
   tVoid vPrintLog(FILE* Log) const;

   // make changes effective, but do not save
   tBool bSendToADR3() const;

   // manipulating functions
   tU32      u32FindDataSetIndexFromName(tCString sName) const;
   adr3_tclDataSet& roAddDataSet();
   adr3_tclDataSet& roAddMappedDataSet(tCString sName);
   tVoid       vRemoveDataSet(tU32 u32Index);  // Note: standard index range from 0 to (size - 1)
   tVoid       vRemoveAllDataSets();
   tVoid       vRemoveAllDataSets(const adr3_tDataDimensions& roNewDimensions);
   tVoid       vAddMappedNode(tU16 u16DataSetIndex, tU16 line, tU16 column, tU16 item);
private:
   tVoid vRemoveReferencingNodes(tU32 u32LineID);

};

// =============================================================================

#endif // ADR3CONFIGFILE_HEADER
