
#ifndef ADR3CONFIGDATA_HEADER
#define ADR3CONFIGDATA_HEADER

// =============================================================================

class adr3_tclDataRow
{
   // helper class to support multi-dimensional operator[] on DataSet objects

   const tU32 u32RowLength;
   tS16* const ps16Data;

public:
   /* default constructor */ adr3_tclDataRow();  // intentionally not implemented
   /* constructor */ adr3_tclDataRow (const adr3_tclDataSet& roParent, tU32 u32RowOffset);

   tS16& operator[] (tU16 u16ColumnIndex);
};



// =============================================================================

class  adr3_tclDataSet
{
   // helper class to handle a set of configuration values in ADR3 configuration files

   friend class adr3_tclDataRow;

   // member functions
public:
   /* default constructor */ adr3_tclDataSet ();
   /* constructor */ adr3_tclDataSet (const adr3_tDataDimensions& roDimensions);
   /* copy constructor */ adr3_tclDataSet (const adr3_tclDataSet& coRef);
   virtual /* destructor */ ~adr3_tclDataSet ();

   adr3_tclDataSet& /* assignment */ operator= (const adr3_tclDataSet& roRef);

   // streaming support
   tVoid vParse (adr3_tclParser& oIn);
   tVoid vSerialize (adr3_tclSerializer& oOut) const;

   tVoid vAllocate (const adr3_tDataDimensions& roDimensions);

   inline const adr3_tDataDimensions& roGetDimensions() const;

   tVoid vPrintLog (FILE* pLog) const;

   adr3_tclDataRow operator[] (tU32 u32RowIndex) const;

   // member variables
private:
   adr3_tDataDimensions oDimensions;
   tS16*     poData;       // 2-dimensional matrix of data elements
};

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

inline const adr3_tDataDimensions& adr3_tclDataSet :: roGetDimensions() const
   {  return oDimensions;  }

// =============================================================================

class adr3_tclDataSection
{
   // array of sets of configuration values, representing lower section
   // in ADR3 configuration files
   //

   friend class adr3_tclFile;

public:
   /* default constructor */ adr3_tclDataSection();  // intentionally not implemented
   /* constructor */ adr3_tclDataSection (const adr3_tenDataFunctionID enDataFID);

   const adr3_tDataDimensions& oGetDimensions () const;

   size_t size() const;
   adr3_tclDataSet& operator[] (size_t index);
   const adr3_tclDataSet& operator[] (size_t index) const;

   // streaming support
   tVoid vParse(adr3_tclParser& oIn);

   tVoid vSerialize(adr3_tclSerializer& oOut) const;
   tU32 u32SerializedSize() const;

   tVoid vPrintLog(FILE* pLog) const;

   // member variables
//public:
   const adr3_tenDataFunctionID enDataFunctionID;
private:
   std::vector<adr3_tclDataSet> oDataSets;
   adr3_tDataDimensions oDimensions;
};

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

inline /* constructor */ adr3_tclDataSection :: adr3_tclDataSection (const adr3_tenDataFunctionID _enDataFID)
   : enDataFunctionID(_enDataFID)
   , oDataSets()
   , oDimensions()
{ }

inline const adr3_tDataDimensions& adr3_tclDataSection :: oGetDimensions () const
   {  return oDimensions;  }

// =============================================================================

#endif  // ADR3CONFIGDATA_HEADER
