///////////////////////////////////////////////////////////
//  vd_adr3Msg_volumeOffset.cpp
//  Implementation of the Class vd_adr3Msg_volumeOffset
//  Created on:      08-Jun-2012 10:34:13
//  Original author: hag2hi
///////////////////////////////////////////////////////////

#include "vd_adr3Msg_volumeOffset.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
//#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "../../fc_audiomanager_trace.h"
#include "../../fc_audiomanager_trace_macros.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_ADR3_MAIN
//#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_ADR3MSG_VOLUMEOFFSET
#include "trcGenProj/Header/vd_adr3Msg_volumeOffset.cpp.trc.h"
#endif

#include "../../../PostOffice/PostOffice.hpp"
#include "../../InternalComponentCommunication/InternalCommunicationAdapter.h"
#include "../../InternalComponentCommunication/Messages/Volume/IDSetVolumeOffset.h"
#include "../../util/Macro.h"



/********************************************************************************
 * constructor
 *******************************************************************************/

vd_adr3Msg_volumeOffset::vd_adr3Msg_volumeOffset(vd_adr3_main* pAdr3Main):
  IF_MessageObserver<PO_MessageConfig::enID>("vd_adr3Msg_volumeOffset")
{
  ETG_TRACE_USR4(("vd_adr3Msg_volumeOffset::vd_adr3Msg_volumeOffset constructor. "));
    (tVoid)pAdr3Main;
  pPO = InternalCommunicationAdapter::getInstance();
  vAddObserver();
}


/********************************************************************************
 * destructor
 *******************************************************************************/
vd_adr3Msg_volumeOffset::~vd_adr3Msg_volumeOffset()
{
  InternalCommunicationAdapter::getInstance()->POMessages->DeRegisterObserver(this);
  pPO = NULL;
}

/********************************************************************************
 * vAddObserver()
 *******************************************************************************/
void vd_adr3Msg_volumeOffset::vAddObserver()
{

  ETG_TRACE_USR4(("vd_adr3Msg_volumeOffset::vAddObserver"));

  if(pPO != NULL)
  {
    ETG_TRACE_USR4(("vd_adr3Msg_volumeOffset::vAddObserver  pPO != NULL"));
    pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_SetVolumeOffset);
  }
  else
  {
    FATAL_M_ASSERT_ALWAYS();
  }

}

/********************************************************************************
 * s16LimitChannelValue()
 *******************************************************************************/
tS16 vd_adr3Msg_volumeOffset::s16LimitChannelValue(tS16 OffsetValue)
{
   ETG_TRACE_USR4(("vd_adr3Msg_volumeOffset:: s16LimitChannelValue entered OffsetValue :%d", OffsetValue));
  tS16 retVal = 0;
    if(OffsetValue < ADR3_CHANNEL_MIN)
    retVal = ADR3_CHANNEL_MIN;
  else if(OffsetValue > ADR3_CHANNEL_MAX)
      retVal = ADR3_CHANNEL_MAX;
  else
    retVal = OffsetValue;

  return retVal;
}

/********************************************************************************
 * MessageNotification()
 *******************************************************************************/
void vd_adr3Msg_volumeOffset::MessageNotification(PO_MessageConfig::enID MsgId)
{
  trMsgOut oMsgOut;
  tU8 *pu8Payload = oMsgOut.au8MsgData;
  ETG_TRACE_USR4(("vd_adr3Msg_volumeOffset::MessageNotification entered. "));
  // Obtaining the AudiovolumeOffset Message from PostOffice handler by Volume
  const MSG_SetVolumeOffset*     pMsg = pPO->POMessages->QueryMessage<MSG_SetVolumeOffset>(MsgId);

  ETG_TRACE_USR4(("volumeOffset Observer received m_enStream: 0x%4x.",   pMsg->values.m_enStream));
  ETG_TRACE_USR4(("volumeOffset Observer received s16Offset_LF: 0x%4x.", pMsg->values.s16Offset_LF));
  ETG_TRACE_USR4(("volumeOffset Observer received s16Offset_RF: 0x%4x.", pMsg->values.s16Offset_RF));
  ETG_TRACE_USR4(("volumeOffset Observer received s16Offset_LR: 0x%4x.", pMsg->values.s16Offset_LR));
  ETG_TRACE_USR4(("volumeOffset Observer received s16Offset_RR: 0x%4x.", pMsg->values.s16Offset_RR));
  ETG_TRACE_USR4(("volumeOffset Observer received s16Offset_CE: 0x%4x.", pMsg->values.s16Offset_CE));
  ETG_TRACE_USR4(("volumeOffset Observer received s16Offset_SUB: 0x%4x.",pMsg->values.s16Offset_SUB));
  ETG_TRACE_USR4(("volumeOffset Observer received u16RampLin: 0x%4x.",   pMsg->values.u16RampLin));
  ETG_TRACE_USR4(("volumeOffset Observer received u16RampdB: 0x%4x.",    pMsg->values.u16RampdB));

  //Deliver message to vd_adr3Msg_If::vSendAdr3Msg
  oMsgOut.u8InstId   = VD_ADR3_INST_ID_LS_1;
  oMsgOut.u16FktId   = VD_ADR3_FKT_ID_VOLUME_OFFSET;
  oMsgOut.enOpType   = VD_ADR3_OPTYPE_SETGET;
  oMsgOut.u16MsgLen  = 17;
  pu8Payload[0]     = (pMsg->values.m_enStream);
  pu8Payload[1]       = (tU8) (((s16LimitChannelValue(pMsg->values.s16Offset_LF)) & 0xFF00)>>8);
  pu8Payload[2]       = (tU8) ((s16LimitChannelValue(pMsg->values.s16Offset_LF)) & 0x00FF);
  pu8Payload[3]       = (tU8) (((s16LimitChannelValue(pMsg->values.s16Offset_RF)) & 0xFF00)>>8);
  pu8Payload[4]       = (tU8) ((s16LimitChannelValue(pMsg->values.s16Offset_RF)) & 0x00FF);
  pu8Payload[5]       = (tU8) (((s16LimitChannelValue(pMsg->values.s16Offset_LR)) & 0xFF00)>>8);
  pu8Payload[6]       = (tU8) ((s16LimitChannelValue(pMsg->values.s16Offset_LR)) & 0x00FF);
  pu8Payload[7]       = (tU8) (((s16LimitChannelValue(pMsg->values.s16Offset_RR)) & 0xFF00)>>8);
  pu8Payload[8]       = (tU8) ((s16LimitChannelValue(pMsg->values.s16Offset_RR)) & 0x00FF);
  pu8Payload[9]       = (tU8) (((s16LimitChannelValue(pMsg->values.s16Offset_CE)) & 0xFF00)>>8);
  pu8Payload[10]       = (tU8) ((s16LimitChannelValue(pMsg->values.s16Offset_CE)) & 0x00FF);
  pu8Payload[11]       = (tU8) (((s16LimitChannelValue(pMsg->values.s16Offset_SUB)) & 0xFF00)>>8);
  pu8Payload[12]       = (tU8) ((s16LimitChannelValue(pMsg->values.s16Offset_SUB)) & 0x00FF);
  pu8Payload[13]       = (tU8) (((pMsg->values.u16RampLin) & 0xFF00)>>8);
  pu8Payload[14]       = (tU8) ((pMsg->values.u16RampLin) & 0x00FF);
  pu8Payload[15]       = (tU8) (((pMsg->values.u16RampdB) & 0xFF00)>>8);
  pu8Payload[16]       = (tU8) ((pMsg->values.u16RampdB) & 0x00FF);

  switch(pMsg->values.m_enStream)
  {
  case EN_AUDIO_SOURCE_STREAM_MAIN:
    oMsgOut.u8ThreadMessageType = VOLUME_OFFSET_EXC;
    break;
  case EN_AUDIO_SOURCE_STREAM_MIX1:
    oMsgOut.u8ThreadMessageType = VOLUME_OFFSET_MIX1;
    break;
  case EN_AUDIO_SOURCE_STREAM_MIX2:
    oMsgOut.u8ThreadMessageType = VOLUME_OFFSET_MIX2;
    break;
  case EN_AUDIO_SOURCE_STREAM_MIX3:
    oMsgOut.u8ThreadMessageType = VOLUME_OFFSET_MIX3;
    break;
  default:
    ETG_TRACE_USR4(("!!! MessageNotification for undefined stream   : 0x%4x.", pMsg->values.m_enStream));
    break;
  }

  vd_adr3Msg_If::vSendAdr3Msg(&oMsgOut);
}



