///////////////////////////////////////////////////////////
//  vd_adr3Msg_volume.cpp
//  Implementation of the Class vd_adr3Msg_volume
//  Created on:      08-Jun-2012 10:34:13
//  Original author: hag2hi
///////////////////////////////////////////////////////////

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
//#define ET_TRACE_INFO_ON
#include <etrace_if.h>  // implicitly links generic <osal_if.h>
#include "AudioProxy/aud_gio_dbus_handler.h"
#include "AudioProxy/aud_gio_dbus_audproc_proxy.h"
#include "vd_adr3Msg_volume.h"

#include "../../InternalComponentCommunication/DataTypes/TypeDefines/Ext_Amp_ConnectionState.h"
#include "../../InternalComponentCommunication/Messages/Volume/ID_ADRSetVolume.h"
#include "../../InternalComponentCommunication/Messages/Volume/ID_Amp_SetVolume.h"
#include "../../InternalComponentCommunication/Messages/Volume/VolumeManager/ID_NotifyVolume.h"


#include "../../fc_audiomanager_trace.h"
#include "../../fc_audiomanager_trace_macros.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION
#include "trcGenProj/Header/vd_adr3Msg_volume.cpp.trc.h"
#endif
#include "../../util/Macro.h" // AUD_SET_U16()

tS16 vd_adr3Msg_volume::m_s16VolGain = 0;
tU16 vd_adr3Msg_volume::m_u16SpeedVolGain = 0;

vd_adr3Msg_volume::vd_adr3Msg_volume()
   : IF_MessageObserver<PO_MessageConfig::enID>("vd_adr3Msg_Volume")
{
   AUD_POINTER_CHECK_CALL_NO_RET_VALUE(InternalCommunicationAdapter::getInstance());
   AUD_POINTER_CHECK_CALL_NO_RET_VALUE(InternalCommunicationAdapter::getInstance()->POMessages);
   InternalCommunicationAdapter::getInstance()->POMessages->AddObserver(this , PO_MessageConfig::ID_ADR_SetVolume);
   InternalCommunicationAdapter::getInstance()->POMessages->AddObserver(this, PO_MessageConfig::ID_Amp_SetVolume);
   ETG_TRACE_USR2(("vd_adr3Msg_volume: Observer added for ID_ADR_SetVolume & ID_Amp_SetVolume"));

}

vd_adr3Msg_volume::~vd_adr3Msg_volume()
{
    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(InternalCommunicationAdapter::getInstance());
    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(InternalCommunicationAdapter::getInstance()->POMessages);
    InternalCommunicationAdapter::getInstance()->POMessages->DeRegisterObserver(this);
}

void vd_adr3Msg_volume::MessageNotification(PO_MessageConfig::enID MsgId)
{
    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(InternalCommunicationAdapter::getInstance());
    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(InternalCommunicationAdapter::getInstance()->POMessages);

   switch (MsgId)
   {
      case PO_MessageConfig::ID_ADR_SetVolume:
      {
         const ID_ADR_SetVolume* pMsg = InternalCommunicationAdapter::getInstance()->POMessages->QueryMessage<ID_ADR_SetVolume>(MsgId);

         ETG_TRACE_USR2(("vd_adr3Msg_volume::MessageNotification - ID_ADR_SetVolume received: Stream = 0x%4x, Step = 0x%4x, dB = 0x%4x, RampLin = 0x%4x, RampdB = 0x%4x"
            , pMsg->value.m_enStream, pMsg->value.m_VolStep, pMsg->value.m_VoldB, pMsg->value.m_RampLin, pMsg->value.m_RampdB));
         ETG_TRACE_USR2(("vd_adr3Msg_volume::MessageNotification resource (sink) %d",pMsg->value.m_Sink));
         m_s16VolGain = pMsg->value.m_VoldB;
         setVolume(pMsg->value);
      }
      break;

      case PO_MessageConfig::ID_Amp_SetVolume:
      {
         const ID_Amp_SetVolume* pMsg = InternalCommunicationAdapter::getInstance()->POMessages->QueryMessage <ID_Amp_SetVolume> (MsgId);
         AmpVolumeData oData (pMsg->value);

         ETG_TRACE_USR4(("vd_adr3Msg_volume: MessageNotification:VolStep: %x, VoldB:%x, RampLin:%x, RampdB:%x"
            , oData.m_VolStep, oData.m_VoldB, oData.m_RampLin, oData.m_RampdB));
         ETG_TRACE_USR2(("vd_adr3Msg_volume::MessageNotification resource (sink) %d",pMsg->value.m_Sink));
         m_s16VolGain = oData.m_VoldB;
         setVolume(oData);
      }
      break;

      default:
      {
         ETG_TRACE_ERR(("vd_adr3Msg_volume::MessageNotification - unhandled message received: %u", MsgId))
      }
      break;
   }
}


tVoid vd_adr3Msg_volume::setVolume(AmpVolumeData VolumeDataSet)
{
   trMsgOut oMsgOut;
   tU8 *pu8Payload = oMsgOut.au8MsgData;

   //Deliver message to vd_adr3Msg_If::vSendAdr3Msg
   //oMsgOut.u8InstId  = VD_ADR3_INST_ID_LS_1;
   oMsgOut.u8InstId  = (tU8)VolumeDataSet.m_Sink;
   oMsgOut.u16FktId  = VD_ADR3_FKT_ID_VOLUME;
   oMsgOut.enOpType  = VD_ADR3_OPTYPE_SETGET;
   oMsgOut.u16MsgLen = 8;
   pu8Payload[0]     = VolumeDataSet.m_enStream;

   pu8Payload[1]     = VolumeDataSet.m_VolStep;

   pu8Payload[2]     = (tU8) ((VolumeDataSet.m_VoldB & 0xFF00)>>8);
   pu8Payload[3]     = (tU8) (VolumeDataSet.m_VoldB & 0x00FF);

   pu8Payload[4]     = (tU8) ((VolumeDataSet.m_RampLin & 0xFF00)>>8);
   pu8Payload[5]     = (tU8) (VolumeDataSet.m_RampLin & 0x00FF);

   pu8Payload[6]     = (tU8) ((VolumeDataSet.m_RampdB & 0xFF00)>>8);
   pu8Payload[7]     = (tU8) (VolumeDataSet.m_RampdB & 0x00FF);

   ETG_TRACE_USR4(("vd_adr3Msg_volume: setVolume Payload: u32Length =0x%x, pu8Data=0x%02x",\
       oMsgOut.u16MsgLen, ETG_LIST_LEN(oMsgOut.u16MsgLen), ETG_LIST_PTR_T8(pu8Payload)));

   switch(VolumeDataSet.m_enStream)
   {
   case EN_AUDIO_SOURCE_STREAM_MAIN:
       if(oMsgOut.u8InstId== 2) //PrivateSpeaker
   oMsgOut.u8ThreadMessageType = VOLUME_EXC_SINK2;
       else if(oMsgOut.u8InstId == 17) //Line_Out
   oMsgOut.u8ThreadMessageType = VOLUME_EXC_SINK17;
       else
   oMsgOut.u8ThreadMessageType = VOLUME_EXC;

       vSendVolDataToAudProc(VolumeDataSet.m_VolStep);
       break;
   case EN_AUDIO_SOURCE_STREAM_MIX1:
     oMsgOut.u8ThreadMessageType = VOLUME_MIX1;
     break;
   case EN_AUDIO_SOURCE_STREAM_MIX2:
     oMsgOut.u8ThreadMessageType = VOLUME_MIX2;
     break;
   case EN_AUDIO_SOURCE_STREAM_MIX3:
     oMsgOut.u8ThreadMessageType = VOLUME_MIX3;
     break;
   default:
     ETG_TRACE_USR4(("!!! MessageNotification for undefined stream   : 0x%4x.", VolumeDataSet.m_enStream));
     break;
   }

   vd_adr3Msg_If::vSendAdr3Msg(&oMsgOut);

}

void vd_adr3Msg_volume::vHandleObserver_AmpConfig(tU8 AmpConfig)
{
    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(InternalCommunicationAdapter::getInstance());
    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(InternalCommunicationAdapter::getInstance()->POMessages);

  if(AmpConfig == EXTAMP_CONNECTED)
  {
    ETG_TRACE_USR2(("Ext_Amplifier is connected,Removing Adr3VolumeObserver as observer for ID_Amp_SetVolume"));
    InternalCommunicationAdapter::getInstance()->POMessages->RemoveObserver(this, PO_MessageConfig::ID_Amp_SetVolume);
  }

  else if(AmpConfig == EXTAMP_DISCONNECTED)
  {
    ETG_TRACE_USR2(("Ext_Amplifier is connected,Adding Adr3VolumeObserver as observer for ID_Amp_SetVolume"));
    InternalCommunicationAdapter::getInstance()->POMessages->AddObserver(this, PO_MessageConfig::ID_Amp_SetVolume);
  }
}

/********************************************************************************
 * vSendADRResponse()
 *******************************************************************************/
void vd_adr3Msg_volume::vSendADRResponse(trMsgOut *poAdrResponse)
{
   AUD_POINTER_CHECK_CALL_NO_RET_VALUE(InternalCommunicationAdapter::getInstance());
   AUD_POINTER_CHECK_CALL_NO_RET_VALUE(InternalCommunicationAdapter::getInstance()->POMessages);

  tU8 msgLen = (tU8)(poAdrResponse->u16MsgLen);
  ETG_TRACE_USR4(("vSendADRResponse received u16MsgLen: 0x%4x.", msgLen));
  tU8 volumeStep = poAdrResponse->au8MsgData[1];
  ETG_TRACE_USR4(("vSendADRResponse received volumeStep: 0x%4x.", volumeStep));

  ID_NotifyVolume oVolumeStep(volumeStep);
  InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oVolumeStep);

}

/********************************************************************************
 * vSendADRResponseSDVCState()
 *******************************************************************************/
void vd_adr3Msg_volume::vSendADRResponseSDVCState(trMsgOut *poAdrResponse)
{

  tU8 msgLen = (tU8)(poAdrResponse->u16MsgLen);
  ETG_TRACE_USR4(("vd_adr3Msg_volume::vSendADRResponseSDVCState received u16MsgLen: 0x%4x.", msgLen));

  tU16 u16Steps = AUD_GET_U16(&poAdrResponse->au8MsgData[0]);
  ETG_TRACE_USR4(("vd_adr3Msg_volume::vSendADRResponseSDVCState received Steps: 0x%4x.", u16Steps));

  m_u16SpeedVolGain  = AUD_GET_U16(&poAdrResponse->au8MsgData[2]);

  tU16 u16Speed = AUD_GET_U16(&poAdrResponse->au8MsgData[4]);
  ETG_TRACE_USR4(("vd_adr3Msg_volume::vSendADRResponseSDVCState received Speed: 0x%4x.", u16Speed));

  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(fc_audiomanager_tclApp::theServer()->poDBus());
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(fc_audiomanager_tclApp::theServer()->poDBus()->poGetAudioProcProxy());
  if(!fc_audiomanager_tclApp::theServer()->poDBus()->poGetAudioProcProxy()->set_aplArkamysCurrentSpeed((tS32)u16Speed))
  {
    ETG_TRACE_USR4(("vd_adr3Msg_volume::Audio Process service not up and running !  ! ! "));
  }

  tU16 u16CurVolAttenuation = u16GetCurVolAttenuation();
  ETG_TRACE_USR4(("vd_adr3Msg_volume::Invoking AudProc via DBus here with aplCurrentVolumeAttenuation for entertainment source and volume attenuation %d",u16CurVolAttenuation));
  if(!fc_audiomanager_tclApp::theServer()->poDBus()->poGetAudioProcProxy()->set_aplArkamysCurrentVolumeAttenuation((tS32)u16CurVolAttenuation))
  {
    ETG_TRACE_USR4(("vd_adr3Msg_volume::Audio Process service not up and running !  ! ! "));
  }
}

/********************************************************************************
 * vSendVolDataToAudProc()
 *******************************************************************************/
void vd_adr3Msg_volume::vSendVolDataToAudProc(tU8 u8VolumeSteps)
{
  ETG_TRACE_USR4(("vd_adr3Msg_volume::vSendVolDataToAudProc entered with volume steps %d", u8VolumeSteps));

  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(fc_audiomanager_tclApp::theServer()->poDBus());
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(fc_audiomanager_tclApp::theServer()->poDBus()->poGetAudioProcProxy());
  if(!fc_audiomanager_tclApp::theServer()->poDBus()->poGetAudioProcProxy()->set_aplArkamysCurrentVolumeStep((tS32)u8VolumeSteps))
  {
    ETG_TRACE_USR4(("VolumeSetAction::Audio Process service not up and running !  ! ! "));
  }

  tU16 u16CurVolumeAttenuation = u16GetCurVolAttenuation();
  ETG_TRACE_USR4(("vd_adr3Msg_volume::vSendVolDataToAudProc current volume attenuation level: %d.", u16CurVolumeAttenuation));
  if(!fc_audiomanager_tclApp::theServer()->poDBus()->poGetAudioProcProxy()->set_aplArkamysCurrentVolumeAttenuation((tS32)u16CurVolumeAttenuation))
  {
    ETG_TRACE_USR4(("vd_adr3Msg_volume::Audio Process service not up and running !  ! ! "));
  }
}

/********************************************************************************
 * u16GetCurVolAttenuation()
 *******************************************************************************/
tU16 vd_adr3Msg_volume::u16GetCurVolAttenuation()
{
    tU16 u16CurVolAttenuation = (tU16)(m_u16SpeedVolGain + m_s16VolGain);
    u16CurVolAttenuation = (tU16) (u16CurVolAttenuation * (-1));//converting to positive value
    ETG_TRACE_USR4(("vd_adr3Msg_volume::u16GetCurVolAttenuation received Gain + user gain: %d.", u16CurVolAttenuation));
    u16CurVolAttenuation /= 4;
    u16CurVolAttenuation = (tU16)(u16CurVolAttenuation * 128);

    return u16CurVolAttenuation;
}

