///////////////////////////////////////////////////////////
//  vd_adr3Msg_voltageState.cpp
//  Implementation of the Class vd_adr3Msg_voltageState
//  Created on:      08-Jun-2012 10:34:13
//  Original author: hag2hi
///////////////////////////////////////////////////////////

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
//#define ET_TRACE_INFO_ON
#include <etrace_if.h>  // implicitly links generic osal_if.h

#include "vd_adr3Msg_voltageState.h"
#include "vd_adr3Msg_If.h"

#include "aud_sinkmgr_main.h"
#include "aud_sinkmgr_pwramp.h"

#include "../../fc_audiomanager_trace.h"
#include "../../fc_audiomanager_trace_macros.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_ADR3_MAIN
//#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_ADR3MSG_VOLTAGESTATE
#include "trcGenProj/Header/vd_adr3Msg_voltageState.cpp.trc.h"
#endif

#include "../../../PostOffice/PostOffice.hpp"
#include "../../InternalComponentCommunication/InternalCommunicationAdapter.h"
#include "../../InternalComponentCommunication/Messages/mute/IDMuteStateHandleVoltage.h"
#include "../../util/Macro.h"



/********************************************************************************
 * constructor
 *******************************************************************************/

vd_adr3Msg_voltageState::vd_adr3Msg_voltageState(vd_adr3_main* pAdr3Main):
  IF_MessageObserver<PO_MessageConfig::enID>("vd_adr3Msg_voltageState")
{
  ETG_TRACE_USR4(("vd_adr3Msg_voltageState::vd_adr3Msg_voltageState constructor. "));
    (tVoid)pAdr3Main;
  pPO = InternalCommunicationAdapter::getInstance();
  vAddObserver();
}


/********************************************************************************
 * destructor
 *******************************************************************************/
vd_adr3Msg_voltageState::~vd_adr3Msg_voltageState()
{
  pPO->POMessages->DeRegisterObserver(this);
    pPO=NULL;
}

/********************************************************************************
 * vAddObserver()
 *******************************************************************************/
void vd_adr3Msg_voltageState::vAddObserver()
{

  ETG_TRACE_USR4(("vd_adr3Msg_voltageState::vAddObserver"));

  if(pPO != NULL)
  {
    ETG_TRACE_USR4(("vd_adr3Msg_voltageState::vAddObserver  pPO != NULL"));
    pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_MuteState_HandleVoltage);
  }
  else
  {
    FATAL_M_ASSERT_ALWAYS();
  }

}

/********************************************************************************
 * MessageNotification()
 *******************************************************************************/
void vd_adr3Msg_voltageState::MessageNotification(PO_MessageConfig::enID MsgId)
{
  trMsgOut oMsgOut;
  //tU8 *pu8Payload = oMsgOut.au8MsgData;
  ETG_TRACE_USR4(("vd_adr3Msg_voltageState::MessageNotification entered. "));
  // Obtaining the voltageState Message from PostOffice handler by mute
  const ID_MuteState_HandleVoltage*     pMsg = pPO->POMessages->QueryMessage<ID_MuteState_HandleVoltage>(MsgId);

   //tenVoltageState  en_VoltageState;
  ETG_TRACE_USR4(("Audio voltageState Observer received en_VoltageState: 0x%4x.", pMsg->en_VoltageState));

  aud_sinkmgr_pwramp* pPwrAmp = aud_sinkmgr_main::poGetPowerAmp();
  switch(pMsg->en_VoltageState)
  {
  case EN_AUDIO_VOLTAGESTATE_CRITICAL_LOW_VOLTAGE_START:
    //special mute. remove mute as sink mute is sent
    if (pPwrAmp)
      pPwrAmp->vSetLowPowerFlag(1);

    vd_adr3_If::vCallBackADRState(enADR3State_Unknown);

    break;
  case EN_AUDIO_VOLTAGESTATE_CRITICAL_LOW_VOLTAGE_END:
    if (pPwrAmp)
      pPwrAmp->vSetLowPowerFlag(0);

    //reset transferred status and send messages again to the ADR3
    vd_adr3Msg_If::vReloadADRData();
    
    /* For RTC- 816712, in case of device without ADR update device property state  
       as available and reset communication state to RUN  */
    if(vd_adr3_If::isSBRVariant())
       vd_adr3_If::vRxStartup();
    break;
  case EN_AUDIO_VOLTAGESTATE_HIGH_VOLTAGE_START:
    //mute
    if (pPwrAmp)
      pPwrAmp->vSetHighPowerFlag(1);
    break;
  case EN_AUDIO_VOLTAGESTATE_HIGH_VOLTAGE_END:
    //demute
    if (pPwrAmp)
      pPwrAmp->vSetHighPowerFlag(0);
    break;
  default:
    break;
  }

    //(tVoid)pu8Payload;


  #if 0
  //Deliver message to vd_adr3Msg_If::vSendAdr3Msg
  oMsgOut.u8InstId   = VD_ADR3_INST_ID_LS_1;
  oMsgOut.u16FktId   = VD_ADR3_FKT_ID_MUTE;
  oMsgOut.enOpType   = VD_ADR3_OPTYPE_SETGET;
  oMsgOut.u16MsgLen  = 6;
  //pu8Payload[0]     = pMsg->enStream;
  //pu8Payload[1]     = pMsg->enMuteAction;
  //AUD_SET_U16(&pu8Payload[2], pMsg->u16RampLin);
  //AUD_SET_U16(&pu8Payload[4], pMsg->u16RampdB);
  //ETG_TRACE_USR4(("pu8Payload=0x%02x",ETG_LIST_LEN(oMsgOut.u16MsgLen), ETG_LIST_PTR_T8(pu8Payload)));

  switch(pMsg->enStream)
  {
  case EN_AUDIO_SOURCE_STREAM_MAIN:
    oMsgOut.u8ThreadMessageType = MUTE_EXC;
    break;
  case EN_AUDIO_SOURCE_STREAM_MIX1:
    oMsgOut.u8ThreadMessageType = MUTE_MIX1;
    break;
  case EN_AUDIO_SOURCE_STREAM_MIX2:
    oMsgOut.u8ThreadMessageType = MUTE_MIX2;
    break;
  case EN_AUDIO_SOURCE_STREAM_MIX3:
    oMsgOut.u8ThreadMessageType = MUTE_MIX3;
    break;
  default:
    ETG_TRACE_USR4(("!!! MessageNotification for undefined stream   : 0x%4x.", pMsg->enStream));
    break;
  }

  vd_adr3Msg_If::vSendAdr3Msg(&oMsgOut);

#endif
}




