///////////////////////////////////////////////////////////
//  vd_adr3Msg_source.cpp
//  Implementation of the Class vd_adr3Msg_source
//  Created on:      08-Jun-2012 10:34:13
//  Original author: hag2hi
///////////////////////////////////////////////////////////

#include "vd_adr3Msg_source.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
//#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "../../fc_audiomanager_trace.h"
#include "../../fc_audiomanager_trace_macros.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_ADR3_MAIN
//#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_ADR3MSG_SOURCE
#include "trcGenProj/Header/vd_adr3Msg_source.cpp.trc.h"
#endif

#include "../../../PostOffice/PostOffice.hpp"
#include "../../InternalComponentCommunication/InternalCommunicationAdapter.h"
#include "../../InternalComponentCommunication/Messages/Source/IDSetSource.h"
#include "../../util/Macro.h"



/********************************************************************************
 * constructor
 *******************************************************************************/

vd_adr3Msg_source::vd_adr3Msg_source(vd_adr3_main* pAdr3Main):
  IF_MessageObserver<PO_MessageConfig::enID>("vd_adr3Msg_source")
{
  ETG_TRACE_USR4(("vd_adr3Msg_source::vd_adr3Msg_source constructor. "));
    (tVoid)pAdr3Main;
  pPO = InternalCommunicationAdapter::getInstance();
  vAddObserver();
}


/********************************************************************************
 * destructor
 *******************************************************************************/
vd_adr3Msg_source::~vd_adr3Msg_source()
{
  InternalCommunicationAdapter::getInstance()->POMessages->DeRegisterObserver(this);
  pPO = NULL;
}

/********************************************************************************
 * vAddObserver()
 *******************************************************************************/
void vd_adr3Msg_source::vAddObserver()
{

  ETG_TRACE_USR4(("vd_adr3Msg_source::vAddObserver"));

  if(pPO != NULL)
  {
    ETG_TRACE_USR4(("vd_adr3Msg_source::vAddObserver  pPO != NULL"));
    pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_SetSource);
  }
  else
  {
    FATAL_M_ASSERT_ALWAYS();
  }

}

/********************************************************************************
 * MessageNotification()
 *******************************************************************************/
void vd_adr3Msg_source::MessageNotification(PO_MessageConfig::enID MsgId)
{
  trMsgOut oMsgOut;
  tU8 *pu8Payload = oMsgOut.au8MsgData;
  ETG_TRACE_USR4(("vd_adr3Msg_source::MessageNotification entered. "));
  // Obtaining the Audiosource Message from PostOffice handler by Source
  const MSG_SetSource*     pMsg = pPO->POMessages->QueryMessage<MSG_SetSource>(MsgId);

  ETG_TRACE_USR4(("Audio source Observer received Stream: 0x%4x.", pMsg->enStream));
  ETG_TRACE_USR4(("Audio source Observer received Source: 0x%4x.", pMsg->enSourceType));

  //Deliver message to vd_adr3Msg_If::vSendAdr3Msg
  //oMsgOut.u8InstId   = VD_ADR3_INST_ID_LS_1;
  oMsgOut.u8InstId   = static_cast<tU8>(pMsg->sink);
  oMsgOut.u16FktId   = VD_ADR3_FKT_ID_SOURCE;
  oMsgOut.enOpType   = VD_ADR3_OPTYPE_SETGET;
  oMsgOut.u16MsgLen  = 2;
  pu8Payload[0]     = pMsg->enStream;
  pu8Payload[1]     = pMsg->enSourceType;

  switch(pMsg->enStream)
  {
  case EN_AUDIO_SOURCE_STREAM_MAIN:
    oMsgOut.u8ThreadMessageType = SOURCE_EXC;
    break;
  case EN_AUDIO_SOURCE_STREAM_MIX1:
    oMsgOut.u8ThreadMessageType = SOURCE_MIX1;
    break;
  case EN_AUDIO_SOURCE_STREAM_MIX2:
    oMsgOut.u8ThreadMessageType = SOURCE_MIX2;
    break;
  case EN_AUDIO_SOURCE_STREAM_MIX3:
    oMsgOut.u8ThreadMessageType = SOURCE_MIX3;
    break;
  default:
    ETG_TRACE_USR4(("!!! MessageNotification for undefined stream   : 0x%4x.", pMsg->enStream));
    break;
  }

  vd_adr3Msg_If::vSendAdr3Msg(&oMsgOut);
}

