///////////////////////////////////////////////////////////
//  vd_adr3Msg_soundConfigVersion.cpp
//  Implementation of the Class vd_adr3Msg_soundConfigVersion
//  Created on:      30-Nov-2012 10:34:13
//  Original author: daw2hi
///////////////////////////////////////////////////////////

#include "vd_adr3Msg_soundConfigVersion.h"
#include "vd_adr3Msg_If.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
//#define ET_TRACE_INFO_ON
#include <etrace_if.h>  // implicitly links <osal_if.h>
#include "../../fc_audiomanager_trace.h"
#include "../../fc_audiomanager_trace_macros.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_ADR3_MAIN
//#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_ADR3MSG_STARTUP
#include "trcGenProj/Header/vd_adr3Msg_soundConfigVersion.cpp.trc.h"
#endif

#include "../../../PostOffice/PostOffice.hpp"
#include "../../InternalComponentCommunication/InternalCommunicationAdapter.h"
#include "../../InternalComponentCommunication/Messages/SoundConfig/IDNotifySoundConfigVersion.h"
#include "../../util/Macro.h"


/********************************************************************************
 * constructor
 *******************************************************************************/

vd_adr3Msg_soundConfigVersion::vd_adr3Msg_soundConfigVersion(vd_adr3_main* pAdr3Main):
  IF_MessageObserver<PO_MessageConfig::enID>("vd_adr3Msg_soundConfigVersion")
{
  ETG_TRACE_USR4(("vd_adr3Msg_soundConfigVersion::vd_adr3Msg_soundConfigVersion constructor. "));
  (tVoid)pAdr3Main;
   pPO = InternalCommunicationAdapter::getInstance();
   AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pPO);
}


/********************************************************************************
 * destructor
 *******************************************************************************/
vd_adr3Msg_soundConfigVersion::~vd_adr3Msg_soundConfigVersion()
{
  InternalCommunicationAdapter::getInstance()->POMessages->DeRegisterObserver(this);
  pPO = NULL;
}

/********************************************************************************
 * vAddObserver()
 *******************************************************************************/
void vd_adr3Msg_soundConfigVersion::vAddObserver()const
{

}

/********************************************************************************
 * MessageNotification()
 *******************************************************************************/
void vd_adr3Msg_soundConfigVersion::MessageNotification(PO_MessageConfig::enID MsgId)
{
  (tVoid)MsgId;
}

/********************************************************************************
 * vSendADRResponse()
 *******************************************************************************/
void vd_adr3Msg_soundConfigVersion::vSendADRResponse(trMsgOut *poAdrResponse)
{
   if (NULL == poAdrResponse)   // should never happen
   {
      ETG_TRACE_FATAL(("vd_adr3Msg_soundConfigVersion::vSendADRResponse: E R R O R : invalid pointer to poAdrResponse"));
      return;
   }

  tU8  u8FileID = 0;
   tU32 u32Version = 0;
   tU32 u32CRC = 0;
   ID_NotifySoundConfigVersion::tenValidity isValid = ID_NotifySoundConfigVersion::enOK;

   if (VD_ADR3_OPTYPE_ERROR == poAdrResponse->enOpType)
   {
      tU8 u8ErrorCode = 0xFF;
      tU8 u8ErrorInfo = 0;
      if (poAdrResponse->u16MsgLen > 1)
         u8ErrorInfo = poAdrResponse->au8MsgData[1];
      if (poAdrResponse->u16MsgLen > 0)
         u8ErrorCode = poAdrResponse->au8MsgData[0];

      ETG_TRACE_ERR(("vd_adr3Msg_soundConfigVersion::vSendADRResponse: Error response received: length=%u, ErrorCode=0x%x, ErrorInfo=0x%x"
            , poAdrResponse->u16MsgLen, u8ErrorCode, u8ErrorInfo))

      // enable this once it is confirmed by Dieter Thoms
//      u8FileID = u8ErrorInfo;

      isValid = ID_NotifySoundConfigVersion::enUnhandledFileID;
   }
   else if (poAdrResponse->u16MsgLen < 9)
   {
      ETG_TRACE_ERR(("vd_adr3Msg_soundConfigVersion::vSendADRResponse: response message too short: OpType=0x%x, length=%u, content=0x%02x"
            , poAdrResponse->enOpType, poAdrResponse->u16MsgLen, ETG_LIST_LEN(poAdrResponse->u16MsgLen), ETG_LIST_PTR_T8(poAdrResponse->au8MsgData)))

      isValid = ID_NotifySoundConfigVersion::enError;
   }
   else
   {
      u8FileID = poAdrResponse->au8MsgData[0];

      // do this later with some private function or use something availabel
      u32Version = poAdrResponse->au8MsgData[1];
      u32Version = u32Version<<8;
      u32Version = u32Version + poAdrResponse->au8MsgData[2];
      u32Version = u32Version<<8;
      u32Version = u32Version + poAdrResponse->au8MsgData[3];
      u32Version = u32Version<<8;
      u32Version = u32Version + poAdrResponse->au8MsgData[4];

      u32CRC = poAdrResponse->au8MsgData[5];
      u32CRC = u32CRC<<8;
      u32CRC = u32CRC + poAdrResponse->au8MsgData[6];
      u32CRC = u32CRC<<8;
      u32CRC = u32CRC + poAdrResponse->au8MsgData[7];
      u32CRC = u32CRC<<8;
      u32CRC = u32CRC + poAdrResponse->au8MsgData[8];

      ETG_TRACE_USR2(("vd_adr3Msg_soundConfigVersion::vSendADRResponse: 0x%1x, 0x%04x, 0x%04x", u8FileID, u32Version, u32CRC));
   }

  //Delivering the ID_NotifyMute  Message back to Service Function
  ID_NotifySoundConfigVersion notifySoundConfigVersion(u8FileID, u32Version, u32CRC, isValid);
  InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&notifySoundConfigVersion);

}


