///////////////////////////////////////////////////////////
//  vd_adr3Msg_signalTone.cpp
//  Implementation of the Class vd_adr3Msg_signalTone
//  Created on:      08-Jun-2012 10:34:13
//  Original author: hag2hi
///////////////////////////////////////////////////////////

#include "vd_adr3Msg_signalTone.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
//#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "../../fc_audiomanager_trace.h"
#include "../../fc_audiomanager_trace_macros.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_ADR3_MAIN
//#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_ADR3MSG_SIGNALTONE
#include "trcGenProj/Header/vd_adr3Msg_signalTone.cpp.trc.h"
#endif

#include "../../../PostOffice/PostOffice.hpp"
#include "../../InternalComponentCommunication/InternalCommunicationAdapter.h"
#include "../../InternalComponentCommunication/Messages/Beep/IDSignalTone.h"
#include "../../InternalComponentCommunication/Messages/Beep/IDNotifySignalTone.h"
#include "../../InternalComponentCommunication/DataTypes/TypeDefines/ADR3NotifyBeep.h"
#include "../../util/Macro.h"



/********************************************************************************
 * constructor
 *******************************************************************************/

vd_adr3Msg_signalTone::vd_adr3Msg_signalTone(vd_adr3_main* pAdr3Main):
  IF_MessageObserver<PO_MessageConfig::enID>("vd_adr3Msg_signalTone")
{
  ETG_TRACE_USR4(("vd_adr3Msg_signalTone::vd_adr3Msg_signalTone constructor. "));
  (tVoid)pAdr3Main;
  pPO = InternalCommunicationAdapter::getInstance();
  vAddObserver();
}


/********************************************************************************
 * destructor
 *******************************************************************************/
vd_adr3Msg_signalTone::~vd_adr3Msg_signalTone()
{
  InternalCommunicationAdapter::getInstance()->POMessages->DeRegisterObserver(this);
  pPO = NULL;
}

/********************************************************************************
 * vAddObserver()
 *******************************************************************************/
void vd_adr3Msg_signalTone::vAddObserver()
{

  ETG_TRACE_USR4(("vd_adr3Msg_signalTone::vAddObserver"));

  if(pPO != NULL)
  {
    ETG_TRACE_USR4(("vd_adr3Msg_signalTone::vAddObserver  pPO != NULL"));
    pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_SignalTone);
  }
  else
  {
    FATAL_M_ASSERT_ALWAYS();
  }

}

/********************************************************************************
 * MessageNotification()
 *******************************************************************************/
void vd_adr3Msg_signalTone::MessageNotification(PO_MessageConfig::enID MsgId)
{
  trMsgOut oMsgOut;
  tU8 *pu8Payload = oMsgOut.au8MsgData;
  ETG_TRACE_USR4(("vd_adr3Msg_signalTone::MessageNotification entered. "));
  // Obtaining the AudiosignalTone Message from PostOffice handler by Beep
  const MSG_SignalTone*     pMsg = pPO->POMessages->QueryMessage<MSG_SignalTone>(MsgId);

  ETG_TRACE_USR4(("SignalTone Observer received SignalToneType: %x", pMsg->SignalToneType));
  ETG_TRACE_USR4(("SignalTone Observer received SignalToneAction: %x", pMsg->SignalToneAction));

  //Deliver message to vd_adr3Msg_If::vSendAdr3Msg
  oMsgOut.u8InstId   = VD_ADR3_INST_ID_LS_1;
  oMsgOut.u16FktId   = VD_ADR3_FKT_ID_SIGNAL_TONE;
  oMsgOut.enOpType   = VD_ADR3_OPTYPE_SETGET;
  oMsgOut.u16MsgLen  = 2;
  pu8Payload[0]     = pMsg->SignalToneType;
  pu8Payload[1]     = pMsg->SignalToneAction;

  oMsgOut.u8ThreadMessageType = SIGNALTONE;
  vd_adr3Msg_If::vSendAdr3Msg(&oMsgOut);
}

/********************************************************************************
 * vSendADRResponse()
 *******************************************************************************/
void vd_adr3Msg_signalTone::vSendADRResponse(trMsgOut *poAdrResponse)
{
  tU8 ubSignalToneType;
  tU8 ubSignalToneState;

  ubSignalToneType  = poAdrResponse->au8MsgData[0];
  ubSignalToneState = poAdrResponse->au8MsgData[1];

  ETG_TRACE_USR4(("vSendADRResponse received ubSignalToneType : 0x%4x.", ubSignalToneType));
  ETG_TRACE_USR4(("vSendADRResponse received ubSignalToneState: 0x%4x.", ubSignalToneState));


  //Delivering the ID_NotifyMute  Message back to Service Function
  ID_NotifySignalTone notifySignalTone(ubSignalToneType,static_cast<tenBeepState>(ubSignalToneState));
  InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&notifySignalTone);

}

