///////////////////////////////////////////////////////////
//  vd_adr3Msg_powerState.cpp
//  Implementation of the Class vd_adr3Msg_powerState
//  Created on:      08-Jun-2012 10:34:13
//  Original author: hag2hi
///////////////////////////////////////////////////////////

#include "vd_adr3Msg_powerState.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
//#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "../../fc_audiomanager_trace.h"
#include "../../fc_audiomanager_trace_macros.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_ADR3_MAIN
#include "trcGenProj/Header/vd_adr3Msg_powerState.cpp.trc.h"
#endif

#include "../../../PostOffice/PostOffice.hpp"
#include "../../InternalComponentCommunication/InternalCommunicationAdapter.h"
#include "../../InternalComponentCommunication/Messages/power/IDPowerState.h"
#include "../../util/Macro.h"
#include "aud_sinkmgr_main.h"
#include "aud_sinkmgr_pwramp.h"

tU8 ubAdr3State;
/*EN_AUDIO_ADR_POWER_STATE_OFF     = 0x00,
  EN_AUDIO_ADR_POWER_STATE_STANDBY = 0x01,
  EN_AUDIO_ADR_POWER_STATE_ON      = 0x02*/

/********************************************************************************
 * constructor
 *******************************************************************************/

vd_adr3Msg_powerState::vd_adr3Msg_powerState(vd_adr3_main* pAdr3Main):
  IF_MessageObserver<PO_MessageConfig::enID>("vd_adr3Msg_powerState")
{
  ETG_TRACE_USR4(("vd_adr3Msg_powerState::vd_adr3Msg_powerState constructor. "));
  (tVoid)pAdr3Main;
  pPO = InternalCommunicationAdapter::getInstance();
  vAddObserver();
  ubAdr3State = EN_AUDIO_ADR_POWER_STATE_OFF;
}


/********************************************************************************
 * destructor
 *******************************************************************************/
vd_adr3Msg_powerState::~vd_adr3Msg_powerState()
{
   InternalCommunicationAdapter::getInstance()->POMessages->DeRegisterObserver(this);
   pPO = NULL;
}

/********************************************************************************
 * vAddObserver()
 *******************************************************************************/
void vd_adr3Msg_powerState::vAddObserver()
{

  ETG_TRACE_USR4(("vd_adr3Msg_powerState::vAddObserver"));

  if(pPO != NULL)
  {
    ETG_TRACE_USR4(("vd_adr3Msg_powerState::vAddObserver  pPO != NULL"));
    pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_PowerState);
  }
  else
  {
    FATAL_M_ASSERT_ALWAYS();
  }

}

/********************************************************************************
 * MessageNotification()
 *******************************************************************************/
void vd_adr3Msg_powerState::MessageNotification(PO_MessageConfig::enID MsgId)
{
  trMsgOut oMsgOut;
  tU8 *pu8Payload = oMsgOut.au8MsgData;
  ETG_TRACE_USR4(("vd_adr3Msg_powerState::MessageNotification entered. "));
  // Obtaining the vd_adr3Msg_powerState Message from PostOffice handler
  const ID_PowerState*     pMsg = pPO->POMessages->QueryMessage<ID_PowerState>(MsgId);

  ETG_TRACE_USR4(("ID_PowerState Observer received PowerState: 0x%4x.", pMsg->PowerState));
  ETG_TRACE_USR4(("ID_PowerState Observer received optype: 0x%4x.", pMsg->Optype));

  //Deliver message to vd_adr3Msg_If::vSendAdr3Msg
  oMsgOut.u8InstId   = VD_ADR3_INST_ID_LS_1;
  oMsgOut.u16FktId   = VD_ADR3_FKT_ID_POWER_STATE;
  oMsgOut.enOpType   = pMsg->Optype;
  oMsgOut.u16MsgLen  = 1;
  pu8Payload[0]     = pMsg->PowerState;

  if(oMsgOut.enOpType == VD_ADR3_OPTYPE_GET)
  {
    oMsgOut.u16MsgLen  = 0;
  }

  oMsgOut.u8ThreadMessageType = POWERSTATE;
  vd_adr3Msg_If::vSendAdr3Msg(&oMsgOut);

  //save power state off/standby immediately. For fast off on the ADR skips the reply of first command.
  //For power state on the response from ADR is needed.
  if ((oMsgOut.enOpType != VD_ADR3_OPTYPE_GET)&&(pMsg->PowerState !=EN_AUDIO_ADR_POWER_STATE_ON))
  {
    ubAdr3State = pMsg->PowerState;
  }
}

/********************************************************************************
 * vSendADRResponse()
 *******************************************************************************/
void vd_adr3Msg_powerState::vSendADRResponse(trMsgOut *poAdrResponse)
{
  tU8 ubLastState;

  ubLastState = ubAdr3State;
  ubAdr3State    = poAdrResponse->au8MsgData[0];
  ETG_TRACE_USR4(("vSendADRResponse received ubAdr3State = 0x%4x. LastState = 0x%4x", ubAdr3State, ubLastState));

  if(ubAdr3State == EN_AUDIO_ADR_POWER_STATE_ON)
  {
     aud_sinkmgr_pwramp* pPwrAmp = aud_sinkmgr_main::poGetPowerAmp();
     if (pPwrAmp)
        pPwrAmp->vCheckPwrAmpTmr();
  }
}

/********************************************************************************
 * ubGetAdr3PowerState()
 *******************************************************************************/
tU8 vd_adr3Msg_powerState::ubGetAdr3PowerState(tVoid)
{
  ETG_TRACE_USR4(("vubGetAdr3PowerState() ubAdr3State = %u ",ubAdr3State));

  return ubAdr3State;
}
