///////////////////////////////////////////////////////////
//  vd_adr3Msg_muteChannel.cpp
//  Implementation of the Class vd_adr3Msg_muteChannel
//  Created on:      08-Jun-2012 10:34:13
//  Original author: hag2hi
///////////////////////////////////////////////////////////

#include "vd_adr3Msg_muteChannel.h"
#include "vd_adr3Msg_If.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
//#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "../../fc_audiomanager_trace.h"
#include "../../fc_audiomanager_trace_macros.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_ADR3_MAIN
//#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_ADR3MSG_MUTECHANNEL
#include "trcGenProj/Header/vd_adr3Msg_muteChannel.cpp.trc.h"
#endif

#include "../../../PostOffice/PostOffice.hpp"
#include "../../InternalComponentCommunication/InternalCommunicationAdapter.h"
#include "../../InternalComponentCommunication/Messages/mute/IDSetMuteChannel.h"
#include "../../util/Macro.h"



/********************************************************************************
 * constructor
 *******************************************************************************/

vd_adr3Msg_muteChannel::vd_adr3Msg_muteChannel(vd_adr3_main* pAdr3Main):IF_MessageObserver<PO_MessageConfig::enID>("vd_adr3Msg_muteChannel")
{
  ETG_TRACE_USR4(("vd_adr3Msg_muteChannel::vd_adr3Msg_muteChannel constructor. "));

  (tVoid)pAdr3Main;
  pPO = InternalCommunicationAdapter::getInstance();
  vAddObserver();
}


/********************************************************************************
 * destructor
 *******************************************************************************/
vd_adr3Msg_muteChannel::~vd_adr3Msg_muteChannel()
{
  InternalCommunicationAdapter::getInstance()->POMessages->DeRegisterObserver(this);
  pPO = NULL;
}

/********************************************************************************
 * vAddObserver()
 *******************************************************************************/
void vd_adr3Msg_muteChannel::vAddObserver()
{

  ETG_TRACE_USR4(("vd_adr3Msg_muteChannel::vAddObserver"));

  if(pPO != NULL)
  {
    ETG_TRACE_USR4(("vd_adr3Msg_muteChannel::vAddObserver  pPO != NULL"));
    pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_SetMuteChannel);
  }
  else
  {
    FATAL_M_ASSERT_ALWAYS();
  }

}

/********************************************************************************
 * MessageNotification()
 *******************************************************************************/
void vd_adr3Msg_muteChannel::MessageNotification(PO_MessageConfig::enID MsgId)
{
  trMsgOut oMsgOut;
  tU8 *pu8Payload = oMsgOut.au8MsgData;
  ETG_TRACE_USR4(("vd_adr3Msg_muteChannel::MessageNotification entered. "));

  // Obtaining the muteChannel Message from PostOffice handler by muteChannel
  (tVoid)MsgId;


  const ID_SetMuteChannel*     pMsg = pPO->POMessages->QueryMessage<ID_SetMuteChannel>(MsgId);

  ETG_TRACE_USR4(("Audio muteChannel Observer received Stream: 0x%4x.",      pMsg->enStream));
  ETG_TRACE_USR4(("Audio muteChannel Observer received ChannelMask: 0x%4x.", pMsg->u8ChannelMask));
  ETG_TRACE_USR4(("Audio muteChannel Observer received Source: 0x%4x.",      pMsg->enMuteAction));

  //Deliver message to vd_adr3Msg_If::vSendAdr3Msg
  oMsgOut.u8InstId     = VD_ADR3_INST_ID_LS_1;
  oMsgOut.u16FktId     = VD_ADR3_FKT_ID_MUTE_CHANNEL;
  oMsgOut.enOpType     = VD_ADR3_OPTYPE_SETGET;
  oMsgOut.u16MsgLen    = 7;
  pu8Payload[0]       = pMsg->enStream;
  pu8Payload[1]       = pMsg->u8ChannelMask; //0x3f
  pu8Payload[2]       = pMsg->enMuteAction;
  AUD_SET_U16(&pu8Payload[3], pMsg->u16RmpLin);
  AUD_SET_U16(&pu8Payload[5], pMsg->u16RmpdB);
  ETG_TRACE_USR4(("pu8Payload=0x%02x",ETG_LIST_LEN(oMsgOut.u16MsgLen), ETG_LIST_PTR_T8(pu8Payload)));

  oMsgOut.u8ThreadMessageType = MUTE_CHANNEL;


  vd_adr3Msg_If::vSendAdr3Msg(&oMsgOut);


}
