///////////////////////////////////////////////////////////
//  vd_adr3Msg_filter.cpp
//  Implementation of the Class vd_adr3Msg_filter
//  Created on:      08-Jun-2012 10:34:13
//  Original author: hag2hi
///////////////////////////////////////////////////////////

#include "vd_adr3Msg_filter.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
//#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "../../fc_audiomanager_trace.h"
#include "../../fc_audiomanager_trace_macros.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_ADR3_MAIN
//#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_ADR3MSG_FILTER
#include "trcGenProj/Header/vd_adr3Msg_filter.cpp.trc.h"
#endif

#include "../../../PostOffice/PostOffice.hpp"
#include "../../InternalComponentCommunication/InternalCommunicationAdapter.h"
#include "../../InternalComponentCommunication/Messages/Equ_Filter/IDSetFilter.h"
#include "../../InternalComponentCommunication/Messages/Equ_Filter/IDNotifyFilter.h"
#include "../../util/Macro.h"



/********************************************************************************
 * constructor
 *******************************************************************************/

vd_adr3Msg_filter::vd_adr3Msg_filter(vd_adr3_main* pAdr3Main):
  IF_MessageObserver<PO_MessageConfig::enID>("vd_adr3Msg_filter")
{
  ETG_TRACE_USR4(("vd_adr3Msg_filter::vd_adr3Msg_filter constructor. "));
  (tVoid)pAdr3Main;
  pPO = InternalCommunicationAdapter::getInstance();
  vAddObserver();
}


/********************************************************************************
 * destructor
 *******************************************************************************/
vd_adr3Msg_filter::~vd_adr3Msg_filter()
{
   InternalCommunicationAdapter::getInstance()->POMessages->DeRegisterObserver(this);
   pPO = NULL;
}

/********************************************************************************
 * vAddObserver()
 *******************************************************************************/
void vd_adr3Msg_filter::vAddObserver()
{

  ETG_TRACE_USR4(("vd_adr3Msg_filter::vAddObserver"));

  if(pPO != NULL)
  {
    ETG_TRACE_USR4(("vd_adr3Msg_filter::vAddObserver  pPO != NULL"));
    pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_SetFilter);
  }
  else
  {
    FATAL_M_ASSERT_ALWAYS();
  }

}

/********************************************************************************
 * MessageNotification()
 *******************************************************************************/
void vd_adr3Msg_filter::MessageNotification(PO_MessageConfig::enID MsgId)
{
  trMsgOut oMsgOut;
  tU8 *pu8Payload = oMsgOut.au8MsgData;
  ETG_TRACE_USR4(("vd_adr3Msg_filter::MessageNotification entered. "));
  // Obtaining the Audiofilter Message from PostOffice handler by Equ_Filter
  const MSG_SetFilter*     pMsg = pPO->POMessages->QueryMessage<MSG_SetFilter>(MsgId);

  ETG_TRACE_USR4(("filter Observer received u8FilterID: 0x%4x.",         pMsg->values.u8FilterID));
  ETG_TRACE_USR4(("filter Observer received u8FilterCharacteristic: 0x%4x.",  pMsg->values.u8FilterCharacteristic));
  ETG_TRACE_USR4(("filter Observer received u8Order: 0x%4x.",           pMsg->values.u8Order));
  ETG_TRACE_USR4(("filter Observer received u16Frequency: 0x%4x.",         pMsg->values.u16Frequency));
  ETG_TRACE_USR4(("filter Observer received s16Gain: 0x%4x.",           pMsg->values.s16Gain));
  ETG_TRACE_USR4(("filter Observer received u8QFactor: 0x%4x.",         pMsg->values.u8QFactor));

  //Deliver message to vd_adr3Msg_If::vSendAdr3Msg
  oMsgOut.u8InstId   = VD_ADR3_INST_ID_LS_1;
  oMsgOut.u16FktId   = VD_ADR3_FKT_ID_SET_FILTER;
  oMsgOut.enOpType   = VD_ADR3_OPTYPE_SETGET;
  oMsgOut.u16MsgLen  = 8;
  pu8Payload[0]     = pMsg->values.u8FilterID;
  pu8Payload[1]       = pMsg->values.u8FilterCharacteristic;
  pu8Payload[2]       = pMsg->values.u8Order;
  pu8Payload[3]       = (tU8) (((pMsg->values.u16Frequency) & 0xFF00)>>8);
  pu8Payload[4]       = (tU8) ((pMsg->values.u16Frequency) & 0x00FF);
  pu8Payload[5]       = (tU8) (((pMsg->values.s16Gain) & 0xFF00)>>8);
  pu8Payload[6]       = (tU8) ((pMsg->values.s16Gain) & 0x00FF);
  pu8Payload[7]       = pMsg->values.u8QFactor;

  oMsgOut.u8ThreadMessageType = (tU8)(pu8Payload[0] + SET_FILTER_1);// for fm enhancer 1, 2, 3

  vd_adr3Msg_If::vSendAdr3Msg(&oMsgOut);
}


/********************************************************************************
 * vSendADRResponse()
 *******************************************************************************/
void vd_adr3Msg_filter::vSendADRResponse(trMsgOut *poAdrResponse)
{
  tU8 msgLen = (tU8)poAdrResponse->u16MsgLen;
  ETG_TRACE_USR4(("vSendADRResponse received u16MsgLen: 0x%4x.", msgLen));
  tU8 filterId = poAdrResponse->au8MsgData[0];
  ETG_TRACE_USR4(("vSendADRResponse received filter id: 0x%4x.", filterId));

  SetFilterData outData;
  outData.u8FilterID     = poAdrResponse->au8MsgData[0];
  outData.u8FilterCharacteristic       = poAdrResponse->au8MsgData[1];
  outData.u8Order       = poAdrResponse->au8MsgData[2];
  OSAL_pvMemoryCopy(&outData.u16Frequency, &poAdrResponse->au8MsgData[3], sizeof(tU16));
  OSAL_pvMemoryCopy(&outData.s16Gain, &poAdrResponse->au8MsgData[5], sizeof(tS16));
  outData.u8QFactor = poAdrResponse->au8MsgData[7];

  IDNotifyFilter oNotifyFilter(outData);
  InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oNotifyFilter);

}
