///////////////////////////////////////////////////////////
//  vd_adr3Msg_equSetting.cpp
//  Implementation of the Class vd_adr3Msg_equSetting
//  Created on:      08-Jun-2012 10:34:13
//  Original author: hag2hi
///////////////////////////////////////////////////////////

#include "vd_adr3Msg_equSetting.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
//#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "../../fc_audiomanager_trace.h"
#include "../../fc_audiomanager_trace_macros.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_ADR3_MAIN
//#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_ADR3MSG_EQUSETTING
#include "trcGenProj/Header/vd_adr3Msg_equSetting.cpp.trc.h"
#endif

#include "../../../PostOffice/PostOffice.hpp"
#include "../../InternalComponentCommunication/InternalCommunicationAdapter.h"
#include "../../InternalComponentCommunication/Messages/Equ_Filter/IDEquSetting.h"
#include "../../util/Macro.h"



/********************************************************************************
 * constructor
 *******************************************************************************/

vd_adr3Msg_equSetting::vd_adr3Msg_equSetting(vd_adr3_main* pAdr3Main):
  IF_MessageObserver<PO_MessageConfig::enID>("vd_adr3Msg_equSetting")
{
  ETG_TRACE_USR4(("vd_adr3Msg_equSetting::vd_adr3Msg_equSetting constructor. "));
  (tVoid)pAdr3Main;
  pPO = InternalCommunicationAdapter::getInstance();
  vAddObserver();
}


/********************************************************************************
 * destructor
 *******************************************************************************/
vd_adr3Msg_equSetting::~vd_adr3Msg_equSetting()
{
  InternalCommunicationAdapter::getInstance()->POMessages->DeRegisterObserver(this);
  pPO = NULL;
}

/********************************************************************************
 * vAddObserver()
 *******************************************************************************/
void vd_adr3Msg_equSetting::vAddObserver()
{

  ETG_TRACE_USR4(("vd_adr3Msg_equSetting::vAddObserver"));

  if(pPO != NULL)
  {
    ETG_TRACE_USR4(("vd_adr3Msg_equSetting::vAddObserver  pPO != NULL"));
    pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_EquSetting);
  }
  else
  {
    FATAL_M_ASSERT_ALWAYS();
  }

}

/********************************************************************************
 * MessageNotification()
 *******************************************************************************/
void vd_adr3Msg_equSetting::MessageNotification(PO_MessageConfig::enID MsgId)
{
  trMsgOut oMsgOut;
  tU8 *pu8Payload = oMsgOut.au8MsgData;
  ETG_TRACE_USR4(("vd_adr3Msg_equSetting::MessageNotification entered. "));
  // Obtaining the equSetting Message from PostOffice handler by Equ_Filter
  const MSG_EquSetting*     pMsg = pPO->POMessages->QueryMessage<MSG_EquSetting>(MsgId);

  ETG_TRACE_USR4(("equSetting Observer received u8EquID: 0x%4x.",       pMsg->values.u8EquID));
  ETG_TRACE_USR4(("equSetting Observer received u8EquBand: 0x%4x.",    pMsg->values.u8EquBand));
  ETG_TRACE_USR4(("equSetting Observer received s16Gain: 0x%4x.",       pMsg->values.s16Gain));
  ETG_TRACE_USR4(("equSetting Observer received u8FrequencyIndex: 0x%4x.",pMsg->values.u8FrequencyIndex));
  ETG_TRACE_USR4(("equSetting Observer received u8QFactor: 0x%4x.",     pMsg->values.u8QFactor));

  //Deliver message to vd_adr3Msg_If::vSendAdr3Msg
  oMsgOut.u8InstId   = VD_ADR3_INST_ID_LS_1;
  oMsgOut.u16FktId   = VD_ADR3_FKT_ID_EQU_SETTINGS;
  oMsgOut.enOpType   = VD_ADR3_OPTYPE_SETGET;
  oMsgOut.u16MsgLen  = 6;
  pu8Payload[0]     = (tU8) (pMsg->values.u8EquID);
  pu8Payload[1]       = (tU8) (pMsg->values.u8EquBand) ;
  pu8Payload[2]       = (tU8) (((pMsg->values.s16Gain) & 0xFF00)>>8);
  pu8Payload[3]       = (tU8) ((pMsg->values.s16Gain) & 0x00FF);
  pu8Payload[4]       = (tU8) (pMsg->values.u8FrequencyIndex);
  pu8Payload[5]       = (tU8) (pMsg->values.u8QFactor);

  //oMsgOut.u8ThreadMessageType = ; this message type is not part of current project

  vd_adr3Msg_If::vSendAdr3Msg(&oMsgOut);
}
