///////////////////////////////////////////////////////////
//  vd_adr3Msg_diagResult.cpp
//  Implementation of the Class vd_adr3Msg_diagResult
//  Created on:      08-Jun-2012 10:34:13
//  Original author: hag2hi
///////////////////////////////////////////////////////////

#include "vd_adr3Msg_diagResult.h"
#include "vd_adr3Msg_If.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
//#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "../../fc_audiomanager_trace.h"
#include "../../fc_audiomanager_trace_macros.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_ADR3_MAIN
//#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_ADR3MSG_DIAGRESULT
#include "trcGenProj/Header/vd_adr3Msg_diagResult.cpp.trc.h"
#endif

#include "../../../PostOffice/PostOffice.hpp"
#include "../../InternalComponentCommunication/InternalCommunicationAdapter.h"
#include "../../InternalComponentCommunication/Messages/Diag/IDGetDiagResult.h"
#include "../../InternalComponentCommunication/Messages/Diag/IDNotifyDiagResult.h"
#include "../InternalComponentCommunication/Messages/Diag/IDGetDiagStatus.h"
#include "../../util/Macro.h"



/********************************************************************************
 * constructor
 *******************************************************************************/

vd_adr3Msg_diagResult::vd_adr3Msg_diagResult(vd_adr3_main* pAdr3Main):
  IF_MessageObserver<PO_MessageConfig::enID>("vd_adr3Msg_diagResult")
{
  ETG_TRACE_USR4(("vd_adr3Msg_diagResult::vd_adr3Msg_diagResult constructor. "));
  (tVoid)pAdr3Main;
  pPO = InternalCommunicationAdapter::getInstance();
  vAddObserver();
}


/********************************************************************************
 * destructor
 *******************************************************************************/
vd_adr3Msg_diagResult::~vd_adr3Msg_diagResult()
{
  InternalCommunicationAdapter::getInstance()->POMessages->DeRegisterObserver(this);
 pPO = NULL;
}

/********************************************************************************
 * vAddObserver()
 *******************************************************************************/
void vd_adr3Msg_diagResult::vAddObserver()
{

  ETG_TRACE_USR4(("vd_adr3Msg_diagResult::vAddObserver"));

  if(pPO != NULL)
  {
    ETG_TRACE_USR4(("vd_adr3Msg_diagResult::vAddObserver  pPO != NULL"));
    pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_GetDiagResult);
  }
  else
  {
    FATAL_M_ASSERT_ALWAYS();
  }

}

/********************************************************************************
 * MessageNotification()
 *******************************************************************************/
void vd_adr3Msg_diagResult::MessageNotification(PO_MessageConfig::enID MsgId)
{
  trMsgOut oMsgOut;
  tU8 *pu8Payload = oMsgOut.au8MsgData;
  ETG_TRACE_USR4(("vd_adr3Msg_diagResult::MessageNotification entered. "));
  // Obtaining the Diag Message from PostOffice handler
  const ID_GetDiagResult*     pMsg = pPO->POMessages->QueryMessage<ID_GetDiagResult>(MsgId);

  ETG_TRACE_USR4(("Audio diag result received ErrorSite: 0x%4x.", pMsg->enErrorSite));

  //Deliver message to vd_adr3Msg_If::vSendAdr3Msg
  oMsgOut.u8InstId   = VD_ADR3_INST_ID_LS_1;
  oMsgOut.u16FktId   = VD_ADR3_FKT_ID_DIAG_RESULT;
  oMsgOut.enOpType   = VD_ADR3_OPTYPE_GET;
  oMsgOut.u16MsgLen  = 1;
  pu8Payload[0]     = pMsg->enErrorSite;

    oMsgOut.u8ThreadMessageType = DIAG_GET_RESULT;
  vd_adr3Msg_If::vSendAdr3Msg(&oMsgOut);
}

/********************************************************************************
 * vSendADRResponse()
 *******************************************************************************/
void vd_adr3Msg_diagResult::vSendADRResponse(trMsgOut *poAdrResponse)
{
  tU8 ubErrorSite;
  tU8 ubErrorCode;
  tU8 ubErrorValue;

  tU8 msgLen = (tU8)(poAdrResponse->u16MsgLen);
  ETG_TRACE_USR4(("vSendADRResponse received u16MsgLen: 0x%4x.", msgLen));
  ubErrorSite = poAdrResponse->au8MsgData[0];
  ETG_TRACE_USR4(("vSendADRResponse received ubErrorSite: 0x%4x.", ubErrorSite));
  if((msgLen % 2)==1)//pair of error codes and values
  {
    for(int i = 1; i < msgLen;)
    {
      ubErrorCode = poAdrResponse->au8MsgData[i++];
      ubErrorValue = poAdrResponse->au8MsgData[i++];


      ETG_TRACE_USR4(("vSendADRResponse received ubErrorCode: 0x%4x.", ubErrorCode));
      ETG_TRACE_USR4(("vSendADRResponse received ubErrorValue: 0x%4x.", ubErrorValue));


      //Delivering the ID_NotifyDiagResult  Message back to Service Function
      ID_NotifyDiagResult notifyDiagResult(static_cast<tenErrorSite>(ubErrorSite),static_cast<tenErrorCode>(ubErrorCode),static_cast<tenErrorValue>(ubErrorValue));
      InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&notifyDiagResult);
    }
    //Send the Message to vd_adr3
    ETG_TRACE_USR4(("vSendADRResponse request diagnosis status"));
       ID_GetDiagStatus oGetDiagStatus;
       InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oGetDiagStatus);
  }
  else
    ETG_TRACE_USR4(("vSendADRResponse received wrong response for speaker diagnosis"));
}


