///////////////////////////////////////////////////////////
//  vd_adr3Msg_clipping.cpp
//  Implementation of the Class vd_adr3Msg_clipping
//  Created on:      08-Jun-2012 10:34:13
//  Original author: hag2hi
///////////////////////////////////////////////////////////

#include "vd_adr3Msg_clipping.h"
#include "vd_adr3Msg_If.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
//#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "../../fc_audiomanager_trace.h"
#include "../../fc_audiomanager_trace_macros.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_ADR3_MAIN
//#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_ADR3MSG_CLIPPING
#include "trcGenProj/Header/vd_adr3Msg_clipping.cpp.trc.h"
#endif

#include "../../../PostOffice/PostOffice.hpp"
#include "../../InternalComponentCommunication/InternalCommunicationAdapter.h"
#include "../../InternalComponentCommunication/Messages/Clipping/ID_Clipping_Level.h"
#include "../../util/Macro.h"



/********************************************************************************
 * constructor
 *******************************************************************************/

vd_adr3Msg_clipping::vd_adr3Msg_clipping(vd_adr3_main* pAdr3Main):
  IF_MessageObserver<PO_MessageConfig::enID>("vd_adr3Msg_clipping")
{
  ETG_TRACE_USR4(("vd_adr3Msg_clipping::vd_adr3Msg_clipping constructor. "));
  (tVoid)pAdr3Main;

  pPO = InternalCommunicationAdapter::getInstance();
  vAddObserver();
}


/********************************************************************************
 * destructor
 *******************************************************************************/
vd_adr3Msg_clipping::~vd_adr3Msg_clipping()
{
  InternalCommunicationAdapter::getInstance()->POMessages->DeRegisterObserver(this);
  pPO = NULL;
}

/********************************************************************************
 * vAddObserver()
 *******************************************************************************/
void vd_adr3Msg_clipping::vAddObserver()
{

  ETG_TRACE_USR4(("vd_adr3Msg_clipping::vAddObserver"));

  if(pPO != NULL)
  {
    ETG_TRACE_USR4(("vd_adr3Msg_clipping::vAddObserver  pPO != NULL"));
    pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_Clipping_Level);
  }
  else
  {
    FATAL_M_ASSERT_ALWAYS();
  }

}

/********************************************************************************
 * MessageNotification()
 *******************************************************************************/
void vd_adr3Msg_clipping::MessageNotification(PO_MessageConfig::enID MsgId)
{
  trMsgOut oMsgOut;
  tU8 *pu8Payload = oMsgOut.au8MsgData;
  ETG_TRACE_USR4(("vd_adr3Msg_clipping::MessageNotification entered. "));

  // Obtaining the Message from PostOffice handler
  const ID_Clipping_Level*     pMsg = pPO->POMessages->QueryMessage<ID_Clipping_Level>(MsgId);

  ETG_TRACE_USR4(("Audio clipping Observer received en_Clipping_Level: 0x%4x.", pMsg->en_Clipping_Level));


  //Deliver message to vd_adr3Msg_If::vSendAdr3Msg
  oMsgOut.u8InstId   = VD_ADR3_INST_ID_LS_1;
  oMsgOut.u16FktId   = VD_ADR3_FKT_ID_CLIPPING;
  oMsgOut.enOpType   = VD_ADR3_OPTYPE_SET;
  oMsgOut.u16MsgLen  = 2;
  pu8Payload[0]     = 0x01; //Clipping Device 1
  pu8Payload[1]     = pMsg->en_Clipping_Level;
  ETG_TRACE_USR4(("pu8Payload=0x%02x",ETG_LIST_LEN(oMsgOut.u16MsgLen), ETG_LIST_PTR_T8(pu8Payload)));

  oMsgOut.u8ThreadMessageType = CLIPPING;

  vd_adr3Msg_If::vSendAdr3Msg(&oMsgOut);
}

