///////////////////////////////////////////////////////////
//  vd_adr3Msg_carSetting.cpp
//  Implementation of the Class vd_adr3Msg_carSetting
//  Created on:      08-Jun-2012 10:34:13
//  Original author: hag2hi
///////////////////////////////////////////////////////////

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
//#define ET_TRACE_INFO_ON
#include <etrace_if.h>   // implicitly links generic <osal_if.h>


#include "../../InternalComponentCommunication/InternalCommunicationAdapter.h"
#include "../../InternalComponentCommunication/Messages/CarSetting/IDCarSetting.h"
#include "vd_adr3Msg_If.h"
#include "vd_adr3Msg_carSetting.h"
#include "../../util/Macro.h" // AUD_SET_U16()

#include "../../fc_audiomanager_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_ADR3_MAIN
//#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_ADR3MSG_DIAGRESULT
#include "trcGenProj/Header/vd_adr3Msg_carSetting.cpp.trc.h"
#endif


/********************************************************************************
 * constructor
 *******************************************************************************/

vd_adr3Msg_carSetting :: vd_adr3Msg_carSetting (vd_adr3_main* /* pAdr3Main */):
  IF_MessageObserver<PO_MessageConfig::enID>("vd_adr3Msg_carSetting")
{
  ETG_TRACE_USR4(("vd_adr3Msg_carSetting::vd_adr3Msg_carSetting constructor. "));

  InternalCommunicationAdapter::getInstance()->POMessages->AddObserver(this, PO_MessageConfig::ID_CarSetting);
}


/********************************************************************************
 * destructor
 *******************************************************************************/
vd_adr3Msg_carSetting::~vd_adr3Msg_carSetting()
{
   InternalCommunicationAdapter::getInstance()->POMessages->DeRegisterObserver(this);
   ETG_TRACE_USR4(("vd_adr3Msg_carSetting::vd_adr3Msg_carSetting destructor. "));
}

/********************************************************************************
 * MessageNotification()
 *******************************************************************************/
void vd_adr3Msg_carSetting::MessageNotification(PO_MessageConfig::enID MsgId)
{
  trMsgOut oMsgOut;
  tU8 *pu8Payload = oMsgOut.au8MsgData;

  // Obtaining the Diag Message from PostOffice handler
  const ID_CarSetting*     pMsg
     = InternalCommunicationAdapter::getInstance()->POMessages->QueryMessage<ID_CarSetting>(MsgId);

  ETG_TRACE_USR3((" forwarding CarSetting message to ADR3: Type = %u, Value = %d."
        , pMsg->enCarSettingType, pMsg->s16Value))

  //Deliver message to vd_adr3Msg_If::vSendAdr3Msg
  oMsgOut.u8InstId   = VD_ADR3_INST_ID_LS_1;
  oMsgOut.u16FktId   = VD_ADR3_FKT_ID_CAR_SETTING;
  oMsgOut.enOpType   = VD_ADR3_OPTYPE_SET;
  oMsgOut.u16MsgLen  = 3;
  pu8Payload[0]     = pMsg->enCarSettingType;
  AUD_SET_U16(&pu8Payload[1], pMsg->s16Value);

  oMsgOut.u8ThreadMessageType = CARSETTING;

  vd_adr3Msg_If::vSendAdr3Msg(&oMsgOut);
}




