
///////////////////////////////////////////////////////////
//  vd_adr3Msg_If.cpp
//  Implementation of the Class vd_adr3Msg_If
//  Created on:      08-Jun-2012 10:34:13
//  Original author: hag2hi
///////////////////////////////////////////////////////////

#include "vd_adr3Msg_If.h"
#include "vd_adr3Message_Data.h"

#include <netinet/in.h>

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#include "../../fc_audiomanager_trace.h"
#include "../../fc_audiomanager_trace_macros.h"
#include "../../fc_audiomanager_main.h"
#include "../../fc_audiomanager_service_Audio_Function.h"

#include "../../InternalComponentCommunication/DataTypes/TypeDefines/ADR3Settings.h"
#include "../../InternalComponentCommunication/Messages/settings/IDSettings.h"
#include "../../InternalComponentCommunication/Messages/mute/IDSetMute.h"
#include "../../InternalComponentCommunication/Messages/mute/IDMuteStateHandleVoltage.h"
#include "../../InternalComponentCommunication/Messages/Volume/IDSetVolumeOffset.h"

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS
#include "InternalComponentCommunication/Messages/Sound/ID_ArkamysParameter.h"

#include "Arkamys/ArkamysADRInterface.h"
#include "Arkamys/ArkamysFeatInterface.h"

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS_CLASSIC
#include "Arkamys/RNAIVI/ArkamysFeatureHandlerRNAIVI.h"
#include "Sound/ArkamysTuningHandlerRNAIVI.h"
#include "Sound/ArkamysTuningHandlerRNAIVI2.h"
#include "vd_adr3Msg_arkamysParameter.h"
#endif // VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS_CLASSIC

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS_PSA
#include "Arkamys/PSA/ArkamysFeatureHandler.h"
#include "Sound/ArkamysTuningHandler.h"
#endif // VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS_PSA

#endif // VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ENGINE_SOUND
#include "InternalComponentCommunication/Messages/Sound/ID_EngineSound_Version.h"

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ENGINE_SOUND_PSA
#include "EngineSound/EngineSoundADRInterface.h"
#include "EngineSound/EngineSoundHandler.h"
#endif//VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ENGINE_SOUND_PSA

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ENGINE_SOUND_IVI
#include "InternalComponentCommunication/Messages/Sound/ID_EngineSound_LibVersion.h"
#include "EngineSound/RNAIVI/EngineSoundHandlerIVI.h"
#include "Sound/ESETuningHandlerRNAIVI.h"
#endif//VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ENGINE_SOUND_IVI

#endif // VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ENGINE_SOUND

#include "../../../PostOffice/PostOffice.hpp"
#include "../../../PostOffice/BaseMessage.h"

#include "../../InternalComponentCommunication/Messages/power/IDPowerState.h"
#include "../../InternalComponentCommunication/Messages/vd_AmpResponses/ID_AmpdeviceId.h"
#include "../../InternalComponentCommunication/InternalCommunicationAdapter.h"

#include "vd_adr3Msg_mute.h"
#include "vd_adr3Msg_startup.h"
#include "vd_adr3Msg_signalTone.h"
#include "vd_adr3Msg_signalToneParameters.h"
#include "vd_adr3Msg_chimeParameters.h"
#include "vd_adr3Msg_diagResult.h"
#include "vd_adr3Msg_soundConfigVersion.h"

#include "vd_adr3Msg_filter.h"
#include "vd_adr3Msg_volume.h"

#include "aud_sinkmgr_main.h"

#include "aud_sinkmgr_pwramp.h"

#include "vd_adr3Msg_powerState.h"
#include "vd_adr3Message_Data.h"
#include "vd_adr3Msg_diagSpeaker.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_ADR3MSG_IF
#include "trcGenProj/Header/vd_adr3Msg_If.cpp.trc.h"
#endif

// defines
#define NUM_OF_MESSAGES_DISABLE_VALUE_CHANGE_CHECK  (sizeof(au8MsgTypeDisableCheckValueChange)/sizeof(au8MsgTypeDisableCheckValueChange[0]))
#define NUM_OF_RELOAD_MESSAGES_AFTER_RESET          (sizeof(au8MsgTypeTransferAfterReset)/sizeof(au8MsgTypeTransferAfterReset[0]))

//GLOBAL VARIABLES
vd_adr3Msg_If* vd_adr3Msg_If::poADR3Msg=NULL;


vd_adr3Message_Data aclMessageBuffer[NUM_OF_MESSAGE_TYPES];
tU8  u8LastSentThreadMessageType;
tU32 u32LastSentMsgID;

tU8 ubDemuteWait;
#define NO_DEMUTE     0
#define DEMUTE_WAIT   1
#define DEMUTE        2
#define ADR_ERRORCODE_BUSY 0x40

//constructor
trMsgOut::trMsgOut()
{
   au8MsgData = OSAL_NEW tU8[AUD_ADR_MAX_PAYLOAD];

  enOpType = 0x00;
  u16FktId = 0x00;
  u16MsgLen = 0x00;
  u8InstId= 0x00;
  u8ThreadMessageType = 0x00;

  if(au8MsgData == NULL)
  {
      ETG_TRACE_ERR(("trMsgOut::trMsgOut Alloc Error"));
    NORMAL_M_ASSERT_ALWAYS();
   }
}
//destructor
trMsgOut::~trMsgOut()
{
   if(au8MsgData != NULL) {
    OSAL_DELETE []au8MsgData;
   }
   else {
      ETG_TRACE_ERR(("trMsgOut::~trMsgOut ERROR Pointer unexpected NULL value"));
   }

}


/********************************************************************************
 * constructor
 *******************************************************************************/
vd_adr3Msg_If::vd_adr3Msg_If()
{
  ETG_TRACE_USR2(("vd_adr3Msg_If() constructor."));
  u8LastSentThreadMessageType = 0;
  u32LastSentMsgID = 0;
  m_vd_adr3_If = NULL;

}

/********************************************************************************
 * destructor
 *******************************************************************************/
vd_adr3Msg_If::~vd_adr3Msg_If()
{

  m_vd_adr3_If = NULL;
}


/********************************************************************************
 * vInit()
 *******************************************************************************/
void vd_adr3Msg_If::vInit(void)
{

  tU8 i;

  if (poADR3Msg==NULL)
  {
    poADR3Msg = new(vd_adr3Msg_If);
    fc_audiomanager_tclApp::theServer()->vRegisterTraceInputs(TRC::enAdr3MsgIf, poADR3Msg);
  }

  //disable comparison with last message value
  for(i = 0; i < NUM_OF_MESSAGES_DISABLE_VALUE_CHANGE_CHECK; i++){
    aclMessageBuffer[au8MsgTypeDisableCheckValueChange[i]].vSetCheckValueChange(FALSE);
  }
}

/********************************************************************************
 * vDeInit()
 *******************************************************************************/
void vd_adr3Msg_If::vDeInit(void){
 delete (poADR3Msg);
}

/********************************************************************************
 * :vSendAdr3Msg(trMsgOut *poMsgOut)
 *******************************************************************************/
void vd_adr3Msg_If::vSendAdr3Msg(trMsgOut *poMsgOut){

  vSendMsg(poMsgOut->u8InstId,poMsgOut->u16FktId, poMsgOut->enOpType, poMsgOut->u16MsgLen, poMsgOut->au8MsgData, poMsgOut->u8ThreadMessageType);
}


/********************************************************************************
 * vSendMsg()
 *******************************************************************************/
void vd_adr3Msg_If::vSendMsg(tU8 u8InstId, tU16 u16FktId, tU8 enOpType, tU32 u16MsgLen, const tU8 *pu8MsgData, tU8 u8ThreadMessageType){
  tBool bRet;
  tU8 u8ADRPayloadLen;
  trMsgAdrOutput oAdrOutput;
  bRet = FALSE;
  tU8 *pu8AdrMsg = oAdrOutput.au8AdrMsg;

  //size of u32MsgLen: min length  + variable payload
  oAdrOutput.u32MsgLen = (u16MsgLen + enAdrMsgOffset_PAYLOAD_DATA);
  AUD_SET_U16(&pu8AdrMsg[enAdrMsgOffset_CLIENT_ID], AUD_CLIENT_ID);
  AUD_SET_U16(&pu8AdrMsg[enAdrMsgOffset_FBLOCK_ID], AUD_FBLOCK_ID);
  pu8AdrMsg[enAdrMsgOffset_INSTANCE_ID]=u8InstId;
  AUD_SET_U16(&pu8AdrMsg[enAdrMsgOffset_FKT_ID], u16FktId);
  pu8AdrMsg[enAdrMsgOffset_OP_TYPE]=(tU8)enOpType;
  AUD_SET_U16(&pu8AdrMsg[enAdrMsgOffset_PAYLOAD_LEN], u16MsgLen);
  OSAL_pvMemoryCopy(&pu8AdrMsg[enAdrMsgOffset_PAYLOAD_DATA], pu8MsgData, u16MsgLen);
  u8ADRPayloadLen = (tU8)(u16MsgLen + 5);

  if((u16FktId == VD_ADR3_FKT_ID_PING)||(u16FktId == VD_ADR3_FKT_ID_CLIPPING)||(u16FktId == VD_ADR3_FKT_ID_CAR_SETTING))
  {

    et_vTraceBinary(TR_CLASS_VD_ADR3MSG_IF, TR_LEVEL_USER_4, ET_EN_T8LIST, u8ADRPayloadLen, &pu8AdrMsg[enAdrMsgOffset_FKT_ID], ET_EN_DONE);
  }
  else
  {

    et_vTraceBinary(TR_CLASS_VD_ADR3MSG_IF, TR_LEVEL_USER_2, ET_EN_T8LIST, u8ADRPayloadLen, &pu8AdrMsg[enAdrMsgOffset_FKT_ID], ET_EN_DONE);
  }

  ETG_TRACE_USR4(("vSendMsg() u8ThreadMessageType = %u", ETG_CENUM(enMsgType, u8ThreadMessageType)))
  if(u8ThreadMessageType >= NUM_OF_MESSAGE_TYPES)
  {
    ETG_TRACE_USR4(("vSendMsg() invalid u8ThreadMessageType !!!!!!!!!!!!!!!!!!!!!!"));
    return;
  }

  //check for no change, if allowed
  bRet = aclMessageBuffer[u8ThreadMessageType].bCheckValueChange(pu8AdrMsg,oAdrOutput.u32MsgLen);
  if(bRet == FALSE)
  {
    //save new value
    bRet = aclMessageBuffer[u8ThreadMessageType].bSetValue(pu8AdrMsg,oAdrOutput.u32MsgLen);
    ETG_TRACE_USR4(("vSendMsg()bRet=%u",(tU8) bRet));
  }


  //check pending messages
  vd_adr3_main::vSendAdr3WorkerThreadEvent((tU32) EVENT_VD_ADR3_CHECK_NEXT_MESSAGE);

}

/********************************************************************************
 * vTraceRx()
 *******************************************************************************/
tVoid vd_adr3Msg_If::vTraceRx(tU32 size, tPCUChar pcu8Data)
{
  trMsgOut oAdrResponse;
  tU8 ubErrorCode;
  // pcu8Data[0] == tenTrcTrcClassName
  // pcu8Data[1] == tenTrcFuncInput
  // pcu8Data[2] == the 1. parameter
  // pcu8Data[3] == the 2. parameter

  if ((size <= 2) || (NULL == pcu8Data))
  {
    ETG_TRACE_FATAL((" vd_adr3Msg_If::vTraceRx() called with invalid message: size = %u, pcu8Data = 0x%08x.", size, pcu8Data))
    return;
  }
  else
    ETG_TRACE_USR3((" vd_adr3Msg_If::vTraceRx(%i, %02x) entered.", size, ETG_LIST_LEN(size), ETG_LIST_PTR_T8(pcu8Data)))

  tPCUChar pcu8ADRmsg = pcu8Data + 2;

  switch ( pcu8Data[1] ) // tenTrcFuncInput
  {
  case TRC::enADRResponse:
  {

    ETG_TRACE_USR2(("vTraceRx()\n u32Length =0x%x,\n pu8Data=0x%02x", size,
            ETG_LIST_LEN(size), ETG_LIST_PTR_T8(pcu8Data)));
    et_vTraceBinary(TR_CLASS_VD_ADR3MSG_IF, TR_LEVEL_USER_2, ET_EN_T8LIST, size, pcu8Data, ET_EN_DONE);

    oAdrResponse.u8InstId   = pcu8ADRmsg[enAdrMsgOffset_INSTANCE_ID];
    oAdrResponse.u16FktId   = AUD_GET_U16(&pcu8ADRmsg[enAdrMsgOffset_FKT_ID]);
    oAdrResponse.enOpType   = pcu8ADRmsg[enAdrMsgOffset_OP_TYPE];
    oAdrResponse.u16MsgLen  = AUD_GET_U16(&pcu8ADRmsg[enAdrMsgOffset_PAYLOAD_LEN]);
    if(OSAL_NULL == oAdrResponse.au8MsgData)
      {
        NORMAL_M_ASSERT_ALWAYS();
        return;
      }
    (OSAL_pvMemoryCopy(oAdrResponse.au8MsgData,&pcu8ADRmsg[enAdrMsgOffset_PAYLOAD_DATA],oAdrResponse.u16MsgLen));
    ETG_TRACE_USR4((" ADR3 Msg with FID %x received",oAdrResponse.u16FktId));

    if (    (oAdrResponse.enOpType == VD_ADR3_OPTYPE_ERROR)
         && (VD_ADR3_FKT_ID_SOUND_CONFIG_VERSION != oAdrResponse.u16FktId))  // forward this error response for sound-file synchronization sequence
    {
      ubErrorCode = pcu8ADRmsg[enAdrMsgOffset_PAYLOAD_DATA];
      ETG_TRACE_FATAL((" ADR3 ERROR code 0x%x for FID 0x%x ",ubErrorCode,oAdrResponse.u16FktId));
      if(oAdrResponse.u16FktId == VD_ADR3_FKT_ID_CHIME_PARAM && ubErrorCode == ADR_ERRORCODE_BUSY) //ErrorCode: 0x40 -> Busy
        vd_adr3Msg_chimeParameters::vSendErrorResponse();
      return;
    }

    switch(oAdrResponse.u16FktId)
    {
    case VD_ADR3_FKT_ID_STARTUP:
    {
      ETG_TRACE_USR2(("vTraceRx: case VD_ADR3_FKT_ID_STARTUP:"));

      //call get current status of internal amplifier
      ID_PowerState setPowerState((EN_AUDIO_ADR_POWER_STATE_OFF),(VD_ADR3_OPTYPE_GET));
      InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&setPowerState);

      vd_adr3Msg_startup::vSendADRResponse(&oAdrResponse);

      //set communication state and check for waiting messages
      vd_adr3_If::vRxStartup();
      vd_adr3Msg_If::vReloadADRData();  //add this line
      aud_sinkmgr_pwramp* pPwrAmp = aud_sinkmgr_main::poGetPowerAmp();
      if (pPwrAmp)
         pPwrAmp->vCheckPwrAmp();
      else
      {
         ID_PowerState setPowerStateOn(EN_AUDIO_ADR_POWER_STATE_ON, VD_ADR3_OPTYPE_SETGET);
         InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&setPowerStateOn);
      }

    }
      break;
    case VD_ADR3_FKT_ID_POWER_STATE:
      ETG_TRACE_USR2(("vTraceRx: case VD_ADR3_FKT_ID_POWER_STATE:"));
      vd_adr3Msg_powerState::vSendADRResponse(&oAdrResponse);
      break;
    case VD_ADR3_FKT_ID_MUTE:
      ETG_TRACE_USR2(("vTraceRx: case VD_ADR3_FKT_ID_MUTE:"));
      vd_adr3Msg_mute::vSendADRResponse(&oAdrResponse);
      break;

    case VD_ADR3_FKT_ID_AMPLIFIERDEVICE:
          {
             ETG_TRACE_USR2(("vTraceRx: case VD_ADR3_FKT_ID_AMPLIFIERDEVICE:"));
             if (oAdrResponse.enOpType == VD_ADR3_OPTYPE_STATUS)
               {
                 ID_AmpdeviceId oampdeviceid(oAdrResponse.au8MsgData[0]);
                 InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oampdeviceid);
               }
          }
        break;
    case VD_ADR3_FKT_ID_SIGNAL_TONE:
      ETG_TRACE_USR2(("vTraceRx: case VD_ADR3_FKT_ID_SIGNAL_TONE:"));
      vd_adr3Msg_signalTone::vSendADRResponse(&oAdrResponse);
      break;
    case VD_ADR3_FKT_ID_SIGNAL_TONE_PARAM:
      ETG_TRACE_USR2(("vTraceRx: case VD_ADR3_FKT_ID_SIGNAL_TONE_PARAM:"));
      vd_adr3Msg_signalToneParameters::vSendADRResponse(&oAdrResponse);
      break;
    case VD_ADR3_FKT_ID_CHIME_PARAM:
      ETG_TRACE_USR2(("vTraceRx: case VD_ADR3_FKT_ID_CHIME_PARAM:"));
      vd_adr3Msg_chimeParameters::vSendADRResponse(&oAdrResponse);
      break;
    case VD_ADR3_FKT_ID_DIAG_RESULT:
      ETG_TRACE_USR2(("vTraceRx: case VD_ADR3_FKT_ID_DIAG_RESULT:"));
      vd_adr3Msg_diagResult::vSendADRResponse(&oAdrResponse);
      break;
    case VD_ADR3_FKT_ID_DIAG_SPEAKER:
      ETG_TRACE_USR2(("vTraceRx: case VD_ADR3_FKT_ID_DIAG_SPEAKER:"));
      vd_adr3Msg_diagSpeaker::vSendADRResponse(&oAdrResponse);
      break;
    case VD_ADR3_FKT_ID_SOUND_CONFIG_VERSION:
       ETG_TRACE_USR2(("vTraceRx: case VD_ADR3_FKT_ID_SOUND_CONFIG_VERSION:"));
       vd_adr3Msg_soundConfigVersion::vSendADRResponse(&oAdrResponse);
       break;
    case VD_ADR3_FKT_ID_PING:
      ETG_TRACE_USR4(("vTraceRx: case VD_ADR3_FKT_ID_PING:"));
      if(oAdrResponse.enOpType == VD_ADR3_OPTYPE_STATUS)
      {
        //Ping message received. Clear communication lost counter
        vd_adr3_If::vClearCommunicationLostCounter();
      }
      else
      {
        //VD_ADR3_OPTYPE_ERROR
        ETG_TRACE_USR4(("vTraceRx: start ping timer"));
        vd_adr3_If::vStartPingTimer();
      }
      break;
       case VD_ADR3_FKT_ID_SETTINGS:
          ETG_TRACE_USR4(("vTraceRx: case VD_ADR3_FKT_ID_SETTINGS:"));
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS
          // Need to store balance and fader values for Arkamys feature
          if (oAdrResponse.enOpType == VD_ADR3_OPTYPE_STATUS && oAdrResponse.u16MsgLen == 4)
          {
             ETG_TRACE_USR4(("Settings Status: Stream=%i SettingType=%i Steps=%i"
                   , ETG_CENUM(tenStream, oAdrResponse.au8MsgData[0])
                   , ETG_CENUM(tenSettingType, oAdrResponse.au8MsgData[1])
                   , AUD_GET_U16(&oAdrResponse.au8MsgData[2])));
          }
#endif // VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS
          break;
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS
      case VD_ADR3_FKT_ID_ARKAMYS_PARAMETER:
         ETG_TRACE_USR2(("ADR3: ArkamysParameter response: %x", ETG_LIST_LEN(size), ETG_LIST_PTR_T8(pcu8Data)));
         {
            tPCU8 pu8Optype  = &pcu8Data[ 9]; // == ADR optype (i.e. VD_ADR3_OPTYPE_STATUS)
            //                  pcu8Data[10]; // == Length from here in bytes
            //                  pcu8Data[11]     == Length from here in bytes
            tPCU8 pu8Address = &pcu8Data[12]; // == Address
            //                  pcu8Data[13]     == Address
            //                  pcu8Data[14]     == Address
            //                  pcu8Data[15]     == Address
            tPCU8 pu8Length  = &pcu8Data[16]; // == Length from here in words
            //                  pcu8Data[17]     == Length from here in words
            //                  pcu8Data[18]     == Length from here in words
            //                  pcu8Data[19]     == Length from here in words
            tPCU8 pu8Values  = &pcu8Data[20]; // == Start of values

            ID_ArkamysParameter oArkamysParameter;
            oArkamysParameter.arkamysCommand = ArkamysStaticMessage::ADRToArkamysCommand(*pu8Optype);
            OSAL_pvMemoryCopy(&oArkamysParameter.arkamysAddress, pu8Address, sizeof(tU32));   // copy the address from the array
            OSAL_pvMemoryCopy(&oArkamysParameter.arkamysLength,  pu8Length, sizeof(tU32));   // copy the length from the array
            /*lint --e{826}*/
            /*lint --e{1773}*/
            oArkamysParameter.arkamysValues = (tS32*) (pu8Values);

            ETG_TRACE_USR2(("Deliver@%p: Command=%x Address=%x Length=%x Raw:%x"
                  , &oArkamysParameter
                  , oArkamysParameter.arkamysCommand
                  , oArkamysParameter.arkamysAddress
                  , oArkamysParameter.arkamysLength
                  , ETG_LIST_LEN(sizeof(oArkamysParameter)), ETG_LIST_PTR_T8(&oArkamysParameter)
                  ));
            ETG_TRACE_USR2(("Data@%p: %x", oArkamysParameter.arkamysValues
                  , ETG_LIST_LEN((tU16)(ntohl(oArkamysParameter.arkamysLength) * sizeof(tU32))), ETG_LIST_PTR_T8(oArkamysParameter.arkamysValues) ));

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS_PSA
            ArkamysTuningHandler::getInstance() -> AdrMessageRx(
                 (tU8) oArkamysParameter.arkamysCommand
                  ,oArkamysParameter.arkamysAddress
                  ,oArkamysParameter.arkamysLength
                  ,oArkamysParameter.arkamysValues);
#endif
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS_CLASSIC
            ArkamysTuningHandlerRNAIVI::getInstance() -> AdrMessageRx(
                 (tU8) oArkamysParameter.arkamysCommand
                  ,oArkamysParameter.arkamysAddress
                  ,oArkamysParameter.arkamysLength
                  ,oArkamysParameter.arkamysValues);
#endif
            if (oArkamysParameter.arkamysCommand == ArkamysStaticMessage::ArkamysOpTypeStatus)
            {
                ArkamysFeatInterface::getInstance() -> AdrMessageRx(oArkamysParameter);
            }
         }
       break;
#endif // VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ENGINE_SOUND
//      case VD_ADR3_FKT_ID_ENGINE_SOUND_PARAMETER:
//         break;
      case VD_ADR3_FKT_ID_ENGINE_SOUND_VERSION:
         if (AUD_GET_U16(&pcu8ADRmsg[enAdrMsgOffset_PAYLOAD_LEN]) != ESE_FILE_OVERHEAD_SIZE)
         {
            ETG_TRACE_ERR(("EngineSound: Insufficient response from ADR (need %i bytes, but got %i bytes)", ESE_FILE_OVERHEAD_SIZE, AUD_GET_U16(&pcu8ADRmsg[enAdrMsgOffset_PAYLOAD_LEN])));
         }
         else
         {
               ID_EngineSound_Version oEngineSound_Version;
               oEngineSound_Version.eseFileId   = pcu8ADRmsg[enAdrMsgOffset_PAYLOAD_DATA];
               memcpy(&oEngineSound_Version.eseVersion, &pcu8ADRmsg[enAdrMsgOffset_PAYLOAD_DATA + 1], sizeof(tU32));
               oEngineSound_Version.eseVersion = ntohl(oEngineSound_Version.eseVersion);
               memcpy(&oEngineSound_Version.eseChecksum, &pcu8ADRmsg[enAdrMsgOffset_PAYLOAD_DATA + 5], sizeof(tU32));
               oEngineSound_Version.eseChecksum = ntohl(oEngineSound_Version.eseChecksum);
               ETG_TRACE_USR4(("ADR3: EngineSound response: File-ID:%i Version:%x Checksum:%x (Raw:%02x)"
                     , oEngineSound_Version.eseFileId, oEngineSound_Version.eseVersion, oEngineSound_Version.eseChecksum
                     , ETG_LIST_LEN(AUD_GET_U16(&pcu8ADRmsg[enAdrMsgOffset_PAYLOAD_LEN])), ETG_LIST_PTR_T8(&pcu8ADRmsg[enAdrMsgOffset_PAYLOAD_DATA])));

               InternalCommunicationAdapter::getInstance() -> POMessages -> DeliverMsg(&oEngineSound_Version);
         }
         break;
#endif // VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ENGINE_SOUND

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS_CLASSIC
         //volume, filter, bypass status needed for A-IVI arkamys tuning tool
      case VD_ADR3_FKT_ID_ARKAMYS_MODE:
        vd_adr3Msg_arkamysParameter::vSendADRResponse(&oAdrResponse);
        break;
      case VD_ADR3_FKT_ID_ARKAMYS_LEVEL_DEVIATION:
        ArkamysFeatureHandlerRNAIVI::getInstance()->ArkamysInputLevelDeviation(oAdrResponse.au8MsgData, oAdrResponse.u16MsgLen);
        break;
#endif
#endif

      case VD_ADR3_FKT_ID_SET_FILTER:
        vd_adr3Msg_filter::vSendADRResponse(&oAdrResponse);
        break;
      case VD_ADR3_FKT_ID_VOLUME:
        vd_adr3Msg_volume::vSendADRResponse(&oAdrResponse);
        break;
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ENGINE_SOUND_IVI
      case VD_ADR3_FKT_ID_ENGINE_SOUND_ONOFF:
      case VD_ADR3_FKT_ID_ENGINE_SOUND_VOLUME:
      case VD_ADR3_FKT_ID_ENGINE_SOUND_PARAMETER:
        ESETuningHandlerRNAIVI::getInstance() -> AdrMessageRx(oAdrResponse.u16FktId, oAdrResponse.au8MsgData, (tU32)oAdrResponse.u16MsgLen);
        break;

      case VD_ADR3_FKT_ID_ESE_LIB_VERSION:
      {
        ID_EngineSound_LibVersion oESE_LibVersion;
        memcpy(&oESE_LibVersion.eseLibVersion, &pcu8ADRmsg[enAdrMsgOffset_PAYLOAD_DATA], sizeof(tU32));
        oESE_LibVersion.eseLibVersion = ntohl(oESE_LibVersion.eseLibVersion);
        InternalCommunicationAdapter::getInstance() -> POMessages -> DeliverMsg(&oESE_LibVersion);

        //continue processing of the ESE - ADR queue, since no enADRDataCon will be sent for a get message
        EngineSoundHandlerIVI::getInstance()->vAdrReady((enMsgType)ENGINE_SOUND_LIB_VERSION);
      }
        break;
#endif
      case VD_ADR3_FKT_ID_SDVC_STATE:
        vd_adr3Msg_volume::vSendADRResponseSDVCState(&oAdrResponse);
        break;
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS_CLASSIC
      case VD_ADR3_FKT_ID_ARKAMYS_CONFIG_DATA:
          ArkamysTuningHandlerRNAIVI2::getInstance() -> SbrMessageRx(oAdrResponse.enOpType, oAdrResponse.au8MsgData, oAdrResponse.u16MsgLen);
          break;
#endif
    default:
      ETG_TRACE_USR2(("default case: switch (oAdrResponse.u16FktId == %i)", oAdrResponse.u16FktId));
      break;
    }
  }
  break;
  case TRC::enADRDataCon:
  {
     tU8 u8ThreadMsgType = pcu8ADRmsg[0];
     ETG_TRACE_USR4(("TRC::enADRDataCon received for u8ThreadMsgType %i.", ETG_CENUM(enMsgType, u8ThreadMsgType)));
     switch (u8ThreadMsgType)
     {
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS
     case ARKAMYS_PARAMETER:
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS_CLASSIC
     case ARKAMYS_MODE:
     case ARKAMYS_RESET:
     case SET_FILTER_3:
     ArkamysFeatureHandlerRNAIVI::getInstance() -> vAdrOkCallback();
     ArkamysTuningHandlerRNAIVI ::getInstance() -> vAdrOkCallback();
#endif
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS_PSA
         ArkamysFeatureHandler::getInstance() -> vAdrOkCallback();
         ArkamysTuningHandler ::getInstance() -> vAdrOkCallback();
#endif

         break;
#endif // VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ENGINE_SOUND_PSA
      case ENGINE_SOUND_PARAMETER:
      case ENGINE_SOUND_VERSION:
         if (fc_audiomanager_tclApp::theServer() -> m_poEngineSoundHandler != NULL)
         {
            fc_audiomanager_tclApp::theServer() -> m_poEngineSoundHandler -> vAdrReady((enMsgType)u8ThreadMsgType);
         }
         break;
#endif // VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ENGINE_SOUND_PSA
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ENGINE_SOUND_IVI
      case ENGINE_SOUND_PARAMETER:
      case ENGINE_SOUND_VERSION:
      case ENGINE_SOUND_SET:
      case ENGINE_SOUND_VOLUME:
      //case ENGINE_SOUND_LIB_VERSION:
         EngineSoundHandlerIVI::getInstance()->vAdrReady((enMsgType)u8ThreadMsgType);
         break;
#endif // VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ENGINE_SOUND_IVI
      case DIAG_GET_RESULT:
         {
            fc_audiomanager_tclService_Audio_Function *pServiceAudioFct = fc_audiomanager_tclApp::theServer() -> pGetAudioFunctionptr();
            NORMAL_M_ASSERT(pServiceAudioFct != NULL);
            if (pServiceAudioFct != NULL)
            {
               pServiceAudioFct -> vOnGetDiagResultReady();
            }
            else
            {
               ETG_TRACE_FATAL(("Could not retrieve valid Service_Audio_Function pointer from fc_audiomanager_tclApp."));
            }
         }
         break;
     case CARSETTING:
      {
        vSendMsg(VD_ADR3_INST_ID_LS_1, VD_ADR3_FKT_ID_SDVC_STATE, VD_ADR3_OPTYPE_GET
                 , 0, OSAL_NULL, SDVC_STATE);
      }
      break;
         // if more u8ThreadMsgTypes are needed, remember to add them also inside vDataCon(), so they are forwarded

     default:
        ETG_TRACE_USR4(("u8ThreadMsgType %u not handled.", ETG_CENUM(enMsgType, u8ThreadMsgType)));
        break;
     }
  }
  break;


  default:
    ETG_TRACE_USR2(("default case: switch ( pcu8Data[1] == %i ) // tenTrcFuncInput", pcu8Data[1]));
    break;
  }
}


/********************************************************************************
 * vCheckForNewRequestedMessages()
 * //send demute message after all other messages.
 *******************************************************************************/
void vd_adr3Msg_If::vCheckForNewRequestedMessages(void)
{
  tU32 u32Len;
  tU32 u32MsgID;
  tU8 i;
  tU8 au8AdrPayload[AUD_ADR_MAX_PAYLOAD];
  tBool bRet;
  tBool bSSIBusyState;

  bRet = FALSE;
  trMsgAdrOutput oAdrOutput;
  tU8 *pu8AdrMsg = oAdrOutput.au8AdrMsg;

  if(!vd_adr3_If::bGetAdr3StateRunning())
  {
    ETG_TRACE_USR2(("vCheckForNewRequestedMessages. ADR3 not running."));
    return;
  }

  bSSIBusyState = vd_adr3_If::bGetSsiBusyState();
  if(bSSIBusyState == TRUE){
    // SSI is busy
    ETG_TRACE_USR2(("vCheckForNewRequestedMessages. SSI busy."));
    return;
  }

  for(i=0;i<NUM_OF_MESSAGE_TYPES;i++)
  {
    if(aclMessageBuffer[i].bIsTransferred() == FALSE)
    {
      //read from message buffer
      u32Len = aclMessageBuffer[i].u32ReadValue(au8AdrPayload,AUD_ADR_MAX_PAYLOAD,u32MsgID);  //u32ReadValue(tU8* dest, tU32 destLenMax, tU32& r_u32MessageID)
      ETG_TRACE_USR4(("u32ReadValue() u32Len = %u, u32MsgID = %u, au8AdrPayload[0] = %u", (tU8) u32Len, (tU8) u32MsgID, (tU8) au8AdrPayload[0]))

      //value must be initialized
      if(u32MsgID == 0)
      {
        ETG_TRACE_USR4(("vCheckForNewRequestedMessages. message type %u empty.", static_cast<tU16>(i)));

        //last demute not initialized
        if((i == MUTE_MIX3)&&(ubDemuteWait == DEMUTE))
        {
          ETG_TRACE_USR4(("Last demute last initialized. ubDemuteWait = NO_DEMUTE"));
          i = NUM_OF_MESSAGE_TYPES;
          ubDemuteWait = NO_DEMUTE;
        }
        continue;
      }

      //send demute message after all other messages. Set demuteWait flag
      if((i <= MUTE_MIX3)&&(au8AdrPayload[11]== 0)&&(ubDemuteWait != DEMUTE))
      {
        ETG_TRACE_USR4(("ubDemuteWait = DEMUTE_WAIT"));
        ubDemuteWait = DEMUTE_WAIT;
      }
      else
      {

        oAdrOutput.u32MsgLen = u32Len;
        OSAL_pvMemoryCopy(pu8AdrMsg, au8AdrPayload, u32Len);
        ETG_TRACE_USR2(("vCheckForNewRequestedMessages()\n u32Len =%u,\n pu8AdrMsg=0x%02x",(tU16) u32Len,ETG_LIST_LEN((tU16) u32Len), ETG_LIST_PTR_T8(pu8AdrMsg)));


        if((u8LastSentThreadMessageType == i)&&(u32LastSentMsgID == u32MsgID))
        {
          //do nothing. This message has not changed. Waiting for the confirmation.
        }
        else
        {
          u8LastSentThreadMessageType = i;
          u32LastSentMsgID = u32MsgID;

          //send message to ADR3
          bRet = vd_adr3_If::bSend(&oAdrOutput);
          ETG_TRACE_USR4(("vCheckForNewRequestedMessages(). bRet of bSend()=%u",(tU8) bRet));

          //last demute sent
          if((i == MUTE_MIX3)&&(ubDemuteWait == DEMUTE))
          {
            ETG_TRACE_USR4(("Last demute done. ubDemuteWait = NO_DEMUTE"));
            i = NUM_OF_MESSAGE_TYPES;
            ubDemuteWait = NO_DEMUTE;
          }
          break;
        }
      }
    }

    //last demute checked
    if((i == MUTE_MIX3)&&(ubDemuteWait == DEMUTE))
    {
      ETG_TRACE_USR4(("Last demute checked. ubDemuteWait = NO_DEMUTE"));
      i = NUM_OF_MESSAGE_TYPES;
      ubDemuteWait = NO_DEMUTE;
    }
  }

  //start the loop again from MUTE_EXC to MUTE_MIX3
  if((i == NUM_OF_MESSAGE_TYPES)&&(ubDemuteWait == DEMUTE_WAIT))//lint !e850
  {
    ETG_TRACE_USR4(("ubDemuteWait = DEMUTE"));
    ubDemuteWait = DEMUTE;

    vCheckForNewRequestedMessages();
  }
}


/********************************************************************************
 * vDataCon()
 *******************************************************************************/
void vd_adr3Msg_If::vDataCon(void)
{
  aclMessageBuffer[u8LastSentThreadMessageType].vConfirmTransfer(u32LastSentMsgID);

  ETG_TRACE_USR4(("vDataCon() u32LastSentMsgID=0x%x u8LastSentThreadMessageType=%u"
        , u32LastSentMsgID, ETG_CENUM(enMsgType, u8LastSentThreadMessageType)))

  switch (u8LastSentThreadMessageType)
  {
     case ARKAMYS_PARAMETER:
     case ARKAMYS_MODE:
     case ARKAMYS_RESET:
     case SET_FILTER_3:
     case ENGINE_SOUND_PARAMETER:
     case ENGINE_SOUND_VERSION:
      case ENGINE_SOUND_SET:
      case ENGINE_SOUND_VOLUME:
     case DIAG_GET_RESULT:
     case CARSETTING:
        {
           // Send ADR Ready notification to main thread
           tU8 u8ConMsg[] = {TRC::enAdr3MsgIf, TRC::enADRDataCon, u8LastSentThreadMessageType, 0 /* for future use */};
           fc_audiomanager_tclApp::vRxFromOtherThreads(sizeof(u8ConMsg), u8ConMsg);
        }
        break;

     default:
        break;
  }
}

/********************************************************************************
 * vReloadADRData()
 *******************************************************************************/
void vd_adr3Msg_If::vReloadADRData()
{
  tU8 i;

  ETG_TRACE_USR4(("vReloadADRData entered. "));

  //set transferred flag to FALSE after low power or ADR reset, if data available
  for(i = 0; i < NUM_OF_RELOAD_MESSAGES_AFTER_RESET; i++){
    aclMessageBuffer[au8MsgTypeTransferAfterReset[i]].vResetTransferredFlag();

  }

  //messages are sent after startup message from ADR in vd_adr3Msg_If::vTraceRx()
}



/********************************************************************************
 * void vd_adr3Msg_If::vResendVolume()
 *******************************************************************************/
void vd_adr3Msg_If::vResendVolume()
{
  ETG_TRACE_USR4(("vResendVolume entered. "));
  aclMessageBuffer[VOLUME_EXC].vResetTransferredFlag();
  vd_adr3_main::vSendAdr3WorkerThreadEvent((tU32) EVENT_VD_ADR3_CHECK_NEXT_MESSAGE);
}

