
#ifndef _semaphore_protection_
#define _semaphore_protection_
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

class semaphore_protection
{
public:

  /********************************************************************
   *FUNCTION:     semaphore_protection - constructor
   *DESCRIPTION:  allocate semaphore in constructor
   *PARAMETER:      handle to a semphore
   *RETURNVALUE:  -
   *******************************************************************/
  semaphore_protection(OSAL_tSemHandle hSem):_hSem(hSem)
  {
    NORMAL_M_ASSERT(_hSem != OSAL_C_INVALID_HANDLE);
    tS32 s32RetVal = OSAL_OK ;
    do
    {
      s32RetVal = OSAL_s32SemaphoreWait( _hSem, 20000 );
      NORMAL_M_ASSERT(s32RetVal == OSAL_OK); //semaphore blocked longer than 20s
    }
    while(s32RetVal != OSAL_OK);
  }

  /********************************************************************
   *FUNCTION:     semaphore_protection - destructor
   *DESCRIPTION:  automatically release semaphore when leaving protected section
   *PARAMETER:      -
   *RETURNVALUE:  -
   *******************************************************************/

  virtual ~semaphore_protection()
  {
    tS32 s32RetVal = OSAL_s32SemaphorePost(_hSem);
    NORMAL_M_ASSERT(s32RetVal == OSAL_OK); //unable to post semaphore
  }

protected:

  //default constructor is hidden because to maust not be used
  semaphore_protection():_hSem((OSAL_tSemHandle)OSAL_ERROR){};

  OSAL_tSemHandle _hSem;
};


#endif //_semaphore_protection_

//EOF

