#ifndef VD_ADR3MESSAGE_DATA_H
#define VD_ADR3MESSAGE_DATA_H

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#include "system_types.h"

#include "vd_adr3Message_SemaphoreProtect.h"



class vd_adr3Message_Data
{

public:
  vd_adr3Message_Data();

  ~vd_adr3Message_Data();

  tBool bCheckValueChange(tU8* data, tU32 len)const;
  tBool bSetValue(tU8* data, tU32 len);
  tU32 u32ReadValue(tU8* dest, tU32 destLenMax, tU32& r_u32MessageID);
  void vConfirmTransfer(tU32 u32MessageID);
  void vResetTransferredFlag();
  void vSetCheckValueChange(tBool bEnable);
  tBool bIsTransferred(void)const;


protected:

  //return semaphore handle for data protection
  OSAL_tSemHandle getSemaphore();
  void deleteSemaphore();


private:
  OSAL_tSemHandle hSem;

  tU8* _pu8ValueData; //data to be transferred to ADR3
  tU32 _u32ValueSize; // Size of this data

  tBool _bTransferred;//transfer state
  tU32 _u32MessageID; //message id
  tBool _bCheckValueChangeAllowed; //data will only be send when the message value has changed.

  static const tU32 cu32SemNameLen = 36;
  char pcu8SemName[cu32SemNameLen];//semaphore name

};

enum enMsgType{
  MUTE_EXC,
  MUTE_EXC_SINK2,
  MUTE_EXC_SINK17,
  MUTE_MIX1,
  MUTE_MIX2,
  MUTE_MIX3,
  MUTE_CHANNEL,
  NOTIFICATION,
  POWERSTATE,
  MAINTENANCEMODE,
  SOURCE_EXC,
  SOURCE_MIX1,
  SOURCE_MIX2,
  SOURCE_MIX3,
  SEQUENCECONTROL,
  ROUTE_EXC,
  ROUTE_MIX1,
  ROUTE_MIX2,
  ROUTE_MIX3,
  VOLUME_OFFSET_EXC,
  VOLUME_OFFSET_MIX1,
  VOLUME_OFFSET_MIX2,
  VOLUME_OFFSET_MIX3,
  CLIPPING,
  SETTINGS_BASS,
  SETTINGS_TREBLE,
  SETTINGS_BALANCE,
  SETTINGS_FADER,
  SETTINGS_SDVC,
  SETTINGS_MID,
  SETTINGS_LOUDNESS,
  SETTINGS_DYNAMIC_COMPRESSION,
  SETTINGS_EQUPRESET,
  SETTINGS_OPTIMIZATION,
  SET_FILTER_1,
  SET_FILTER_2,
  SET_FILTER_3,
  GET_FILTER_1,
  GET_FILTER_2,
  GET_FILTER_3,
  SIGNALTONE,
  SIGNALTONEPARAMETERS_TRIANGLEGEN,
  SIGNALTONEPARAMETERS_SINUSOIDALGEN,
  SIGNALCHIMEPARAMETERS,
  DIAG_GET_RESULT,
  DIAG_SET_SPEAKER,
  DIAG_GET_SPEAKER,
  DIAG_SET_TURNONSTATUS,
  SOUNDCONFIG_SET_BASS,
  SOUNDCONFIG_SET_SD_BASS,
  SOUNDCONFIG_SET_TREBLE,
  SOUNDCONFIG_SET_SD_TREBLE,
  SOUNDCONFIG_SET_LOUDNESS,
  SOUNDCONFIG_SET_BALANCE,
  SOUNDCONFIG_SET_FADER,
  SOUNDCONFIG_SET_CAREQU,
  SOUNDCONFIG_SET_SOURCEOFFSET,
  SOUNDCONFIG_SET_LOUDNESSHIGH,
  SOUNDCONFIG_SET_DELAY,
  SOUNDCONFIG_SET_SDVC,
  SOUNDCONFIG_SET_SDDC,
  SOUNDCONFIG_SET_MIDRANGE,
  SOUNDCONFIG_SET_SOURCEOFFSETIN,
  SOUNDCONFIG_SET_SOURCEOFFSETOUT,
  SOUNDCONFIG_SET_PREMIX,
  SOUNDCONFIG_SET_SDVC_FILTER,
  SOUNDCONFIG_SET_OUTPUTPHASE,
//  SOUNDCONFIG_RESTORE_BASS,
//  SOUNDCONFIG_RESTORE_TREBLE,
//  SOUNDCONFIG_RESTORE_LOUDNESS,
//  SOUNDCONFIG_RESTORE_BALANCE,
//  SOUNDCONFIG_RESTORE_FADER,
//  SOUNDCONFIG_RESTORE_CAREQU,
//  SOUNDCONFIG_RESTORE_SOURCEOFFSET,
//  SOUNDCONFIG_RESTORE_DELAY,
//  SOUNDCONFIG_RESTORE_SDVC,
//  SOUNDCONFIG_RESTORE_BEEP,
  SOUNDCONFIG_SAVE_BASS,
  SOUNDCONFIG_SAVE_SD_BASS,
  SOUNDCONFIG_SAVE_TREBLE,
  SOUNDCONFIG_SAVE_SD_TREBLE,
  SOUNDCONFIG_SAVE_LOUDNESS,
  SOUNDCONFIG_SAVE_BALANCE,
  SOUNDCONFIG_SAVE_FADER,
  SOUNDCONFIG_SAVE_CAREQU,
  SOUNDCONFIG_SAVE_SOURCEOFFSET,
  SOUNDCONFIG_SAVE_LOUDNESSHIGH,
  SOUNDCONFIG_SAVE_DELAY,
  SOUNDCONFIG_SAVE_SDVC,
  SOUNDCONFIG_SAVE_SDDC,
  SOUNDCONFIG_SAVE_MIDRANGE,
  SOUNDCONFIG_SAVE_SOURCEOFFSETIN,
  SOUNDCONFIG_SAVE_SOURCEOFFSETOUT,
  SOUNDCONFIG_SAVE_PREMIX,
   SOUNDCONFIG_SAVE_SDVC_FILTER,
  SOUNDCONFIG_SAVE_OUTPUTPHASE,
//  SOUNDCONFIG_DELETE_BASS,
//  SOUNDCONFIG_DELETE_TREBLE,
//  SOUNDCONFIG_DELETE_LOUDNESS,
//  SOUNDCONFIG_DELETE_BALANCE,
//  SOUNDCONFIG_DELETE_FADER,
//  SOUNDCONFIG_DELETE_CAREQU,
//  SOUNDCONFIG_DELETE_SOURCEOFFSET,
//  SOUNDCONFIG_DELETE_DELAY,
//  SOUNDCONFIG_DELETE_SDVC,
//  SOUNDCONFIG_DELETE_BEEP,
  SOUNDCONFIG_VERSION_BASS,
  SOUNDCONFIG_VERSION_SD_BASS,
  SOUNDCONFIG_VERSION_TREBLE,
  SOUNDCONFIG_VERSION_SD_TREBLE,
  SOUNDCONFIG_VERSION_LOUDNESS,
  SOUNDCONFIG_VERSION_BALANCE,
  SOUNDCONFIG_VERSION_FADER,
  SOUNDCONFIG_VERSION_CAREQU,
  SOUNDCONFIG_VERSION_SOURCEOFFSET,
  SOUNDCONFIG_VERSION_LOUDNESSHIGH,
  SOUNDCONFIG_VERSION_DELAY,
  SOUNDCONFIG_VERSION_SDVC,
  SOUNDCONFIG_VERSION_SDDC,
  SOUNDCONFIG_VERSION_SOURCEOFFSETIN,
  SOUNDCONFIG_VERSION_SOURCEOFFSETOUT,
  SOUNDCONFIG_VERSION_MIDRANGE,
  SOUNDCONFIG_VERSION_PREMIX,
   SOUNDCONFIG_VERSION_SDVC_FILTER,
  SOUNDCONFIG_VERSION_OUTPUTPHASE,
  SOUNDCONFIG_ITEM,       //REGION and SOUNDSYSTEM
  SOUNDCONFIG_ITEM_VEHICLE,
  CARSETTING,
  PING,
  VOLUME_EXC,
  VOLUME_EXC_SINK2,
  VOLUME_EXC_SINK17,
  VOLUME_MIX1,
  VOLUME_MIX2,
  VOLUME_MIX3,
  TTFIS_INPUT_MESSAGE,
  ARKAMYS_PARAMETER,
  ENGINE_SOUND_PARAMETER,
  ENGINE_SOUND_VERSION,
  ENGINE_SOUND_SET,
  ENGINE_SOUND_VOLUME,
  ARKAMYS_MODE,
  ARKAMYS_RESET,
  ARKAMYS_LEVEL_LOSS,
  ENGINE_SOUND_LIB_VERSION,
  AMPLIFIERDEVICE_ID,
  ANC_ONOFF,
  ANC_VOLUME,
  SDVC_STATE,
  VOLUME_EXC_GET,
  ARKAMYS_CONFIG_DATA,
  NUM_OF_MESSAGE_TYPES
};

static const tU8 au8MsgTypeTransferAfterReset[]= {
    NOTIFICATION,
    POWERSTATE,
    MAINTENANCEMODE,
    SOURCE_EXC,
    SOURCE_MIX1,
    SOURCE_MIX2,
    SOURCE_MIX3,
    SEQUENCECONTROL,
    ROUTE_EXC,
    ROUTE_MIX1,
    ROUTE_MIX2,
    ROUTE_MIX3,
    VOLUME_EXC,
    VOLUME_MIX1,
    VOLUME_MIX2,
    VOLUME_MIX3,
    VOLUME_OFFSET_EXC,
    VOLUME_OFFSET_MIX1,
    VOLUME_OFFSET_MIX2,
    VOLUME_OFFSET_MIX3,
    SETTINGS_BASS,
    SETTINGS_TREBLE,
    SETTINGS_MID,
    SETTINGS_LOUDNESS,
    SETTINGS_DYNAMIC_COMPRESSION,
    SETTINGS_EQUPRESET,
    SETTINGS_OPTIMIZATION,
    SETTINGS_BALANCE,
    SETTINGS_FADER,
    SETTINGS_SDVC,
    SET_FILTER_1,
    SET_FILTER_2,
    SET_FILTER_3,
    MUTE_EXC,
    MUTE_MIX1,
    MUTE_MIX2,
    MUTE_MIX3,
    SIGNALTONEPARAMETERS_TRIANGLEGEN,
    SIGNALTONEPARAMETERS_SINUSOIDALGEN,
    SOUNDCONFIG_ITEM,
    SOUNDCONFIG_ITEM_VEHICLE,
    CARSETTING,
    ARKAMYS_MODE,
    AMPLIFIERDEVICE_ID,
    ANC_ONOFF,
    ANC_VOLUME
};

static const tU8 au8MsgTypeDisableCheckValueChange[] = {
      MUTE_EXC,   //response required
      MUTE_MIX1,
      MUTE_MIX2,
      MUTE_MIX3,
      SIGNALTONE,
      SIGNALTONEPARAMETERS_TRIANGLEGEN,
        SIGNALTONEPARAMETERS_SINUSOIDALGEN,
      SIGNALCHIMEPARAMETERS,
      DIAG_GET_RESULT,
      DIAG_SET_SPEAKER,
//      SOUNDCONFIG_RESTORE_BASS,
//      SOUNDCONFIG_RESTORE_TREBLE,
//      SOUNDCONFIG_RESTORE_LOUDNESS,
//      SOUNDCONFIG_RESTORE_BALANCE,
//      SOUNDCONFIG_RESTORE_FADER,
//      SOUNDCONFIG_RESTORE_CAREQU,
//      SOUNDCONFIG_RESTORE_SOURCEOFFSET,
//      SOUNDCONFIG_RESTORE_DELAY,
//      SOUNDCONFIG_RESTORE_SDVC,
//      SOUNDCONFIG_RESTORE_BEEP,
      SOUNDCONFIG_SAVE_BASS,
      SOUNDCONFIG_SAVE_SD_BASS,
      SOUNDCONFIG_SAVE_TREBLE,
      SOUNDCONFIG_SAVE_SD_TREBLE,
      SOUNDCONFIG_SAVE_LOUDNESS,
      SOUNDCONFIG_SAVE_BALANCE,
      SOUNDCONFIG_SAVE_FADER,
      SOUNDCONFIG_SAVE_CAREQU,
      SOUNDCONFIG_SAVE_SOURCEOFFSET,
      SOUNDCONFIG_SAVE_LOUDNESSHIGH,
      SOUNDCONFIG_SAVE_DELAY,
      SOUNDCONFIG_SAVE_SDVC,
      SOUNDCONFIG_SAVE_SDDC,
      SOUNDCONFIG_SAVE_MIDRANGE,
      SOUNDCONFIG_SAVE_SOURCEOFFSETIN,
      SOUNDCONFIG_SAVE_SOURCEOFFSETOUT,
      SOUNDCONFIG_SAVE_PREMIX,
      SOUNDCONFIG_SAVE_SDVC_FILTER,
      SOUNDCONFIG_SAVE_OUTPUTPHASE,
//      SOUNDCONFIG_DELETE_BASS,
//      SOUNDCONFIG_DELETE_TREBLE,
//      SOUNDCONFIG_DELETE_LOUDNESS,
//      SOUNDCONFIG_DELETE_BALANCE,
//      SOUNDCONFIG_DELETE_FADER,
//      SOUNDCONFIG_DELETE_CAREQU,
//      SOUNDCONFIG_DELETE_SOURCEOFFSET,
//      SOUNDCONFIG_DELETE_DELAY,
//      SOUNDCONFIG_DELETE_SDVC,
//      SOUNDCONFIG_DELETE_BEEP,
      SOUNDCONFIG_VERSION_BASS,
      SOUNDCONFIG_VERSION_SD_BASS,
      SOUNDCONFIG_VERSION_TREBLE,
      SOUNDCONFIG_VERSION_SD_TREBLE,
      SOUNDCONFIG_VERSION_LOUDNESS,
      SOUNDCONFIG_VERSION_BALANCE,
      SOUNDCONFIG_VERSION_FADER,
      SOUNDCONFIG_VERSION_CAREQU,
      SOUNDCONFIG_VERSION_SOURCEOFFSET,
      SOUNDCONFIG_VERSION_LOUDNESSHIGH,
      SOUNDCONFIG_VERSION_DELAY,
      SOUNDCONFIG_VERSION_SDVC,
      SOUNDCONFIG_VERSION_SDDC,
      SOUNDCONFIG_VERSION_SOURCEOFFSETIN,
      SOUNDCONFIG_VERSION_SOURCEOFFSETOUT,
      SOUNDCONFIG_VERSION_MIDRANGE,
      SOUNDCONFIG_VERSION_PREMIX,
      SOUNDCONFIG_VERSION_SDVC_FILTER,
      SOUNDCONFIG_VERSION_OUTPUTPHASE,
      PING,
    VOLUME_EXC_GET,
//    VOLUME_EXC,
      TTFIS_INPUT_MESSAGE,
      ARKAMYS_PARAMETER,
      ROUTE_MIX3,
      SOURCE_MIX3,
      ARKAMYS_RESET,
      SET_FILTER_1,
      SET_FILTER_2,
      SET_FILTER_3,
      ARKAMYS_MODE,
      GET_FILTER_1,
      GET_FILTER_2,
      GET_FILTER_3,
      VOLUME_MIX3,//PSARCCB-10542
      VOLUME_OFFSET_MIX3,//PSARCCB-10542
         ENGINE_SOUND_PARAMETER,
         ENGINE_SOUND_VERSION,
         ENGINE_SOUND_SET,
         ENGINE_SOUND_VOLUME,
     ENGINE_SOUND_LIB_VERSION,
   SDVC_STATE,
   ARKAMYS_CONFIG_DATA
};



#endif //VD_ADR3MESSAGE_DATA_H


















