/*******************************************************************************
 *
 * FILE:          aud_sinkmgr_timer.cpp
 *
 * AUTHOR:      Klotz
 *
 * COPYRIGHT:    (c) 2013 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

#include "aud_sinkmgr_timer.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
//#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "../fc_audiomanager_trace.h"
#include "../fc_audiomanager_main.h"
#include "../fc_audiomanager_trace_macros.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_AUD_SINKMGR_APPLICATION
#include "trcGenProj/Header/aud_sinkmgr_timer.cpp.trc.h"
#endif


/******************************************************************************/
/* DEFINES                                                                    */
/******************************************************************************/


/******************************************************************************/
/* GLOBAL VARIABLES                                                           */
/******************************************************************************/
// Static self reference to be used in function callbacks.

aud_sinkmgr_timer*   aud_sinkmgr_timer::m_poAud_sinkmgr_timer   = NULL;

OSAL_tTimerHandle  m_hDemuteTimer;
OSAL_tTimerHandle  m_hBoosterOffTimer;
OSAL_tTimerHandle  m_hADR3StandbyTimer;
OSAL_tTimerHandle  m_hBoosterOnTimer;

tBool bBoosterOnTimerRunning;
tBool bDemuteTimerRunning;

/******************************************************************************/
/* METHODS                                                                    */
/******************************************************************************/


/*******************************************************************************
 *
 * FUNCTION: fc_audioroutemgr_tclApp::fc_audioroutemgr_tclApp()
 *
 * DESCRIPTION: Constructor.
 *
 *              Initialize static self reference to be used in function
 *              callbacks.
 *******************************************************************************/
//aud_sinkmgr_timer::aud_sinkmgr_timer(fc_audiomanager_tclApp* poMainAppl)
aud_sinkmgr_timer::aud_sinkmgr_timer()
{
  ETG_TRACE_USR4(("aud_sinkmgr_timer() entered."));
  m_poAud_sinkmgr_timer = this;

  m_hDemuteTimer       = OSAL_C_INVALID_HANDLE;
  m_hBoosterOffTimer   = OSAL_C_INVALID_HANDLE;
  m_hADR3StandbyTimer  = OSAL_C_INVALID_HANDLE;
  m_hBoosterOnTimer    = OSAL_C_INVALID_HANDLE;

  bBoosterOnTimerRunning = FALSE;
  bDemuteTimerRunning    = FALSE;

}

/*******************************************************************************
 * FUNCTION: aud_sinkmgr_timer::~aud_sinkmgr_timer()
 *
 * DESCRIPTION: Destructor.
 *******************************************************************************/
aud_sinkmgr_timer::~aud_sinkmgr_timer()
{
  ETG_TRACE_USR4(("~aud_sinkmgr_timer() entered."));

  if( m_hDemuteTimer != OSAL_C_INVALID_HANDLE)
  {
    tS32 s32OsalError = OSAL_s32TimerDelete( m_hDemuteTimer);

    NORMAL_M_ASSERT( s32OsalError == OSAL_OK);

    m_hDemuteTimer = OSAL_C_INVALID_HANDLE;
  }
  if( m_hBoosterOffTimer != OSAL_C_INVALID_HANDLE)
  {
    tS32 s32OsalError = OSAL_s32TimerDelete( m_hBoosterOffTimer);

    NORMAL_M_ASSERT( s32OsalError == OSAL_OK);

    m_hBoosterOffTimer = OSAL_C_INVALID_HANDLE;
  }
  if( m_hADR3StandbyTimer != OSAL_C_INVALID_HANDLE)
  {
    tS32 s32OsalError = OSAL_s32TimerDelete( m_hADR3StandbyTimer);

    NORMAL_M_ASSERT( s32OsalError == OSAL_OK);

    m_hADR3StandbyTimer = OSAL_C_INVALID_HANDLE;
  }
  if( m_hBoosterOnTimer != OSAL_C_INVALID_HANDLE)
  {
    tS32 s32OsalError = OSAL_s32TimerDelete( m_hBoosterOnTimer);

    NORMAL_M_ASSERT( s32OsalError == OSAL_OK);

    m_hBoosterOnTimer = OSAL_C_INVALID_HANDLE;
  }

  bBoosterOnTimerRunning = FALSE;
  bDemuteTimerRunning    = FALSE;

}

/********************************************************************************
 * vInit().
 *******************************************************************************/
tVoid aud_sinkmgr_timer::vInit(tVoid){
  ETG_TRACE_USR4(("aud_sinkmgr_timer::vInit() entered."));
  /* create ADR supervision timer */
  tS32 s32OsalError = OSAL_s32TimerCreate( (OSAL_tpfCallback)vDemuteTimerCallback,
      0, &m_hDemuteTimer );
  ETG_TRACE_USR1((" createTimer  0x%x", s32OsalError));
  s32OsalError = OSAL_s32TimerCreate( (OSAL_tpfCallback)vBoosterOffTimerCallback,
      0, &m_hBoosterOffTimer );
  ETG_TRACE_USR1((" createTimer  0x%x", s32OsalError));
  s32OsalError = OSAL_s32TimerCreate( (OSAL_tpfCallback)vADR3StandbyTimerCallback,
      0, &m_hADR3StandbyTimer );
  ETG_TRACE_USR1((" createTimer  0x%x", s32OsalError));
  s32OsalError = OSAL_s32TimerCreate( (OSAL_tpfCallback)vWaitToSwitchOnExtBoosterTimerCallback,
      0, &m_hBoosterOnTimer );
  ETG_TRACE_USR1((" createTimer  0x%x", s32OsalError));
}

/********************************************************************************
 * vStartTimer().
 *******************************************************************************/
tVoid aud_sinkmgr_timer::vStartTimer(tU16 uwTimerID, tU16 uwTimeMs)
{
  tS32 s32RetVal;
  ETG_TRACE_USR4((" vStartTimer uwTimerID = 0x%x, uwTimeMs = %u ", uwTimerID, uwTimeMs));

  switch(uwTimerID)
  {
  case AUD_SINKMANAGER_TIMER_ID_DEMUTE:
    s32RetVal = OSAL_s32TimerSetTime( m_hDemuteTimer, (tU32) uwTimeMs, 0 );
    ETG_TRACE_USR4((" vStartDemuteTimer s32RetVal = 0x%x", s32RetVal));
    bDemuteTimerRunning = TRUE;
    break;
  case AUD_SINKMANAGER_TIMER_ID_BOOSTER_OFF:
    s32RetVal = OSAL_s32TimerSetTime( m_hBoosterOffTimer, (tU32) uwTimeMs, 0 );
    ETG_TRACE_USR4((" vStartBoosterOffTimer s32RetVal = 0x%x", s32RetVal));
    break;
  case AUD_SINKMANAGER_TIMER_ID_ADR3_STANDBY:
    s32RetVal = OSAL_s32TimerSetTime( m_hADR3StandbyTimer, (tU32) uwTimeMs, 0 );
    ETG_TRACE_USR4((" vStartAdr3StandbyTimer s32RetVal = 0x%x", s32RetVal));
    break;
  case AUD_SINKMANAGER_TIMER_ID_WAIT_TO_SWITCH_ON_EXT_BOOSTER:
    s32RetVal = OSAL_s32TimerSetTime( m_hBoosterOnTimer, (tU32) uwTimeMs, 0 );
    ETG_TRACE_USR4((" vStartBoosterOnTimer s32RetVal = 0x%x", s32RetVal));
    bBoosterOnTimerRunning = TRUE;
    break;
  default:
    ETG_TRACE_USR4((" vStartTimer unknown uwTimerID = 0x%x", uwTimerID));
    break;

  }
}

/********************************************************************************
 * vStopTimer().
 *******************************************************************************/
tVoid aud_sinkmgr_timer::vStopTimer(tU16 uwTimerID)
{
  tU32 s32RetVal;

  switch(uwTimerID)
  {
  case AUD_SINKMANAGER_TIMER_ID_DEMUTE:
    s32RetVal = OSAL_s32TimerSetTime(m_hDemuteTimer, 0, 0);
    ETG_TRACE_USR4((" vStopDemuteTimer s32RetVal = 0x%x", s32RetVal));
    bDemuteTimerRunning = FALSE;
    break;
  case AUD_SINKMANAGER_TIMER_ID_BOOSTER_OFF:
    s32RetVal = OSAL_s32TimerSetTime( m_hBoosterOffTimer, 0, 0);
    ETG_TRACE_USR4((" vStopBoosterOffTimer s32RetVal = 0x%x", s32RetVal));
    break;
  case AUD_SINKMANAGER_TIMER_ID_ADR3_STANDBY:
    s32RetVal = OSAL_s32TimerSetTime( m_hADR3StandbyTimer, 0, 0 );
    ETG_TRACE_USR4((" vStopAdr3StandbyTimer s32RetVal = 0x%x", s32RetVal));
    break;
  case AUD_SINKMANAGER_TIMER_ID_WAIT_TO_SWITCH_ON_EXT_BOOSTER:
    s32RetVal = OSAL_s32TimerSetTime( m_hBoosterOnTimer, 0, 0 );
    ETG_TRACE_USR4((" vStopBoosterOnTimer s32RetVal = 0x%x", s32RetVal));
    bBoosterOnTimerRunning = FALSE;
    break;
  default:
    ETG_TRACE_USR4((" vStopTimer unknown uwTimerID = 0x%x", uwTimerID));
    break;

  }
}



/********************************************************************************
 * vDemuteTimerCallback( )
 *******************************************************************************/
tVoid aud_sinkmgr_timer::vDemuteTimerCallback(tVoid* pArg){
  (tVoid)pArg;    /* unused parameter */
  bDemuteTimerRunning = FALSE;
  fc_audiomanager_tclApp::vEventFromOtherThreads(FC_AUDIOMANAGER_EVENT_ID_SINK_DEMUTE);
}

/********************************************************************************
 * vBoosterOffTimerCallback( )
 *******************************************************************************/
tVoid aud_sinkmgr_timer::vBoosterOffTimerCallback(tVoid* pArg){
  (tVoid)pArg;    /* unused parameter */
  fc_audiomanager_tclApp::vEventFromOtherThreads(FC_AUDIOMANAGER_EVENT_ID_SINK_BOOSTER_OFF);
}

/********************************************************************************
 * vADR3StandbyTimerCallback( )
 *******************************************************************************/
tVoid aud_sinkmgr_timer::vADR3StandbyTimerCallback(tVoid* pArg){
  (tVoid)pArg;    /* unused parameter */
  fc_audiomanager_tclApp::vEventFromOtherThreads(FC_AUDIOMANAGER_EVENT_ID_SINK_ADR3_STANDBY);
}

/********************************************************************************
 * vWaitToSwitchOnExtBoosterTimerCallback( )
 *******************************************************************************/
tVoid aud_sinkmgr_timer::vWaitToSwitchOnExtBoosterTimerCallback(tVoid* /*pArg*/)
{
  bBoosterOnTimerRunning = FALSE;
  fc_audiomanager_tclApp::vEventFromOtherThreads(FC_AUDIOMANAGER_EVENT_ID_SINK_BOOSTER_ON);
}

/********************************************************************************
 * bGetBoosterOnTimerRunning( )
 *******************************************************************************/
tBool aud_sinkmgr_timer::bGetBoosterOnTimerRunning(tVoid)
{
  ETG_TRACE_USR4(("bGetBoosterOnTimerRunning() bBoosterOnTimerRunning = %u.",bBoosterOnTimerRunning));

  return bBoosterOnTimerRunning;
}

/********************************************************************************
 * bGetDemuteTimerRunning( )
 *******************************************************************************/
tBool aud_sinkmgr_timer::bGetDemuteTimerRunning(tVoid)
{
  ETG_TRACE_USR4(("bGetDemuteTimerRunning() bDemuteTimerRunning = %u.",bDemuteTimerRunning));

  return bDemuteTimerRunning;
}

