/*******************************************************************************
 *
 * FILE:          aud_sinkmgr_pwramp.cpp
 * AUTHOR:
 * COPYRIGHT:    (c) 2013 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
//#define ET_TRACE_INFO_ON
#include <etrace_if.h>

#include "aud_sinkmgr_pwramp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_AUD_SINKMGR_APPLICATION
#include "trcGenProj/Header/aud_sinkmgr_pwramp_G3G.cpp.trc.h"
#endif

/******************************************************************************/
/* FACTORY FUNCTION                                                           */
/******************************************************************************/

/* static */ aud_sinkmgr_pwramp* aud_sinkmgr_pwramp:: pCreateInstance (fc_audiomanager_tclApp* poMainAppl, StreamMute_IF* m_pStreamMute)
{
 #ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
    return new aud_sinkmgr_pwramp_AIVI(poMainAppl, m_pStreamMute);
  #elif VARIANT_S_FTR_ENABLE_FEAT_AUDIO_PSA_LINUX
     return new aud_sinkmgr_pwramp_PSA(poMainAppl, m_pStreamMute);
    #else
      return new aud_sinkmgr_pwramp_g3g(poMainAppl, m_pStreamMute);
 #endif
}

/******************************************************************************/
/* GLOBAL VARIABLES                                                           */
/******************************************************************************/
static tU8 aud_ubSinkState;
static tU8 aud_ubExtBooster;
static tU8 u8LowPowerActive;
static tU8 u8HighPowerActive;

/******************************************************************************/
/* METHODS                                                                    */
/******************************************************************************/

/*******************************************************************************
 *  Constructor.
 *******************************************************************************/
aud_sinkmgr_pwramp_g3g::aud_sinkmgr_pwramp_g3g(fc_audiomanager_tclApp* poMainAppl, StreamMute_IF* pStreamMute)
   : IF_MessageObserver<PO_MessageConfig::enID>("aud_sinkmgr_pwramp_g3g")
   , muteRegId(0)
   , m_pStreamMute(pStreamMute)
   , m_poMainAppl(poMainAppl)
   , m_enAudioState(EN_AUDIO_STATE_OFF)
{
  ETG_TRACE_USR4(("aud_sinkmgr_pwramp() entered."));

  if(NULL == pStreamMute)
  {
    FATAL_M_ASSERT_ALWAYS();
  }
  else
  {
    muteRegId = m_pStreamMute->registerForStreamMute(StreamMute_IF::INTERNAL_BEH, this);
  }

  pPO = InternalCommunicationAdapter::getInstance();
  vAddObserver();
}


/*******************************************************************************
 *  Destructor.
 *******************************************************************************/
aud_sinkmgr_pwramp_g3g::~aud_sinkmgr_pwramp_g3g()
{
  ETG_TRACE_USR4(("~aud_sinkmgr_pwramp() entered."))
  pPO->POMessages->DeRegisterObserver(this);
  m_poMainAppl  = NULL;
  m_pStreamMute = NULL;
  pPO = NULL;
}

/********************************************************************************
 * vInit().
 *******************************************************************************/
tVoid aud_sinkmgr_pwramp_g3g::vInit()
{
  ETG_TRACE_USR4(("aud_sinkmgr_pwramp_g3g vInit() entered."));

  aud_ubSinkState    = AUD_SINK_STATE_OFF;
  aud_ubExtBooster   = SOUND_CONFIG_ITEM_VALUE_UNDEF;
  u8LowPowerActive   = 0;
  u8HighPowerActive   = 0;

}

/********************************************************************************
 * vAddObserver()
 *******************************************************************************/
void aud_sinkmgr_pwramp_g3g::vAddObserver()
{

  ETG_TRACE_USR4(("aud_sinkmgr_pwramp_g3g::vAddObserver"));

  if(pPO != NULL)
  {
    ETG_TRACE_USR4(("aud_sinkmgr_pwramp_g3g::vAddObserver  pPO != NULL"));
    pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_AudioState);
  }
  else
  {
    FATAL_M_ASSERT_ALWAYS();
  }
}

/********************************************************************************
 * MessageNotification()
 *******************************************************************************/
void aud_sinkmgr_pwramp_g3g::MessageNotification(PO_MessageConfig::enID MsgId)
{
  ETG_TRACE_USR4(("aud_sinkmgr_pwramp_g3g::MessageNotification entered. "));

  switch(MsgId)
  {
  case PO_MessageConfig::ID_AudioState:
    {
      const ID_AudioState* pMsg = pPO->POMessages->QueryMessage<ID_AudioState>(MsgId);
      AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pMsg);
      ETG_TRACE_USR4(("AudioState status: 0x%4x.", pMsg->AudioState));
      m_enAudioState = pMsg->AudioState;
      vCheckPwrAmp();
      break;
    }
    default :
      break;
  }
}

/********************************************************************************
 * vMuteSink
 *******************************************************************************/
tVoid aud_sinkmgr_pwramp_g3g::vMuteSink(tVoid)
{
  ETG_TRACE_USR4(("vMuteSink() entered with muteRegId = %u.", muteRegId))
  StreamMute_IF::tenStreamMuteaction action = StreamMute_IF::MUTE_ACTION_MUTE;
  m_pStreamMute->muteStream(muteRegId, action , EN_AUDIO_FADING_RES_BOOSTER,EN_AUDIO_SOURCE_STREAM_MAIN);
  m_pStreamMute->muteStream(muteRegId, action , EN_AUDIO_FADING_RES_BOOSTER,EN_AUDIO_SOURCE_STREAM_MIX1);
  m_pStreamMute->muteStream(muteRegId, action , EN_AUDIO_FADING_RES_BOOSTER,EN_AUDIO_SOURCE_STREAM_MIX2);
  m_pStreamMute->muteStream(muteRegId, action , EN_AUDIO_FADING_RES_BOOSTER,EN_AUDIO_SOURCE_STREAM_MIX3);
}

/********************************************************************************
 * vDemuteSink
 *******************************************************************************/
tVoid aud_sinkmgr_pwramp_g3g::vDemuteSink(tVoid)
{
  ETG_TRACE_USR4(("vDemuteSink() entered with muteRegId = %u.", muteRegId))
  StreamMute_IF::tenStreamMuteaction action = StreamMute_IF::MUTE_ACTION_DEMUTE;
  m_pStreamMute->muteStream(muteRegId, action , EN_AUDIO_FADING_RES_BOOSTER,EN_AUDIO_SOURCE_STREAM_MAIN);
  m_pStreamMute->muteStream(muteRegId, action , EN_AUDIO_FADING_RES_BOOSTER,EN_AUDIO_SOURCE_STREAM_MIX1);
  m_pStreamMute->muteStream(muteRegId, action , EN_AUDIO_FADING_RES_BOOSTER,EN_AUDIO_SOURCE_STREAM_MIX2);
  m_pStreamMute->muteStream(muteRegId, action , EN_AUDIO_FADING_RES_BOOSTER,EN_AUDIO_SOURCE_STREAM_MIX3);
}
/********************************************************************************
 * vOnApplicationClose
 *******************************************************************************/
tVoid aud_sinkmgr_pwramp_g3g::vOnApplicationClose()
{
  ETG_TRACE_USR4(("vOnApplicationClose() entered."));
}

tVoid aud_sinkmgr_pwramp_g3g::vCheckPwrAmp()
{
  tBool bIsAdr3Running = vd_adr3_If::bGetAdr3StateRunning();
  tBool bIsBoosterOnTimerRunning = aud_sinkmgr_timer::bGetBoosterOnTimerRunning();
  ETG_TRACE_USR4(("vCheckPwrAmp() entered.aud_ubSinkState = %u, u8LowPowerActive = %u, u8HighPowerActive = %u, ADR3 running = %u, Bosster-ON timer running = %u"
      , aud_ubSinkState, u8LowPowerActive, u8HighPowerActive, bIsAdr3Running, bIsBoosterOnTimerRunning))

  switch(aud_ubSinkState)
  {
    case AUD_SINK_STATE_OFF:
      {
      if((u8LowPowerActive)||(u8HighPowerActive)||(bIsAdr3Running == FALSE))
  {
    ETG_TRACE_USR4(("vCheckPwrAmp() AUD_SINK_STATE_OFF Preconditions not met yet"))
        return;
  }

      //set sink mute
      vMuteSink();
      vd_adr3Msg_If::vReloadADRData();

      aud_ubSinkState = AUD_SINK_STATE_ON_IP;

      if(!(aud_sinkmgr_timer::bGetBoosterOnTimerRunning()))
  {
    aud_sinkmgr_timer::vStartTimer( AUD_SINKMANAGER_TIMER_ID_WAIT_TO_SWITCH_ON_EXT_BOOSTER, AUD_SINKMANAGER_TIMER_FROM_ON_IP_TO_ON_NO_EXT_BOOSTER);
  }

      //set ADR power state to ON
      tenAdrPowerState ubPowerState = EN_AUDIO_ADR_POWER_STATE_ON;
      ID_PowerState setPowerState(ubPowerState, VD_ADR3_OPTYPE_SETGET);
      InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&setPowerState);
      }
      break;

    case AUD_SINK_STATE_ON_IP:
      {
      if((u8LowPowerActive)||(u8HighPowerActive)||(vd_adr3_If::bGetAdr3StateRunning() == FALSE))
      {
        aud_ubSinkState = AUD_SINK_STATE_OFF;
      }
      else if(!(aud_sinkmgr_timer::bGetBoosterOnTimerRunning()))
      {
        vCheckPwrAmpTmr();
      }
      break;
      }
    case AUD_SINK_STATE_ON:
      {
      if((u8LowPowerActive)||(u8HighPowerActive)||(bIsAdr3Running == FALSE))
  {
    aud_ubSinkState = AUD_SINK_STATE_OFF;
  }
      else if ( m_enAudioState == EN_AUDIO_STATE_ON )
  {
    ETG_TRACE_USR4(("vCheckPwrAmp() AUDIO_STATE_ON.aud_ubSinkState = %u ", aud_ubSinkState));
    aud_ubSinkState = AUD_SINK_STATE_DEMUTE_IP;

    tenAdrPowerState ubPowerState = EN_AUDIO_ADR_POWER_STATE_ON;
    ID_PowerState setPowerState(ubPowerState, VD_ADR3_OPTYPE_SETGET);
    InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&setPowerState);

    aud_sinkmgr_timer::vStartTimer( AUD_SINKMANAGER_TIMER_ID_DEMUTE, AUD_SINKMANAGER_TIMER_DEMUTE_NO_EXT_BOOSTER_INTERVAL);
  }
      break;
      }
    case AUD_SINK_STATE_DEMUTE_IP:
    case AUD_SINK_STATE_MUTE_IP:
      {
  if((u8LowPowerActive)||(u8HighPowerActive)||(bIsAdr3Running == FALSE))
    {
      aud_ubSinkState = AUD_SINK_STATE_OFF;
    }
      }
      break;
    case AUD_SINK_STATE_DEMUTED:
      {
      if ( m_enAudioState != EN_AUDIO_STATE_ON )
  {
    aud_ubSinkState = AUD_SINK_STATE_MUTED;

    aud_sinkmgr_timer::vStopTimer(AUD_SINKMANAGER_TIMER_ID_DEMUTE);
    vMuteSink();

    aud_sinkmgr_timer::vStartTimer( AUD_SINKMANAGER_TIMER_ID_ADR3_STANDBY, AUD_SINKMANAGER_TIMER_ADR3_STANDBY_INTERVAL);

    tenAdrPowerState ubPowerState = EN_AUDIO_ADR_POWER_STATE_OFF;
    ID_PowerState setPowerState(ubPowerState, VD_ADR3_OPTYPE_SETGET);
    InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&setPowerState);

    aud_ubSinkState = AUD_SINK_STATE_MUTED;
  }
      else if((u8LowPowerActive)||(u8HighPowerActive)||
    (bIsAdr3Running == FALSE))
  {
        tenAdrPowerState ubPowerState = EN_AUDIO_ADR_POWER_STATE_OFF;
        ID_PowerState setPowerState(ubPowerState, VD_ADR3_OPTYPE_SETGET);
        InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&setPowerState);
        aud_ubSinkState = AUD_SINK_STATE_OFF;
  }
      break;
      }
    case AUD_SINK_STATE_MUTED:
      {
      if((u8LowPowerActive)||(u8HighPowerActive)||(bIsAdr3Running == FALSE))
  {
    aud_ubSinkState = AUD_SINK_STATE_OFF;
  }
      else if ( m_enAudioState == EN_AUDIO_STATE_ON )
  {
    aud_sinkmgr_timer::vStopTimer(AUD_SINKMANAGER_TIMER_ID_BOOSTER_OFF);
    aud_sinkmgr_timer::vStopTimer(AUD_SINKMANAGER_TIMER_ID_ADR3_STANDBY);

    aud_ubSinkState = AUD_SINK_STATE_DEMUTE_IP;
    tenAdrPowerState ubPowerState = EN_AUDIO_ADR_POWER_STATE_ON;
    ID_PowerState setPowerState(ubPowerState, VD_ADR3_OPTYPE_SETGET);
    InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&setPowerState);
    vMuteSink();
    aud_sinkmgr_timer::vStartTimer( AUD_SINKMANAGER_TIMER_ID_DEMUTE, AUD_SINKMANAGER_TIMER_DEMUTE_NO_EXT_BOOSTER_INTERVAL);
  }
      break;
      }
    case AUD_SINK_STATE_STANDBY:
      {
      if ((m_enAudioState == EN_AUDIO_STATE_ON) && (bIsAdr3Running == TRUE))
  {
    aud_ubSinkState = AUD_SINK_STATE_ON_IP;
    //set ADR power state to ON
    tenAdrPowerState ubPowerState = EN_AUDIO_ADR_POWER_STATE_ON;
    ID_PowerState setPowerState(ubPowerState, VD_ADR3_OPTYPE_SETGET);
    InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&setPowerState);

    aud_sinkmgr_timer::vStartTimer( AUD_SINKMANAGER_TIMER_ID_WAIT_TO_SWITCH_ON_EXT_BOOSTER, AUD_SINKMANAGER_TIMER_FROM_ON_IP_TO_ON_NO_EXT_BOOSTER);

    //check pending messages
    vd_adr3_main::vSendAdr3WorkerThreadEvent((tU32) EVENT_VD_ADR3_CHECK_NEXT_MESSAGE);
  }
      else if((u8LowPowerActive)||(u8HighPowerActive)||(bIsAdr3Running == FALSE))
  {
    aud_ubSinkState = AUD_SINK_STATE_OFF;
  }
      else if(aud_sinkmgr_main::ubGetApplicationState() == AUD_APP_PWR_EVENT_APP_OFF)
  {
    tenAdrPowerState ubPowerState = EN_AUDIO_ADR_POWER_STATE_STANDBY;
    ID_PowerState setPowerState(ubPowerState, VD_ADR3_OPTYPE_SETGET);
    InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&setPowerState);
    aud_ubSinkState = AUD_SINK_STATE_OFF;
  }
      break;
      }
    default:
      break;

  }
  ETG_TRACE_USR4(("vCheckPwrAmp() end.   aud_ubSinkState = %u ", aud_ubSinkState));
}

tVoid aud_sinkmgr_pwramp_g3g::vCheckPwrAmpTmr()
{
  tenAdrPowerState ubPowerState;
  tBool bIsAdr3Running = vd_adr3_If::bGetAdr3StateRunning();
  tBool bIsBoosterOnTimerRunning = aud_sinkmgr_timer::bGetBoosterOnTimerRunning();
  tBool bIsDemuteTimerRunning = aud_sinkmgr_timer::bGetDemuteTimerRunning();
  ETG_TRACE_USR4(("vCheckPwrAmpTmr() entered. aud_ubSinkState = %u, u8LowPowerActive = %u, u8HighPowerActive = %u,"
        "ADR3 running = %u, Bosster-ON timer running = %u, demute timer running = %u"
        , aud_ubSinkState, u8LowPowerActive, u8HighPowerActive, bIsAdr3Running, bIsBoosterOnTimerRunning, bIsDemuteTimerRunning))

  switch(aud_ubSinkState)
  {
  case AUD_SINK_STATE_ON_IP:
    //low power
    if((u8LowPowerActive)||(u8HighPowerActive)||(bIsAdr3Running== FALSE))
    {
      aud_ubSinkState = AUD_SINK_STATE_OFF;
    }
    else if((!(bIsBoosterOnTimerRunning) ||(vd_adr3Msg_powerState::ubGetAdr3PowerState() == EN_AUDIO_ADR_POWER_STATE_ON)))
    {
      aud_ubSinkState = AUD_SINK_STATE_ON;
      aud_sinkmgr_timer::vStopTimer( AUD_SINKMANAGER_TIMER_ID_WAIT_TO_SWITCH_ON_EXT_BOOSTER);
      vCheckPwrAmp();
    }

    break;
  case AUD_SINK_STATE_DEMUTE_IP:
    if((u8LowPowerActive)||(u8HighPowerActive)||(bIsAdr3Running == FALSE))
      {
  ubPowerState = EN_AUDIO_ADR_POWER_STATE_OFF;
  ID_PowerState setPowerState(ubPowerState, VD_ADR3_OPTYPE_SETGET);
  InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&setPowerState);
  aud_ubSinkState = AUD_SINK_STATE_OFF;
      }
    else if ( m_enAudioState != EN_AUDIO_STATE_ON )
      {
  aud_ubSinkState = AUD_SINK_STATE_MUTE_IP;

  aud_sinkmgr_timer::vStopTimer(AUD_SINKMANAGER_TIMER_ID_DEMUTE);

  aud_sinkmgr_timer::vStartTimer( AUD_SINKMANAGER_TIMER_ID_ADR3_STANDBY, AUD_SINKMANAGER_TIMER_ADR3_STANDBY_INTERVAL);
  //aud_sinkmgr_timer::vStartTimer( AUD_SINKMANAGER_TIMER_ID_BOOSTER_OFF, AUD_SINKMANAGER_TIMER_BOOSTER_OFF_INTERVAL);

  ubPowerState = EN_AUDIO_ADR_POWER_STATE_OFF;
  ID_PowerState setPowerState(ubPowerState, VD_ADR3_OPTYPE_SETGET);
  InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&setPowerState);

  aud_ubSinkState = AUD_SINK_STATE_MUTED;

      }
    else if(bIsDemuteTimerRunning)
    {
      //wait for timer to expire
    }
    else
    {
      aud_ubSinkState = AUD_SINK_STATE_DEMUTED;
      vDemuteSink();
    }
    break;

  case AUD_SINK_STATE_MUTE_IP:
    {
    ubPowerState = EN_AUDIO_ADR_POWER_STATE_OFF;
    ID_PowerState setPowerState(ubPowerState, VD_ADR3_OPTYPE_SETGET);
    InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&setPowerState);
    aud_ubSinkState = AUD_SINK_STATE_MUTED;
    if((u8LowPowerActive)||(u8HighPowerActive)||(vd_adr3_If::bGetAdr3StateRunning() == FALSE))
    {
      aud_ubSinkState = AUD_SINK_STATE_OFF;
    }
    break;
    }
  case AUD_SINK_STATE_MUTED:
    {
    aud_ubSinkState = AUD_SINK_STATE_STANDBY;
    if((u8LowPowerActive)||(u8HighPowerActive)||(bIsAdr3Running == FALSE))
    {
      aud_ubSinkState = AUD_SINK_STATE_OFF;
    }
    else
    {
      //switch ADRPowerState to STANDBY
      ubPowerState = EN_AUDIO_ADR_POWER_STATE_STANDBY;
      ID_PowerState setPowerState(ubPowerState, VD_ADR3_OPTYPE_SETGET);
      InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&setPowerState);
    }
    break;
    }
  default:
    break;
  }
  ETG_TRACE_USR4(("vCheckPwrAmpTmr() end.   aud_ubSinkState = %u ", aud_ubSinkState))
}
/********************************************************************************
 * vSetSpecialMute()
 *******************************************************************************/
void aud_sinkmgr_pwramp_g3g::vSetSpecialMute(tU8 ubOnOff)
{
  ETG_TRACE_USR4(("vSetSpecialMute()ubOnOff=%u",(tU8) ubOnOff));

  if(ubOnOff == 1)
  {
    vMuteSink();
  }
  else
  {
    vDemuteSink();
  }
}

/********************************************************************************
 * vSetLowPowerFlag().
 *******************************************************************************/
tVoid aud_sinkmgr_pwramp_g3g::vSetLowPowerFlag(tU8 ubOnOff)
{
  ETG_TRACE_USR4(("aud_sinkmgr_pwramp_PSA vSetLowPowerFlag() entered.ubOnOff = %u",ubOnOff));
  u8LowPowerActive = ubOnOff;

  vCheckPwrAmp();
}

/********************************************************************************
 * vSetHighPowerFlag().
 *******************************************************************************/
tVoid aud_sinkmgr_pwramp_g3g::vSetHighPowerFlag(tU8 ubOnOff)
{
  ETG_TRACE_USR4(("aud_sinkmgr_pwramp_PSA vSetHighPowerFlag() entered.ubOnOff = %u",ubOnOff));
  u8HighPowerActive = ubOnOff;

  vCheckPwrAmp();
}

/********************************************************************************
 * ubGetLowPowerFlag().
 *******************************************************************************/
tU8 aud_sinkmgr_pwramp_g3g::ubGetLowPowerActiveFlag()
{
   return u8LowPowerActive;
}

/********************************************************************************
 * SetSoundConfig()
 *******************************************************************************/
void aud_sinkmgr_pwramp_g3g::SetSoundConfig(tU8 ubSoundConfig)
{
  ETG_TRACE_USR4(("SetSoundConfig ubSoundConfig = %u",(tU8) ubSoundConfig));

  aud_ubExtBooster = ubSoundConfig;
}

/********************************************************************************
 * StreamMuteNotify()
 *******************************************************************************/
void aud_sinkmgr_pwramp_g3g::StreamMuteNotify(tenMuteNotification muteAck, tU8 stream, tU16 sink)
{

  ETG_TRACE_USR4(("StreamMuteNotify()muteAck=%u,stream = %u, sink %d",(tU8) muteAck, stream, sink));

  tenMuteResult muteResult = EN_AUDIO_MUTE_MUTERESULT_MUTE;
  switch(muteAck)
  {
  case MUTE_ACK_DEMUTE:
    muteResult = EN_AUDIO_MUTE_MUTERESULT_DEMUTE;
    break;
  case MUTE_ACK_DEMUTE_RUNNING:
    muteResult = EN_AUDIO_MUTE_MUTERESULT_DEMUTE_RUNNING;
    break;
  default:
    break;
  }
  ETG_TRACE_USR4(("StreamMuteNotify()muteResult=%u",(tU8) muteResult));
}
